/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.config;

import com.copycatsplus.copycats.config.FeatureCategory;
import com.copycatsplus.copycats.config.FeatureToggle;
import com.copycatsplus.copycats.config.SyncConfigBase;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.jetbrains.annotations.ApiStatus;

public class CFeatureCategories
extends SyncConfigBase {
    final Map<FeatureCategory, ForgeConfigSpec.ConfigValue<Boolean>> toggles = new HashMap<FeatureCategory, ForgeConfigSpec.ConfigValue<Boolean>>();
    Map<FeatureCategory, Boolean> synchronizedToggles;

    public String getName() {
        return "feature_categories";
    }

    public void registerAll(ForgeConfigSpec.Builder builder) {
        for (FeatureCategory r : FeatureCategory.values()) {
            builder.comment(new String[]{".", r.getDescription()});
            this.toggles.put(r, (ForgeConfigSpec.ConfigValue<Boolean>)builder.define(r.m_7912_(), true));
        }
    }

    @ApiStatus.Internal
    public boolean isEnabled(FeatureCategory category) {
        Boolean synced;
        if (this.synchronizedToggles != null && (synced = this.synchronizedToggles.get((Object)category)) != null) {
            return synced;
        }
        ForgeConfigSpec.ConfigValue<Boolean> value = this.toggles.get((Object)category);
        if (value != null) {
            return (Boolean)value.get();
        }
        return true;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        FeatureToggle.refreshItemVisibility();
    }

    @Override
    public void onReload() {
        super.onReload();
        FeatureToggle.refreshItemVisibility();
    }

    @Override
    protected void readSyncConfig(CompoundTag nbt) {
        this.synchronizedToggles = new HashMap<FeatureCategory, Boolean>();
        for (String key : nbt.m_128431_()) {
            FeatureCategory category = FeatureCategory.byName(key);
            this.synchronizedToggles.put(category, nbt.m_128471_(key));
        }
        FeatureToggle.refreshItemVisibility();
    }

    @Override
    protected ModConfig.Type type() {
        return ModConfig.Type.COMMON;
    }

    @Override
    protected void writeSyncConfig(CompoundTag nbt) {
        this.toggles.forEach((key, value) -> nbt.m_128379_(key.toString(), ((Boolean)value.get()).booleanValue()));
    }
}

