/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.common.network;

import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.JustEnoughGuns;
import ttv.migami.jeg.common.FireMode;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.ProjectileManager;
import ttv.migami.jeg.common.ReloadTracker;
import ttv.migami.jeg.common.ReloadType;
import ttv.migami.jeg.common.ShootTracker;
import ttv.migami.jeg.common.SpreadTracker;
import ttv.migami.jeg.common.container.AttachmentContainer;
import ttv.migami.jeg.crafting.handler.IModularWorkbenchContainer;
import ttv.migami.jeg.crafting.workbench.AbstractWorkbenchRecipe;
import ttv.migami.jeg.crafting.workbench.WorkbenchRecipes;
import ttv.migami.jeg.entity.monster.phantom.gunner.PhantomGunner;
import ttv.migami.jeg.entity.monster.phantom.terror.TerrorPhantom;
import ttv.migami.jeg.entity.projectile.FlareProjectileEntity;
import ttv.migami.jeg.entity.projectile.ProjectileEntity;
import ttv.migami.jeg.event.BurstFireEvent;
import ttv.migami.jeg.event.GunFireEvent;
import ttv.migami.jeg.init.ModEnchantments;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModSounds;
import ttv.migami.jeg.init.ModSyncedDataKeys;
import ttv.migami.jeg.interfaces.IProjectileFactory;
import ttv.migami.jeg.item.AnimatedGunItem;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.item.attachment.IAttachment;
import ttv.migami.jeg.network.PacketHandler;
import ttv.migami.jeg.network.message.C2SMessagePreFireSound;
import ttv.migami.jeg.network.message.C2SMessageShoot;
import ttv.migami.jeg.network.message.S2CMessageBulletTrail;
import ttv.migami.jeg.network.message.S2CMessageGunSound;
import ttv.migami.jeg.util.DyeUtils;
import ttv.migami.jeg.util.GunEnchantmentHelper;
import ttv.migami.jeg.util.GunModifierHelper;

public class ServerPlayHandler {
    private static final Predicate<LivingEntity> HOSTILE_ENTITIES = entity -> (entity.m_5720_() == SoundSource.HOSTILE || entity.m_6095_() == EntityType.f_20511_ || entity.m_6095_() == EntityType.f_20531_) && !((List)Config.COMMON.aggroMobs.exemptEntities.get()).contains(EntityType.m_20613_((EntityType)entity.m_6095_()).toString()) && entity.m_6095_() != EntityType.f_20566_ && !(entity instanceof TerrorPhantom) && !(entity instanceof PhantomGunner);
    private static final Predicate<LivingEntity> FLEEING_ENTITIES = entity -> ((List)Config.COMMON.fleeingMobs.fleeingEntities.get()).contains(EntityType.m_20613_((EntityType)entity.m_6095_()).toString());

    public static BlockPos rayTrace(Player pPlayer, double distance) {
        HitResult rayTraceResult = pPlayer.m_19907_(distance, 1.0f, false);
        return BlockPos.m_274446_((Position)rayTraceResult.m_82450_());
    }

    public static EntityHitResult hitEntity(Level pLevel, Player pPlayer, BlockPos blockPos) {
        return ProjectileUtil.m_37304_((Level)pLevel, (Entity)pPlayer, (Vec3)pPlayer.m_146892_(), (Vec3)blockPos.m_252807_(), (AABB)new AABB(pPlayer.m_146892_(), blockPos.m_252807_()), ServerPlayHandler::canDamage);
    }

    public static boolean canDamage(Entity entity) {
        return entity instanceof LivingEntity;
    }

    public static void toggleMedals(Player player) {
        ItemStack item = player.m_21205_();
        if (item.m_41720_() instanceof GunItem && item.m_41783_() != null) {
            item.m_41783_().m_128379_("MedalsEnabled", !item.m_41783_().m_128471_("MedalsEnabled"));
        }
    }

    public static void unjam(Player player) {
        ItemStack itemStack = player.m_21205_();
        CompoundTag nbtCompound = itemStack.m_41784_();
        if (itemStack.m_41720_() instanceof AnimatedGunItem) {
            nbtCompound.m_128473_("IsJammed");
        }
    }

    public static void overheat(Player player) {
        ServerPlayHandler.sendParticlesToAll((ServerLevel)player.m_9236_(), ParticleTypes.f_123796_, true, player.m_20185_() - player.m_20184_().m_7096_() + player.m_20154_().m_82542_((double)1.0, (double)1.0, (double)1.0).f_82479_, player.m_20188_() - 0.1 - player.m_20184_().m_7098_() + player.m_20154_().m_82542_((double)1.0, (double)1.0, (double)1.0).f_82480_, player.m_20189_() - player.m_20184_().m_7094_() + player.m_20154_().m_82542_((double)1.0, (double)1.0, (double)1.0).f_82481_, 5, 0.1, 0.1, 0.1, 0.01);
        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11937_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void handleShoot(C2SMessageShoot message, ServerPlayer player) {
        if (player.m_5833_()) {
            return;
        }
        if (player.m_21211_().m_41720_() instanceof ShieldItem) {
            return;
        }
        Level world = player.m_9236_();
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem) {
            GunItem item2 = (GunItem)item;
            if (Gun.hasAmmo(heldItem) || player.m_7500_()) {
                int level;
                CompoundTag tag;
                Gun modifiedGun = item2.getModifiedGun(heldItem);
                if (modifiedGun == null) return;
                if (MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Pre((Player)player, heldItem))) {
                    return;
                }
                player.m_146922_(Mth.m_14177_((float)message.getRotationYaw()));
                player.m_146926_(Mth.m_14036_((float)message.getRotationPitch(), (float)-90.0f, (float)90.0f));
                ShootTracker tracker = ShootTracker.getShootTracker((Player)player);
                if (tracker.hasCooldown(item2) && tracker.getRemaining(item2) > (long)((Integer)Config.SERVER.cooldownThreshold.get()).intValue()) {
                    JustEnoughGuns.LOGGER.warn(player.m_7755_().m_214077_() + "(" + player.m_20148_() + ") tried to fire before cooldown finished or server is lagging? Remaining milliseconds: " + tracker.getRemaining(item2));
                    return;
                }
                tracker.putCooldown(heldItem, item2, modifiedGun);
                if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
                    ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                }
                if (!modifiedGun.getGeneral().isAlwaysSpread() && modifiedGun.getGeneral().getSpread() > 0.0f) {
                    SpreadTracker.get((Player)player).update((Player)player, item2);
                }
                if (modifiedGun.getProjectile().hasProjectile()) {
                    int count = modifiedGun.getGeneral().getProjectileAmount();
                    Gun.Projectile projectileProps = modifiedGun.getProjectile();
                    ProjectileEntity[] spawnedProjectiles = new ProjectileEntity[count];
                    for (int i = 0; i < count; ++i) {
                        IProjectileFactory factory = ProjectileManager.getInstance().getFactory(projectileProps.getItem());
                        ProjectileEntity projectileEntity = factory.create(world, (LivingEntity)player, heldItem, item2, modifiedGun);
                        projectileEntity.setWeapon(heldItem);
                        projectileEntity.setAdditionalDamage(Gun.getAdditionalDamage(heldItem));
                        world.m_7967_((Entity)projectileEntity);
                        spawnedProjectiles[i] = projectileEntity;
                        projectileEntity.m_8119_();
                        if (!(projectileEntity instanceof FlareProjectileEntity)) continue;
                        FlareProjectileEntity flareProjectileEntity = (FlareProjectileEntity)projectileEntity;
                        if (!DyeUtils.hasDye(heldItem)) continue;
                        flareProjectileEntity.setColor(DyeUtils.getStoredDyeRGB(heldItem));
                        flareProjectileEntity.setCustomColored(true);
                    }
                    if (!modifiedGun.getProjectile().hideTrail() && !projectileProps.isVisible()) {
                        double spawnX = player.m_20185_();
                        double spawnY = player.m_20186_() + 1.0;
                        double spawnZ = player.m_20189_();
                        double radius = (Double)Config.COMMON.network.projectileTrackingRange.get();
                        ParticleOptions data = GunEnchantmentHelper.getParticle(heldItem);
                        boolean isVisible = !modifiedGun.getProjectile().hideTrail();
                        S2CMessageBulletTrail messageBulletTrail = new S2CMessageBulletTrail(spawnedProjectiles, projectileProps, player.m_19879_(), data, isVisible);
                        PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)spawnX, (double)spawnY, (double)spawnZ, (double)radius), (IMessage)messageBulletTrail);
                    }
                }
                MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Post((Player)player, heldItem));
                ResourceLocation fireSound = ServerPlayHandler.getFireSound((Player)player, heldItem, modifiedGun);
                if (fireSound != null) {
                    boolean muzzle;
                    double posX = player.m_20185_();
                    double posY = player.m_20186_() + (double)player.m_20192_();
                    double posZ = player.m_20189_();
                    float volume = ((Integer)Config.COMMON.world.playerGunfireVolume.get()).intValue();
                    float selfVolume = 0.5f;
                    float pitch = 0.9f + world.f_46441_.m_188501_() * 0.2f;
                    if (player.m_5842_()) {
                        pitch = 0.7f + world.f_46441_.m_188501_() * 0.2f;
                        volume /= 2.0f;
                    }
                    double radius = GunModifierHelper.getModifiedFireSoundRadius(heldItem, (Double)Config.SERVER.gunShotMaxDistance.get());
                    boolean bl = muzzle = modifiedGun.getDisplay().getFlash() != null;
                    if (player.m_5842_()) {
                        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11777_, SoundSource.PLAYERS, 10.0f, 1.7f);
                    }
                    player.m_9236_().m_6263_((Player)player, posX, posY, posZ, SoundEvent.m_262824_((ResourceLocation)fireSound), SoundSource.PLAYERS, volume - 0.5f, pitch);
                    S2CMessageGunSound messageSound = new S2CMessageGunSound(fireSound, SoundSource.PLAYERS, (float)posX, (float)posY, (float)posZ, selfVolume, pitch, player.m_19879_(), muzzle, false);
                    PacketHandler.getPlayChannel().sendToPlayer(() -> player, (IMessage)messageSound);
                }
                if (Gun.getAttachment(IAttachment.Type.BARREL, heldItem).m_41720_() == ModItems.TRUMPET.get()) {
                    world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.DOOT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                if (Gun.getAttachment(IAttachment.Type.BARREL, heldItem).m_41720_() == ModItems.EXPLOSIVE_MUZZLE.get()) {
                    world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11874_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                if (!(player.m_7500_() || (tag = heldItem.m_41784_()).m_128471_("IgnoreAmmo") || (level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.RECLAIMED.get()), (ItemStack)heldItem)) != 0 && player.m_9236_().f_46441_.m_188503_(4 - Mth.m_14045_((int)level, (int)1, (int)2)) == 0)) {
                    tag.m_128405_("AmmoCount", Math.max(0, tag.m_128451_("AmmoCount") - 1));
                    if (modifiedGun.getReloads().getReloadType().equals(ReloadType.INVENTORY_FED)) {
                        ReloadTracker.inventoryFeed((Player)player, modifiedGun);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item2));
                boolean isSilenced = Gun.getAttachment(IAttachment.Type.BARREL, heldItem).m_41720_() == ModItems.SILENCER.get() || modifiedGun.getGeneral().isSilenced();
                if (!(player.m_9236_().f_46441_.m_188501_() <= 0.1f)) return;
                if (isSilenced) return;
                if (!((Boolean)Config.COMMON.aggroMobs.enabled.get()).booleanValue()) {
                    if ((Boolean)Config.COMMON.fleeingMobs.enabled.get() == false) return;
                }
                ServerPlayHandler.tryToAlertEntities((Player)player, heldItem);
                return;
            }
        }
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, 0.8f);
    }

    public static void doPanicEntities(LivingEntity player, Vec3 pos, int radius) {
        AABB box = new AABB(pos.f_82479_ - (double)radius, pos.f_82480_ - (double)radius, pos.f_82481_ - (double)radius, pos.f_82479_ + (double)radius, pos.f_82480_ + (double)radius, pos.f_82481_ + (double)radius);
        List allEntities = player.m_9236_().m_45976_(LivingEntity.class, box);
        for (LivingEntity entity : allEntities) {
            double speedMultiplier;
            if (!(entity instanceof PathfinderMob)) continue;
            PathfinderMob mob = (PathfinderMob)entity;
            mob.m_6274_().m_21936_(MemoryModuleType.f_26381_);
            mob.m_6274_().m_21936_(MemoryModuleType.f_26382_);
            mob.m_21573_().m_26573_();
            double d = speedMultiplier = entity.m_6095_() == EntityType.f_20492_ ? 1.0 : 1.5;
            Vec3 randomPos = LandRandomPos.m_148488_((PathfinderMob)mob, (int)16, (int)7);
            if (randomPos == null) continue;
            mob.m_21573_().m_26519_(randomPos.f_82479_, randomPos.f_82480_, randomPos.f_82481_, speedMultiplier);
        }
    }

    public static void doPanicVillagersAndHostiles(LivingEntity player, Vec3 pos, int radius) {
        AABB box = new AABB(pos.f_82479_ - (double)radius, pos.f_82480_ - (double)radius, pos.f_82481_ - (double)radius, pos.f_82479_ + (double)radius, pos.f_82480_ + (double)radius, pos.f_82481_ + (double)radius);
        List allEntities = player.m_9236_().m_45976_(LivingEntity.class, box);
        for (LivingEntity entity : allEntities) {
            double speedMultiplier;
            if (!(entity instanceof PathfinderMob)) continue;
            PathfinderMob mob = (PathfinderMob)entity;
            if ((!((Boolean)Config.COMMON.fleeingMobs.enabled.get()).booleanValue() || !(entity instanceof Villager)) && (!((Boolean)Config.COMMON.aggroMobs.enabled.get()).booleanValue() || !HOSTILE_ENTITIES.test(entity))) continue;
            mob.m_6274_().m_21936_(MemoryModuleType.f_26381_);
            mob.m_6274_().m_21936_(MemoryModuleType.f_26382_);
            mob.m_21573_().m_26573_();
            double d = speedMultiplier = entity.m_6095_() == EntityType.f_20492_ ? 1.0 : 1.5;
            Vec3 randomPos = LandRandomPos.m_148488_((PathfinderMob)mob, (int)16, (int)7);
            if (randomPos == null) continue;
            mob.m_21573_().m_26519_(randomPos.f_82479_, randomPos.f_82480_, randomPos.f_82481_, speedMultiplier);
        }
    }

    private static void tryToAlertEntities(Player player, ItemStack heldItem) {
        double aggroRadius = GunModifierHelper.getModifiedFireSoundRadius(heldItem, (Double)Config.COMMON.aggroMobs.unsilencedRange.get());
        double fleeRadius = GunModifierHelper.getModifiedFireSoundRadius(heldItem, (Double)Config.COMMON.fleeingMobs.unsilencedRange.get());
        AABB playerBox = player.m_20191_();
        AABB inflatedBox = playerBox.m_82377_(Math.max(aggroRadius, fleeRadius), Math.max(aggroRadius, fleeRadius), Math.max(aggroRadius, fleeRadius));
        List allEntities = player.m_9236_().m_45976_(LivingEntity.class, inflatedBox);
        for (LivingEntity entity : allEntities) {
            double speedMultiplier;
            Wolf wolf;
            PathfinderMob mob;
            if (((Boolean)Config.COMMON.aggroMobs.enabled.get()).booleanValue() && HOSTILE_ENTITIES.test(entity)) {
                if (entity instanceof ZombifiedPiglin) {
                    ZombifiedPiglin zombifiedPiglin = (ZombifiedPiglin)entity;
                    zombifiedPiglin.m_6925_(player.m_20148_());
                    zombifiedPiglin.m_7870_(400 + player.m_9236_().f_46441_.m_188503_(400));
                } else if (entity instanceof Piglin) {
                    Piglin piglin = (Piglin)entity;
                    piglin.m_6710_((LivingEntity)player);
                    piglin.m_21561_(true);
                } else {
                    entity.m_6703_((LivingEntity)player);
                }
            }
            if (!((Boolean)Config.COMMON.fleeingMobs.enabled.get()).booleanValue() || !FLEEING_ENTITIES.test(entity) || !(entity instanceof PathfinderMob) || (mob = (PathfinderMob)entity) instanceof Wolf && ((wolf = (Wolf)mob).m_21824_() || wolf.m_21825_())) continue;
            mob.m_6274_().m_21936_(MemoryModuleType.f_26381_);
            mob.m_6274_().m_21936_(MemoryModuleType.f_26382_);
            mob.m_21573_().m_26573_();
            double d = speedMultiplier = entity.m_6095_() == EntityType.f_20492_ ? 1.0 : 1.5;
            Vec3 randomPos = LandRandomPos.m_148488_((PathfinderMob)mob, (int)16, (int)7);
            if (randomPos == null) continue;
            mob.m_21573_().m_26519_(randomPos.f_82479_, randomPos.f_82480_, randomPos.f_82481_, speedMultiplier);
        }
    }

    public static void handlePreFireSound(C2SMessagePreFireSound message, ServerPlayer player) {
        Level world = player.m_9236_();
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem) {
            Gun modifiedGun;
            ResourceLocation fireSound;
            GunItem item2 = (GunItem)item;
            if ((Gun.hasAmmo(heldItem) || player.m_7500_()) && (fireSound = ServerPlayHandler.getPreFireSound(heldItem, modifiedGun = item2.getModifiedGun(heldItem))) != null) {
                double posX = player.m_20185_();
                double posY = player.m_20186_() + (double)player.m_20192_();
                double posZ = player.m_20189_();
                float volume = GunModifierHelper.getFireSoundVolume(heldItem);
                float pitch = 0.9f + world.f_46441_.m_188501_() * 0.2f;
                double radius = GunModifierHelper.getModifiedFireSoundRadius(heldItem, (Double)Config.SERVER.gunShotMaxDistance.get());
                S2CMessageGunSound messageSound = new S2CMessageGunSound(fireSound, SoundSource.PLAYERS, (float)posX, (float)posY, (float)posZ, volume, pitch, player.m_19879_(), false, false);
                PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)posX, (double)posY, (double)posZ, (double)radius), (IMessage)messageSound);
            }
        }
    }

    public static void handleBurst(ServerPlayer player) {
        GunItem gunItem;
        Gun gun;
        ItemStack heldItem = player.m_21205_();
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem && (gun = (gunItem = (GunItem)item).getModifiedGun(heldItem)).getGeneral().getFireMode() == FireMode.BURST) {
            BurstFireEvent.resetBurst(heldItem);
        }
    }

    public static ResourceLocation getFireSound(Player player, ItemStack stack, Gun modifiedGun) {
        ResourceLocation fireSound = null;
        if (GunModifierHelper.isSilencedFire(stack)) {
            fireSound = modifiedGun.getSounds().getSilencedFire();
        } else if (!player.m_5842_() && stack.m_41793_() && ((Boolean)Config.CLIENT.sounds.enchantSound.get()).booleanValue()) {
            fireSound = modifiedGun.getSounds().getEnchantedFire();
        }
        if (fireSound != null) {
            return fireSound;
        }
        return modifiedGun.getSounds().getFire();
    }

    public static ResourceLocation getPreFireSound(ItemStack stack, Gun modifiedGun) {
        return modifiedGun.getSounds().getPreFire();
    }

    public static <T extends ParticleOptions> void sendParticlesToAll(ServerLevel serverLevel, T particleType, boolean longDistance, double posX, double posY, double posZ, int particleCount, double offsetX, double offsetY, double offsetZ, double speed) {
        for (ServerPlayer player : serverLevel.m_6907_()) {
            serverLevel.m_8624_(player, particleType, longDistance, posX, posY, posZ, particleCount, offsetX, offsetY, offsetZ, speed);
        }
    }

    public static void handleCraft(ServerPlayer player, ResourceLocation id, BlockPos pos) {
        Level world = player.m_9236_();
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (!(abstractContainerMenu instanceof IModularWorkbenchContainer)) {
            return;
        }
        IModularWorkbenchContainer container = (IModularWorkbenchContainer)abstractContainerMenu;
        if (!container.getPos().equals((Object)pos)) {
            return;
        }
        RecipeType<?> type = container.getRecipeType();
        AbstractWorkbenchRecipe recipe = (AbstractWorkbenchRecipe)WorkbenchRecipes.getRecipeById(world, id, type);
        if (recipe == null || !recipe.hasMaterials((Player)player)) {
            return;
        }
        recipe.consumeMaterials((Player)player);
        ItemStack stack = recipe.getItem();
        Containers.m_18992_((Level)world, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 1.125), (double)((double)pos.m_123343_() + 0.5), (ItemStack)stack);
    }

    public static void stopSprinting(Player player) {
        player.m_6858_(false);
        if (player.m_9236_().f_46443_) {
            Minecraft.m_91087_().f_91066_.f_92091_.m_7249_(false);
        }
    }

    public static void handleCharge(Player player, Entity entity, float damage, float currentDamage, float maxDamage, ItemStack bayonet) {
        float finalDamage = damage;
        double sweepAngle = Math.toRadians(100.0);
        Vec3 playerPos = player.m_20182_();
        Vec3 lookVec = player.m_20154_();
        Vec3 entityPos = entity.m_20182_().m_82546_(playerPos);
        double angle = Math.acos(entityPos.m_82541_().m_82526_(lookVec.m_82541_()));
        if (angle < sweepAngle / 3.0 && entity != player && entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (target.f_19802_ == 0) {
                Vec3 direction = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_();
                player.f_19802_ = 40;
                if (GunModifierHelper.getSwordSweepingEdge(player) < 2) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 2, false, false));
                }
                target.m_5997_(direction.f_82479_ * (double)GunModifierHelper.getSwordKnockBack(player), 0.5, direction.f_82481_ * (double)GunModifierHelper.getSwordKnockBack(player));
                if ((double)currentDamage <= (double)maxDamage / 1.5) {
                    Level level;
                    target.m_6469_(player.m_269291_().m_269075_(player), GunModifierHelper.getSwordDamage(player) / 1.5f);
                    player.m_9236_().m_5594_(null, player.m_20097_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 2.0f, 1.0f);
                    if (GunModifierHelper.getSwordFireAspect(player) > 0) {
                        entity.m_20254_(2 * GunModifierHelper.getSwordFireAspect(player));
                    }
                    if ((level = player.m_9236_()) instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123798_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (int)finalDamage, 0.3, (double)entity.m_20206_(), 0.3, 0.2);
                    }
                } else {
                    player.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 3.0f, 1.0f);
                }
                Vec3 pushBackDirection = player.m_20182_().m_82546_(target.m_20182_()).m_82541_();
                double pushBackForce = 1.0;
                if (GunModifierHelper.getSwordSweepingEdge(player) < 3) {
                    player.m_5997_(pushBackDirection.f_82479_ * pushBackForce, 0.5, pushBackDirection.f_82481_ * pushBackForce);
                }
                if (!player.m_150110_().f_35937_ && ((Boolean)Config.COMMON.gameplay.gunDurability.get()).booleanValue() && (double)currentDamage <= (double)maxDamage / 1.5 && bayonet.getEnchantmentLevel(Enchantments.f_44962_) == 0) {
                    bayonet.m_41622_(15, (LivingEntity)player, e -> {});
                }
            }
        }
    }

    public static void handleMelee(ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        ItemCooldowns tracker = player.m_36335_();
        if (stack.m_41720_() instanceof GunItem && !tracker.m_41519_(stack.m_41720_())) {
            ItemStack flashlight;
            Level level = player.m_9236_();
            Item item = stack.m_41720_();
            if (item instanceof AnimatedGunItem) {
                AnimatedGunItem animatedGunItem = (AnimatedGunItem)item;
                if (stack.m_41783_() != null) {
                    if (stack.m_41783_().m_128471_("IsDrawing")) {
                        return;
                    }
                    animatedGunItem.resetTags(stack.m_41783_());
                    stack.m_41783_().m_128379_("IsMeleeing", true);
                }
            }
            if (Gun.hasAttachmentEquipped(player.m_21205_(), IAttachment.Type.SPECIAL) && Gun.getAttachment(IAttachment.Type.SPECIAL, player.m_21205_()).m_41720_() == ModItems.FLASHLIGHT.get() && (flashlight = Gun.getAttachment(IAttachment.Type.SPECIAL, player.m_21205_())).m_41783_() != null) {
                flashlight.m_41783_().m_128379_("Powered", !flashlight.m_41783_().m_128471_("Powered"));
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.FLASHLIGHT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (Gun.getAttachment(IAttachment.Type.BARREL, player.m_21205_()).m_41720_() instanceof SwordItem && player.m_20142_()) {
                Vec3 lookVec = player.m_20154_();
                double pushStrength = 1.0;
                player.m_5997_(lookVec.f_82479_ * pushStrength, lookVec.f_82480_ * pushStrength, lookVec.f_82481_ * pushStrength);
            }
            ItemStack bayonet = Gun.getAttachment(IAttachment.Type.BARREL, player.m_21205_());
            int maxDamage = bayonet.m_41776_();
            int currentDamage = bayonet.m_41773_();
            double attackRange = 2.0;
            double sweepAngle = Math.toRadians(100.0);
            Vec3 playerPos = player.m_20182_();
            Vec3 lookVec = player.m_20154_();
            List entities = level.m_45976_(LivingEntity.class, player.m_20191_().m_82400_(attackRange));
            level.m_5594_(null, player.m_20097_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 2.0f, 1.0f);
            int cooldown = 15;
            if (player.m_20142_()) {
                cooldown = 40;
            }
            tracker.m_41524_(stack.m_41720_(), cooldown);
            for (LivingEntity entity : entities) {
                Vec3 entityPos = entity.m_20182_().m_82546_(playerPos);
                double angle = Math.acos(entityPos.m_82541_().m_82526_(lookVec.m_82541_()));
                if (!(angle < sweepAngle / 2.0) || entity == player || player.m_9236_().f_46443_) continue;
                Vec3 direction = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_();
                entity.m_5997_(direction.f_82479_ * (double)GunModifierHelper.getSwordKnockBack((Player)player), 0.5, direction.f_82481_ * (double)GunModifierHelper.getSwordKnockBack((Player)player));
                if ((double)currentDamage <= (double)maxDamage / 1.5) {
                    entity.m_6469_(player.m_269291_().m_269075_((Player)player), GunModifierHelper.getSwordDamage((Player)player) / 1.5f);
                    if (GunModifierHelper.getSwordFireAspect((Player)player) > 0) {
                        entity.m_20254_(2 * GunModifierHelper.getSwordFireAspect((Player)player));
                    }
                } else {
                    level.m_5594_((Player)player, player.m_20097_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 3.0f, 1.0f);
                }
                if (player.m_150110_().f_35937_ || !((Boolean)Config.COMMON.gameplay.gunDurability.get()).booleanValue() || !((double)currentDamage <= (double)maxDamage / 1.5) || bayonet.getEnchantmentLevel(Enchantments.f_44962_) != 0) continue;
                bayonet.m_41622_(8, (LivingEntity)player, e -> {});
            }
            double offsetX = lookVec.f_82479_ * 1.8;
            double offsetY = lookVec.f_82480_ * 1.8 + (double)player.m_20192_();
            double offsetZ = lookVec.f_82481_ * 1.8;
            playerPos = player.m_20318_(1.0f).m_82520_(offsetX, offsetY, offsetZ);
            if (!level.f_46443_) {
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123766_, playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void handleReloadPerspective(ServerPlayer player, boolean firstPerson) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof GunItem && stack.m_41783_() != null) {
            stack.m_41783_().m_128379_("IsFirstPersonReload", firstPerson);
        }
    }

    public static void handleInspectGun(ServerPlayer player) {
        Item item;
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof GunItem && (item = stack.m_41720_()) instanceof AnimatedGunItem) {
            AnimatedGunItem animatedGunItem = (AnimatedGunItem)item;
            if (stack.m_41783_() != null) {
                if (stack.m_41783_().m_128471_("IsDrawing")) {
                    return;
                }
                animatedGunItem.resetTags(stack.m_41783_());
                stack.m_41783_().m_128379_("IsInspecting", true);
            }
        }
    }

    public static void handleUnload(ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            Item item2 = stack.m_41720_();
            if (item2 instanceof AnimatedGunItem) {
                AnimatedGunItem animatedGunItem = (AnimatedGunItem)item2;
                animatedGunItem.resetTags(stack);
            }
            Gun gun = gunItem.getModifiedGun(stack);
            CompoundTag tag = stack.m_41783_();
            if (stack.m_150930_((Item)ModItems.FLARE_GUN.get()) && stack.m_41783_() != null) {
                stack.m_41783_().m_128379_("HasRaid", false);
                stack.m_41783_().m_128473_("Raid");
            }
            if (gun.getReloads().getReloadType() != ReloadType.SINGLE_ITEM && gun.getReloads().getReloadType() != ReloadType.INVENTORY_FED && !gun.getReloads().getReloadType().equals(ReloadType.INVENTORY_FED) && tag != null && tag.m_128425_("AmmoCount", 3)) {
                int count = tag.m_128451_("AmmoCount");
                tag.m_128405_("AmmoCount", 0);
                ResourceLocation id = gun.getProjectile().getItem();
                Item item3 = (Item)ForgeRegistries.ITEMS.getValue(id);
                if (item3 == null) {
                    return;
                }
                int maxStackSize = item3.m_41459_();
                int stacks = count / maxStackSize;
                if (player.m_21205_().getEnchantmentLevel((Enchantment)ModEnchantments.INFINITY.get()) == 0) {
                    for (int i = 0; i < stacks; ++i) {
                        ServerPlayHandler.spawnAmmo(player, new ItemStack((ItemLike)item3, maxStackSize));
                    }
                    int remaining = count % maxStackSize;
                    if (remaining > 0) {
                        ServerPlayHandler.spawnAmmo(player, new ItemStack((ItemLike)item3, remaining));
                    }
                }
            }
        }
    }

    public static void handleExtraAmmo(ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof GunItem) {
            int currentAmmo;
            GunItem gunItem = (GunItem)item;
            Gun gun = gunItem.getModifiedGun(stack);
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128425_("AmmoCount", 3) && (currentAmmo = tag.m_128451_("AmmoCount")) > GunModifierHelper.getModifiedAmmoCapacity(stack, gun)) {
                ResourceLocation id = gun.getProjectile().getItem();
                Item item2 = (Item)ForgeRegistries.ITEMS.getValue(id);
                if (item2 == null) {
                    return;
                }
                int residue = currentAmmo - gun.getReloads().getMaxAmmo();
                tag.m_128405_("AmmoCount", currentAmmo - residue);
                if (stack.getEnchantmentLevel((Enchantment)ModEnchantments.INFINITY.get()) == 0) {
                    ServerPlayHandler.spawnAmmo(player, new ItemStack((ItemLike)item2, residue));
                }
            }
        }
    }

    private static void spawnAmmo(ServerPlayer player, ItemStack stack) {
        player.m_150109_().m_36054_(stack);
        if (stack.m_41613_() > 0) {
            player.m_9236_().m_7967_((Entity)new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), stack.m_41777_()));
        }
    }

    public static void handleAttachments(ServerPlayer player) {
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof GunItem) {
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, player1) -> new AttachmentContainer(windowId, playerInventory, heldItem), (Component)Component.m_237115_((String)"container.jeg.attachments")));
        }
    }

    public static void burnPlayer(ServerPlayer player) {
        player.m_20254_(5);
    }

    public static ItemStack getFireworkStack(Boolean pFlicker, Boolean pTrail, int pType, int pFlight) {
        ItemStack fireworkStack = new ItemStack((ItemLike)Items.f_42688_);
        CompoundTag fireworkTag = new CompoundTag();
        ListTag explosionList = new ListTag();
        CompoundTag explosion = new CompoundTag();
        explosion.m_128379_("Flicker", pFlicker.booleanValue());
        explosion.m_128379_("Trail", pTrail.booleanValue());
        explosion.m_128344_("Type", (byte)pType);
        explosion.m_128385_("Colors", new int[]{ServerPlayHandler.getRandomColor(), ServerPlayHandler.getRandomColor()});
        explosionList.add((Object)explosion);
        fireworkTag.m_128344_("Flight", (byte)pFlight);
        fireworkTag.m_128365_("Explosions", (Tag)explosionList);
        CompoundTag fireworkItemTag = new CompoundTag();
        fireworkItemTag.m_128365_("Fireworks", (Tag)fireworkTag);
        fireworkStack.m_41751_(fireworkItemTag);
        return fireworkStack;
    }

    public static ItemStack getColoredFireworkStack(Boolean pFlicker, Boolean pTrail, int pType, int pFlight, int pColor1, int pColor2) {
        ItemStack fireworkStack = new ItemStack((ItemLike)Items.f_42688_);
        CompoundTag fireworkTag = new CompoundTag();
        ListTag explosionList = new ListTag();
        CompoundTag explosion = new CompoundTag();
        explosion.m_128379_("Flicker", pFlicker.booleanValue());
        explosion.m_128379_("Trail", pTrail.booleanValue());
        explosion.m_128344_("Type", (byte)pType);
        explosion.m_128385_("Colors", new int[]{pColor1, pColor2});
        explosionList.add((Object)explosion);
        fireworkTag.m_128344_("Flight", (byte)pFlight);
        fireworkTag.m_128365_("Explosions", (Tag)explosionList);
        CompoundTag fireworkItemTag = new CompoundTag();
        fireworkItemTag.m_128365_("Fireworks", (Tag)fireworkTag);
        fireworkStack.m_41751_(fireworkItemTag);
        return fireworkStack;
    }

    public static int getRandomColor() {
        RandomSource rand = RandomSource.m_216327_();
        return rand.m_188503_(0xFFFFFF);
    }
}

