/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.ai.trumpet;

import java.util.Random;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ttv.migami.jeg.entity.ai.trumpet.TrumpetRangedAttackGoal;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModSounds;
import ttv.migami.jeg.item.TrumpetItem;

@Mod.EventBusSubscriber(modid="jeg", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TrumpetSkeletonAI {
    private static final int SOUND_INTERVAL_TICKS = 120;
    private final Random random = new Random();

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Skeleton) {
            Skeleton skeleton = (Skeleton)livingEntity;
            Level world = skeleton.m_9236_();
            ItemStack heldItem = skeleton.m_21205_();
            if (skeleton.m_19880_().contains("TrumpetBoi") && !(heldItem.m_41720_() instanceof TrumpetItem)) {
                ItemStack trumpet = new ItemStack((ItemLike)ModItems.TRUMPET.get());
                skeleton.m_8061_(EquipmentSlot.MAINHAND, trumpet);
                skeleton.m_21409_(EquipmentSlot.MAINHAND, 1.0f);
            }
            if (heldItem.m_41720_() instanceof TrumpetItem) {
                if (skeleton.f_19797_ < 2) {
                    TrumpetSkeletonAI.reassessWeaponGoal(skeleton);
                }
                if (skeleton.f_19797_ % 120 == 0 && skeleton.m_5448_() == null && (double)this.random.nextFloat() < 0.5) {
                    world.m_6263_(null, skeleton.m_20185_(), skeleton.m_20186_(), skeleton.m_20189_(), (SoundEvent)ModSounds.DOOT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Skeleton skeleton;
        ItemStack heldItem;
        Entity entity = event.getEntity();
        if (entity instanceof Skeleton && (heldItem = (skeleton = (Skeleton)entity).m_21205_()).m_41720_() instanceof TrumpetItem) {
            TrumpetSkeletonAI.reassessWeaponGoal(skeleton);
        }
    }

    public static void reassessWeaponGoal(Skeleton skeleton) {
        if (!skeleton.m_9236_().f_46443_) {
            skeleton.f_21345_.m_25363_((Goal)skeleton.f_32131_);
            skeleton.f_21345_.m_25363_((Goal)skeleton.f_32130_);
            ItemStack itemstack = skeleton.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)skeleton, item -> item instanceof BowItem || item instanceof TrumpetItem));
            if (itemstack.m_41720_() instanceof TrumpetItem) {
                skeleton.f_21345_.m_25352_(2, new TrumpetRangedAttackGoal<Skeleton>(skeleton, 1.0, 60, 5.0f));
            } else if (itemstack.m_150930_(Items.f_42411_)) {
                int i = 20;
                if (skeleton.m_9236_().m_46791_() != Difficulty.HARD) {
                    i = 40;
                }
                skeleton.f_32130_.m_25797_(i);
                skeleton.f_21345_.m_25352_(4, (Goal)skeleton.f_32130_);
            } else {
                skeleton.f_21345_.m_25352_(4, (Goal)skeleton.f_32131_);
            }
        }
    }
}

