/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.monster.phantom.terror;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.client.handler.SoundHandler;
import ttv.migami.jeg.common.network.ServerPlayHandler;
import ttv.migami.jeg.entity.ai.EntityHurtByTargetGoal;
import ttv.migami.jeg.entity.ai.phantom.TerrorPhantomGunAttackGoal;
import ttv.migami.jeg.entity.monster.phantom.PhantomSwarmData;
import ttv.migami.jeg.entity.monster.phantom.PhantomSwarmSpawner;
import ttv.migami.jeg.entity.monster.phantom.gunner.PhantomGunner;
import ttv.migami.jeg.entity.monster.phantom.terror.TerrorPhantomAnimations;
import ttv.migami.jeg.entity.throwable.GrenadeEntity;
import ttv.migami.jeg.entity.throwable.ThrowableExplosiveChargeEntity;
import ttv.migami.jeg.entity.throwable.ThrowableFlareEntity;
import ttv.migami.jeg.entity.throwable.ThrowableGrenadeEntity;
import ttv.migami.jeg.entity.throwable.ThrowableMolotovCocktailEntity;
import ttv.migami.jeg.init.ModCommands;
import ttv.migami.jeg.init.ModEffects;
import ttv.migami.jeg.init.ModEntities;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModParticleTypes;
import ttv.migami.jeg.init.ModSounds;
import ttv.migami.jeg.init.ModTags;

public class TerrorPhantom
extends Phantom
implements GeoEntity {
    private AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int attackTimer = 0;
    Vec3 f_33097_;
    BlockPos f_33098_;
    AttackPhase f_33096_;
    private boolean isHalfHealth = false;
    private boolean isAngry = false;
    private boolean isDying = false;
    private int deathTimer = 0;
    private static final int DEATH_ANIMATION_DURATION = 200;
    private double forwardSpeed = 0.1;
    private boolean looted = false;
    private Player player;
    public boolean playerOwned = false;
    private int despawnTimer;
    private int bombingTimer = 0;
    private static final int MAX_BOMBING_TIMER = 20;
    private float vertical = 0.0f;
    private float speed = 5.0f;
    private final int MAX_SWARM_PARTICLE_TICK = 7;
    private int swarmParticleTick = 7;
    private final int MAX_SWARM_SPAWN_TICK = 300;
    private int swarmSpawnTick = 300;
    private boolean makeSound = true;
    private ResourceLocation lootTable1 = new ResourceLocation("jeg", "entities/phantom/terror/terror_phantom_supply");
    private ResourceLocation lootTable2 = new ResourceLocation("jeg", "entities/phantom/terror/terror_phantom_reward");
    private static final EntityDataAccessor<Boolean> IS_ROLLING = SynchedEntityData.m_135353_(TerrorPhantom.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_DYING = SynchedEntityData.m_135353_(TerrorPhantom.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_OWNED = SynchedEntityData.m_135353_(TerrorPhantom.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final ServerBossEvent bossEvent = new ServerBossEvent((Component)Component.m_237115_((String)"entity.jeg.terror_phantom"), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);

    public TerrorPhantom(EntityType<? extends Phantom> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_33097_ = Vec3.f_82478_;
        this.f_33098_ = BlockPos.f_121853_;
        this.f_33096_ = AttackPhase.CIRCLE;
        this.f_21364_ = 100;
        this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)ModItems.LIGHT_MACHINE_GUN.get()));
        this.f_21342_ = new PhantomMoveControl((Mob)this);
        if (!this.isPlayerOwned()) {
            this.bossEvent.m_142711_(1.0f);
        } else {
            this.bossEvent.m_7706_();
        }
        this.despawnTimer = 200;
        this.bombingTimer = 20;
    }

    public void setPlayer(Player player) {
        if (player != null) {
            this.player = player;
            this.playerOwned = true;
            this.setPlayerOwned(true);
            this.m_20049_("   PlayerOwned");
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new TerrorPhantomAttackStrategyGoal());
        this.f_21345_.m_25352_(2, new TerrorPhantomGunAttackGoal(this, 100.0, 5));
        this.f_21345_.m_25352_(2, (Goal)new TerrorPhantomSweepAttackGoal());
        this.f_21345_.m_25352_(2, (Goal)new TerrorPhantomRollAttackGoal());
        this.f_21345_.m_25352_(2, (Goal)new TerrorPhantomSwarmAttackGoal(this, 10));
        this.f_21345_.m_25352_(2, (Goal)new TerrorPhantomBombingAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new TerrorPhantomCircleAroundAnchorGoal());
        this.f_21346_.m_25352_(1, (Goal)new TerrorPhantomAttackPlayerTargetGoal());
        this.f_21346_.m_25352_(1, (Goal)new EntityHurtByTargetGoal((Mob)this, new Class[0]));
    }

    private void releaseSwarm(ServerLevel serverLevel) {
        if (!((Boolean)Config.COMMON.gunnerMobs.phantomSwarm.get()).booleanValue()) {
            return;
        }
        PhantomSwarmData raidData = PhantomSwarmData.get(serverLevel);
        if (!raidData.hasPhantomSwarm()) {
            raidData.setPhantomSwarm(true);
            MutableComponent message = Component.m_237115_((String)"broadcast.jeg.terror_phantom_defeat").m_130940_(ChatFormatting.DARK_RED).m_130940_(ChatFormatting.BOLD);
            serverLevel.m_7654_().m_6846_().m_240416_((Component)message, false);
        }
    }

    private void explode() {
        this.endGrenades(this);
        GrenadeEntity.createExplosion((Entity)this, ((Double)Config.COMMON.grenades.explosionRadius.get()).floatValue(), true);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.looted) {
                this.spawnLootBarrels(serverLevel, this.m_20097_(), this.lootTable1, this.lootTable2);
                this.looted = true;
            }
            ThrowableFlareEntity flare = new ThrowableFlareEntity((Level)serverLevel, (LivingEntity)this);
            serverLevel.m_7967_((Entity)flare);
            ModCommands.startTerrorRaid(serverLevel, this.m_20182_(), true, true);
            ServerPlayHandler.sendParticlesToAll(serverLevel, (SimpleParticleType)ModParticleTypes.BIG_EXPLOSION.get(), true, this.m_20185_() - this.m_20184_().m_7096_(), this.m_20186_() - this.m_20184_().m_7098_(), this.m_20189_() - this.m_20184_().m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.m_9236_().f_46443_) {
            double posX = this.m_20185_() - this.m_20184_().m_7096_();
            double posY = this.m_20186_() - this.m_20184_().m_7098_();
            double posZ = this.m_20189_() - this.m_20184_().m_7094_();
            for (int i = 0; i < 10; ++i) {
                double xSpeed = (this.f_19796_.m_188500_() - 0.5) * 0.5 * 10.0;
                double ySpeed = (this.f_19796_.m_188500_() - 0.5) * 0.5 * 10.0;
                double zSpeed = (this.f_19796_.m_188500_() - 0.5) * 0.5 * 10.0;
                this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.SMOKE.get(), true, posX, posY + 2.0, posZ, xSpeed, ySpeed, zSpeed);
                this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.FIRE.get(), true, posX, posY + 2.0, posZ, xSpeed, ySpeed, zSpeed);
            }
        }
    }

    private void dropGrenades(TerrorPhantom terrorPhantom) {
        Level level = terrorPhantom.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = terrorPhantom.m_20183_();
            RandomSource random = terrorPhantom.m_217043_();
            int grenadeCount = 1 + random.m_188503_(1);
            for (int i = 0; i < grenadeCount; ++i) {
                ThrowableGrenadeEntity grenade = new ThrowableGrenadeEntity(terrorPhantom.m_9236_(), (LivingEntity)terrorPhantom, 50 + terrorPhantom.m_9236_().f_46441_.m_188503_(9));
                grenade.m_6034_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
                double xVelocity = (random.m_188500_() - 0.5) * 1.5;
                double yVelocity = (0.4 + random.m_188500_() * 0.6) * -1.0;
                double zVelocity = (random.m_188500_() - 0.5) * 1.5;
                grenade.m_20334_(xVelocity, yVelocity, zVelocity);
                grenade.terrorPhantomThrown = true;
                serverLevel.m_7967_((Entity)grenade);
            }
        }
    }

    private void dropGrenade(TerrorPhantom terrorPhantom) {
        Level level = terrorPhantom.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = terrorPhantom.m_20183_();
            RandomSource random = terrorPhantom.m_217043_();
            int grenadeCount = 2;
            for (int i = 0; i < grenadeCount; ++i) {
                ThrowableGrenadeEntity grenade = new ThrowableGrenadeEntity(terrorPhantom.m_9236_(), (LivingEntity)terrorPhantom, 100);
                grenade.m_6034_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
                double xVelocity = 0.0;
                double yVelocity = -1.0;
                double zVelocity = 0.0;
                grenade.m_20334_(xVelocity, yVelocity, zVelocity);
                grenade.terrorPhantomThrown = true;
                grenade.playerOwnedTerrorPhantom = true;
                serverLevel.m_7967_((Entity)grenade);
                grenade.setShouldBounce(false);
            }
        }
    }

    private void dropGrenadesSideways(TerrorPhantom terrorPhantom) {
        Level level = terrorPhantom.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = terrorPhantom.m_20183_();
            Vec3 lookVec = terrorPhantom.m_20154_();
            Vec3 leftVec = new Vec3(-lookVec.f_82481_, 0.0, lookVec.f_82479_).m_82541_().m_82490_(0.5);
            Vec3 rightVec = new Vec3(lookVec.f_82481_, 0.0, -lookVec.f_82479_).m_82541_().m_82490_(0.5);
            this.throwGrenade(serverLevel, terrorPhantom, pos, leftVec);
            this.throwGrenade(serverLevel, terrorPhantom, pos, rightVec);
        }
    }

    private void throwGrenade(ServerLevel serverLevel, TerrorPhantom terrorPhantom, BlockPos pos, Vec3 offset) {
        ThrowableGrenadeEntity grenade = new ThrowableGrenadeEntity(terrorPhantom.m_9236_(), (LivingEntity)terrorPhantom, 100);
        grenade.m_6034_((double)pos.m_123341_() + offset.f_82479_, pos.m_123342_() + 1, (double)pos.m_123343_() + offset.f_82481_);
        grenade.m_20334_(offset.f_82479_, -0.5, offset.f_82481_);
        grenade.terrorPhantomThrown = true;
        grenade.playerOwnedTerrorPhantom = true;
        grenade.setShouldBounce(false);
        serverLevel.m_7967_((Entity)grenade);
    }

    private void endGrenades(TerrorPhantom terrorPhantom) {
        Level level = terrorPhantom.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = terrorPhantom.m_20183_();
            serverLevel.m_245803_((Entity)terrorPhantom, pos, (SoundEvent)ModSounds.ITEM_GRENADE_PIN.get(), SoundSource.HOSTILE, 30.0f, 1.0f);
            RandomSource random = terrorPhantom.m_217043_();
            int grenadeCount = 15 + random.m_188503_(5);
            for (int i = 0; i < grenadeCount; ++i) {
                ThrowableGrenadeEntity grenade = new ThrowableGrenadeEntity(terrorPhantom.m_9236_(), (LivingEntity)terrorPhantom, 90 + terrorPhantom.m_9236_().f_46441_.m_188503_(9));
                grenade.m_6034_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
                double xVelocity = (random.m_188500_() - 0.5) * 1.5;
                double yVelocity = (0.4 + random.m_188500_() * 0.6) * 2.0;
                double zVelocity = (random.m_188500_() - 0.5) * 1.5;
                grenade.m_20334_(xVelocity, yVelocity, zVelocity);
                grenade.terrorPhantomThrown = true;
                serverLevel.m_7967_((Entity)grenade);
            }
        }
    }

    public void m_8119_() {
        Object serverLevel;
        Vec3 forwardMotion;
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.makeSound) {
                if (this.isPlayerOwned()) {
                    SoundHandler.playTerrorPhantomBoostSound(this);
                } else {
                    SoundHandler.playTerrorPhantomFlySound(this);
                }
                this.makeSound = false;
            }
            if (this.isDying()) {
                SoundHandler.playTerrorPhantomDiveSound(this);
            }
        }
        if (this.isPlayerOwned()) {
            this.bossEvent.m_7706_();
            --this.despawnTimer;
            forwardMotion = Vec3.m_82498_((float)this.m_146909_(), (float)this.m_146908_()).m_82490_((double)this.speed);
            this.m_20334_(forwardMotion.f_82479_, this.vertical, forwardMotion.f_82481_);
            if (this.f_19797_ > 18) {
                --this.bombingTimer;
                if (this.f_19797_ % 2 == 0 && this.bombingTimer >= 0) {
                    this.dropGrenade(this);
                    this.dropGrenadesSideways(this);
                }
            }
            if (this.despawnTimer <= 0) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        if (this.isDying()) {
            Level i2;
            ++this.deathTimer;
            this.forwardSpeed = Math.min(this.forwardSpeed + 0.05, 2.0);
            forwardMotion = Vec3.m_82498_((float)this.m_146909_(), (float)this.m_146908_()).m_82490_(this.forwardSpeed);
            this.m_20334_(forwardMotion.f_82479_, -0.75, forwardMotion.f_82481_);
            this.m_146926_(this.m_146909_() + 2.0f);
            if (this.deathTimer >= 200 || this.f_19862_ || this.f_19863_) {
                this.explode();
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    this.releaseSwarm((ServerLevel)serverLevel);
                    for (int i2 = 0; i2 < 25; ++i2) {
                        ExperienceOrb.m_147082_((ServerLevel)serverLevel, (Vec3)this.m_20182_().m_82520_(0.0, 100.0, 0.0), (int)100);
                    }
                }
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            if (this.f_19797_ % 10 == 0) {
                this.dropGrenades(this);
            }
            if (this.f_19797_ % 5 == 0) {
                FireworkRocketEntity firework = new FireworkRocketEntity(this.m_9236_(), ServerPlayHandler.getFireworkStack(this.f_19796_.m_188499_(), false, this.f_19796_.m_216339_(0, 3), this.f_19796_.m_216339_(0, 3)), this.m_20185_() + (double)this.f_19796_.m_216339_(-32, 32), this.m_20186_() + (double)this.f_19796_.m_216339_(0, 3), this.m_20189_() + (double)this.f_19796_.m_216339_(-10, 10), false);
                this.m_9236_().m_7967_((Entity)firework);
            }
            if ((i2 = this.m_9236_()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)i2;
                if (this.f_19797_ % 15 == 0) {
                    serverLevel.m_245803_((Entity)this, this.m_20097_(), SoundEvents.f_11932_, SoundSource.HOSTILE, 10.0f, 0.8f + this.f_19796_.m_188501_());
                }
                if (this.f_19797_ % 8 == 0) {
                    ServerPlayHandler.sendParticlesToAll((ServerLevel)serverLevel, (SimpleParticleType)ModParticleTypes.SMALL_EXPLOSION.get(), true, this.m_20185_() - this.m_20184_().m_7096_(), this.m_20186_() - this.m_20184_().m_7098_(), this.m_20189_() - this.m_20184_().m_7094_(), 1, 3.0, 3.0, 3.0, 0.0);
                    serverLevel.m_245803_((Entity)this, this.m_20097_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 10.0f, 1.0f);
                }
            }
        }
        this.isHalfHealth = this.m_21223_() <= this.m_21233_() / 2.0f;
        boolean bl = this.isAngry = this.m_21223_() <= this.m_21233_() / 2.0f + 50.0f;
        if (this.m_33172_() != 6) {
            this.m_33108_(6);
        }
        if (!this.isDying()) {
            if (this.f_33096_.equals((Object)AttackPhase.SWOOP)) {
                this.f_19862_ = false;
            }
            this.f_19794_ = this.m_5448_() != null || this.f_19862_;
        } else {
            this.f_19794_ = false;
        }
        serverLevel = this.m_9236_();
        if (serverLevel instanceof ServerLevel) {
            LivingEntity players2;
            ServerLevel serverLevel2 = (ServerLevel)serverLevel;
            --this.attackTimer;
            if (this.attackTimer <= 0) {
                this.f_33096_ = AttackPhase.CIRCLE;
            }
            if (this.isAngry && --this.swarmParticleTick <= 0) {
                for (LivingEntity players2 : serverLevel2.m_6907_()) {
                    PhantomSwarmSpawner.spawnPhantomGunnerSwarm(serverLevel2, (ServerPlayer)players2);
                    PhantomSwarmSpawner.spawnSecondLayerPhantomGunnerSwarm(serverLevel2, (ServerPlayer)players2);
                }
                this.swarmParticleTick = 7;
            }
            if (this.isHalfHealth && --this.swarmSpawnTick <= 0 && (players2 = this.m_5448_()) instanceof Player) {
                Player player = (Player)players2;
                BlockPos.MutableBlockPos spawnPos = this.m_5448_().m_20183_().m_122032_().m_122184_((24 + this.f_19796_.m_188503_(24)) * (this.f_19796_.m_188499_() ? -1 : 1), 0, (24 + this.f_19796_.m_188503_(24)) * (this.f_19796_.m_188499_() ? -1 : 1));
                ModCommands.spawnPhantomSwarm(serverLevel2, 1 + serverLevel2.f_46441_.m_188503_(1), player, spawnPos);
                this.swarmSpawnTick = 300;
            }
        }
        if (this.m_21223_() <= 0.0f) {
            this.isDying = true;
            this.setDying(true);
        }
    }

    public void spawnLootBarrels(ServerLevel world, BlockPos pos, ResourceLocation lootTable1, ResourceLocation lootTable2) {
        BlockPos chestPos1 = TerrorPhantom.findGroundPosition((Level)world, pos);
        BlockPos chestPos2 = TerrorPhantom.findGroundPosition((Level)world, pos.m_7918_(2, 0, 2));
        this.placeBarrelWithLoot(world, chestPos1, lootTable1);
        this.placeBarrelWithLoot(world, chestPos2, lootTable2);
    }

    private static BlockPos findGroundPosition(Level world, BlockPos pos) {
        while (!world.m_8055_(pos).m_280296_() && pos.m_123342_() > world.m_141937_()) {
            pos = pos.m_7495_();
        }
        return pos.m_7494_();
    }

    private void placeBarrelWithLoot(ServerLevel world, BlockPos pos, ResourceLocation lootTable) {
        world.m_7731_(pos, (BlockState)Blocks.f_50618_.m_49966_().m_61124_((Property)BarrelBlock.f_49042_, (Comparable)Direction.m_235672_((RandomSource)this.f_19796_)), 3);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BarrelBlockEntity) {
            BarrelBlockEntity chest = (BarrelBlockEntity)blockEntity;
            chest.m_59626_(lootTable, world.m_213780_().m_188505_());
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.isDying) {
            return super.m_6469_(source, amount);
        }
        return false;
    }

    public boolean m_21224_() {
        return this.isDying && this.deathTimer >= 200;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && !this.isPlayerOwned() && this.f_19797_ > 20) {
            this.updateBossBar();
        }
    }

    private void updateBossBar() {
        float healthPercentage = this.m_21223_() / this.m_21233_();
        this.bossEvent.m_142711_(healthPercentage);
        List<ServerPlayer> nearbyPlayers = this.getNearbyPlayers(128.0);
        this.bossEvent.m_7706_();
        for (ServerPlayer player : nearbyPlayers) {
            this.bossEvent.m_6543_(player);
        }
    }

    private List<ServerPlayer> getNearbyPlayers(double radius) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return List.of();
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return serverLevel.m_8795_(player -> (double)player.m_20270_((Entity)this) <= radius);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        if (player.m_20270_((Entity)this) <= 128.0f && !this.isPlayerOwned() && this.f_19797_ > 20) {
            this.bossEvent.m_6543_(player);
        }
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.m_6539_(player);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        this.bossEvent.m_7706_();
    }

    protected void m_6677_(DamageSource pSource) {
        SoundEvent soundevent = this.m_7975_(pSource);
        if (soundevent != null && this.f_19797_ % 40 == 0) {
            this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
        }
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.1f;
    }

    protected float m_6121_() {
        return 1000.0f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22277_, 256.0).m_22268_(Attributes.f_22284_, 35.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public AttackPhase getAttackPhase() {
        return this.f_33096_;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{TerrorPhantomAnimations.genericIdleController(this)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_21532_() {
        return !this.isPlayerOwned();
    }

    public boolean isRolling() {
        return (Boolean)this.f_19804_.m_135370_(IS_ROLLING);
    }

    public void setRolling(boolean rolling) {
        this.f_19804_.m_135381_(IS_ROLLING, (Object)rolling);
    }

    public boolean isDying() {
        return (Boolean)this.f_19804_.m_135370_(IS_DYING);
    }

    public void setDying(boolean dying) {
        this.f_19804_.m_135381_(IS_DYING, (Object)dying);
    }

    public boolean isPlayerOwned() {
        return (Boolean)this.f_19804_.m_135370_(IS_OWNED);
    }

    public void setPlayerOwned(boolean isPlayerOwned) {
        this.f_19804_.m_135381_(IS_OWNED, (Object)isPlayerOwned);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ROLLING, (Object)false);
        this.f_19804_.m_135372_(IS_DYING, (Object)false);
        this.f_19804_.m_135372_(IS_OWNED, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsPlayerOwned", this.isPlayerOwned());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("IsPlayerOwned")) {
            this.setPlayerOwned(compound.m_128471_("IsPlayerOwned"));
        }
    }

    public static enum AttackPhase {
        CIRCLE,
        SWOOP,
        ROLL,
        SWARM,
        BOMBING;

    }

    class PhantomMoveControl
    extends MoveControl {
        private float speed;

        public PhantomMoveControl(Mob pMob) {
            super(pMob);
            this.speed = 0.4f;
        }

        public void m_8126_() {
            if (TerrorPhantom.this.isPlayerOwned()) {
                return;
            }
            this.speed = TerrorPhantom.this.isDying() ? 0.5f : (TerrorPhantom.this.f_33096_ == AttackPhase.SWARM ? 3.0f : (TerrorPhantom.this.f_33096_ == AttackPhase.ROLL ? 1.5f : (TerrorPhantom.this.f_33096_ == AttackPhase.BOMBING ? 2.0f : 0.5f)));
            double $$0 = TerrorPhantom.this.f_33097_.f_82479_ - TerrorPhantom.this.m_20185_();
            double $$1 = TerrorPhantom.this.f_33097_.f_82480_ - TerrorPhantom.this.m_20186_();
            double $$2 = TerrorPhantom.this.f_33097_.f_82481_ - TerrorPhantom.this.m_20189_();
            double $$3 = Math.sqrt($$0 * $$0 + $$2 * $$2);
            if (Math.abs($$3) > (double)1.0E-5f) {
                double $$4 = 1.0 - Math.abs($$1 * (double)0.7f) / $$3;
                $$3 = Math.sqrt(($$0 *= $$4) * $$0 + ($$2 *= $$4) * $$2);
                double $$5 = Math.sqrt($$0 * $$0 + $$2 * $$2 + $$1 * $$1);
                float $$6 = TerrorPhantom.this.m_146908_();
                float $$7 = (float)Mth.m_14136_((double)$$2, (double)$$0);
                float $$8 = Mth.m_14177_((float)(TerrorPhantom.this.m_146908_() + 90.0f));
                float $$9 = Mth.m_14177_((float)($$7 * 57.295776f));
                TerrorPhantom.this.m_146922_(Mth.m_14148_((float)$$8, (float)$$9, (float)4.0f) - 90.0f);
                TerrorPhantom.this.f_20883_ = TerrorPhantom.this.m_146908_();
                this.speed = Mth.m_14145_((float)$$6, (float)TerrorPhantom.this.m_146908_()) < 3.0f ? Mth.m_14121_((float)this.speed, (float)2.5f, (float)(0.005f * (1.8f / this.speed))) : Mth.m_14121_((float)this.speed, (float)0.4f, (float)0.025f);
                float $$10 = (float)(-(Mth.m_14136_((double)(-$$1), (double)$$3) * 57.2957763671875));
                TerrorPhantom.this.m_146926_($$10);
                float $$11 = TerrorPhantom.this.m_146908_() + 90.0f;
                double $$12 = (double)(this.speed * Mth.m_14089_((float)($$11 * ((float)Math.PI / 180)))) * Math.abs($$0 / $$5);
                double $$13 = (double)(this.speed * Mth.m_14031_((float)($$11 * ((float)Math.PI / 180)))) * Math.abs($$2 / $$5);
                double $$14 = (double)(this.speed * Mth.m_14031_((float)($$10 * ((float)Math.PI / 180)))) * Math.abs($$1 / $$5);
                Vec3 $$15 = TerrorPhantom.this.m_20184_();
                TerrorPhantom.this.m_20256_($$15.m_82549_(new Vec3($$12, $$14, $$13).m_82546_($$15).m_82490_(0.2)));
            }
        }
    }

    public class TerrorPhantomAttackStrategyGoal
    extends Goal {
        private int nextSweepTick;
        private boolean lastRolled = false;
        private int turnsUntilSwarm = 0;
        private int turnsUntilBombing = 0;
        private boolean isBombing = false;
        private int bombingTurns = 3;

        public boolean m_8036_() {
            if (TerrorPhantom.this.isPlayerOwned()) {
                return false;
            }
            LivingEntity target = TerrorPhantom.this.m_5448_();
            return target != null ? TerrorPhantom.this.m_21040_(target, TargetingConditions.m_148352_().m_148355_()) : false;
        }

        public void m_8056_() {
            this.nextSweepTick = this.m_183277_(10);
            TerrorPhantom.this.f_33096_ = AttackPhase.CIRCLE;
            this.setAnchorAboveTarget();
            this.turnsUntilBombing = 0;
            this.bombingTurns = 3;
        }

        public void m_8041_() {
            TerrorPhantom.this.f_33098_ = TerrorPhantom.this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, TerrorPhantom.this.f_33098_).m_6630_(10 + TerrorPhantom.this.f_19796_.m_188503_(20));
        }

        public void m_8037_() {
            if (TerrorPhantom.this.f_33096_ == AttackPhase.CIRCLE) {
                --this.nextSweepTick;
                if (this.bombingTurns <= 0) {
                    this.isBombing = false;
                }
                if (this.nextSweepTick <= 0) {
                    if (this.isBombing) {
                        this.doBombing();
                        --this.bombingTurns;
                    } else if (this.turnsUntilSwarm <= 0 && TerrorPhantom.this.isHalfHealth) {
                        this.doSwarm();
                        this.turnsUntilSwarm = 5;
                    } else if (this.turnsUntilBombing <= 0 && TerrorPhantom.this.isHalfHealth) {
                        this.isBombing = true;
                        this.turnsUntilBombing = 2;
                    } else {
                        if (TerrorPhantom.this.f_19796_.m_188499_()) {
                            this.doSwoop();
                            this.lastRolled = false;
                        } else if (!this.lastRolled) {
                            this.doRoll();
                            if (TerrorPhantom.this.m_21223_() >= TerrorPhantom.this.m_21233_() / 2.0f) {
                                this.lastRolled = true;
                            }
                        } else {
                            this.doSwoop();
                            this.lastRolled = false;
                        }
                        --this.turnsUntilSwarm;
                        --this.turnsUntilBombing;
                    }
                }
            }
        }

        private void doSwoop() {
            TerrorPhantom.this.f_33096_ = AttackPhase.SWOOP;
            TerrorPhantom.this.attackTimer = 80;
            this.setAnchorAboveTarget();
            this.nextSweepTick = this.m_183277_(100);
            TerrorPhantom.this.m_5496_(SoundEvents.f_12232_, 30.0f, 0.45f + TerrorPhantom.this.f_19796_.m_188501_() * 0.1f);
        }

        private void doRoll() {
            TerrorPhantom.this.setRolling(true);
            TerrorPhantom.this.f_33096_ = AttackPhase.ROLL;
            TerrorPhantom.this.attackTimer = 100;
            this.setAnchorOvershot();
            this.nextSweepTick = this.m_183277_(200);
            TerrorPhantom.this.m_5496_(SoundEvents.f_12232_, 30.0f, 0.45f + TerrorPhantom.this.f_19796_.m_188501_() * 0.1f);
        }

        private void doSwarm() {
            TerrorPhantom.this.f_33096_ = AttackPhase.SWARM;
            TerrorPhantom.this.attackTimer = 240;
            this.setAnchorAboveTarget();
            this.nextSweepTick = this.m_183277_(300);
            TerrorPhantom.this.m_5496_(SoundEvents.f_12232_, 30.0f, 0.45f + TerrorPhantom.this.f_19796_.m_188501_() * 0.1f);
        }

        private void doBombing() {
            TerrorPhantom.this.f_33096_ = AttackPhase.BOMBING;
            TerrorPhantom.this.attackTimer = 70;
            if (TerrorPhantom.this.m_5448_() != null) {
                TerrorPhantom.this.m_21391_((Entity)TerrorPhantom.this.m_5448_(), 255.0f, 255.0f);
            }
            this.setAnchorOvershot();
            this.nextSweepTick = this.m_183277_(60);
            TerrorPhantom.this.m_5496_(SoundEvents.f_12232_, 30.0f, 0.45f + TerrorPhantom.this.f_19796_.m_188501_() * 0.1f);
        }

        private void setAnchorAboveTarget() {
            if (TerrorPhantom.this.m_5448_() == null) {
                return;
            }
            int maxHeight = Math.min(TerrorPhantom.this.m_5448_().m_146904_() + 32, TerrorPhantom.this.m_9236_().m_151558_() - 1);
            int targetHeight = TerrorPhantom.this.m_5448_().m_146904_() + 20 + TerrorPhantom.this.f_19796_.m_188503_(12);
            TerrorPhantom.this.f_33098_ = new BlockPos(TerrorPhantom.this.m_5448_().m_146903_(), Math.min(targetHeight, maxHeight), TerrorPhantom.this.m_5448_().m_146907_());
        }

        private void setAnchorOvershot() {
            if (TerrorPhantom.this.m_5448_() == null) {
                return;
            }
            LivingEntity target = TerrorPhantom.this.m_5448_();
            Vec3 phantomPos = TerrorPhantom.this.m_20182_();
            Vec3 targetPos = target.m_20182_();
            Vec3 direction = targetPos.m_82546_(phantomPos).m_82541_();
            double overshootDistance = 32 + TerrorPhantom.this.f_19796_.m_188503_(6);
            Vec3 overshotPos = targetPos.m_82549_(direction.m_82490_(overshootDistance));
            int targetHeight = target.m_146904_();
            int maxHeight = Math.min(targetHeight + 32, TerrorPhantom.this.m_9236_().m_151558_() - 1);
            int finalHeight = Math.min(targetHeight, maxHeight);
            TerrorPhantom.this.f_33098_ = new BlockPos((int)overshotPos.f_82479_, finalHeight, (int)overshotPos.f_82481_);
        }
    }

    class TerrorPhantomSweepAttackGoal
    extends PhantomMoveTargetGoal {
        TerrorPhantomSweepAttackGoal() {
        }

        public boolean m_8036_() {
            return !TerrorPhantom.this.isDying() && TerrorPhantom.this.m_5448_() != null && TerrorPhantom.this.f_33096_ == AttackPhase.SWOOP;
        }

        public boolean m_8045_() {
            if (TerrorPhantom.this.isDying()) {
                return false;
            }
            LivingEntity $$0 = TerrorPhantom.this.m_5448_();
            if ($$0 == null) {
                return false;
            }
            if (!$$0.m_6084_()) {
                return false;
            }
            if ($$0 instanceof Player) {
                Player $$1 = (Player)$$0;
                if ($$0.m_5833_() || $$1.m_7500_()) {
                    return false;
                }
            }
            return this.m_8036_();
        }

        public void m_8056_() {
        }

        public void m_8041_() {
            TerrorPhantom.this.f_33096_ = AttackPhase.CIRCLE;
        }

        public void m_8037_() {
            LivingEntity $$0 = TerrorPhantom.this.m_5448_();
            if ($$0 != null) {
                TerrorPhantom.this.f_33097_ = new Vec3($$0.m_20185_(), $$0.m_20227_(8.0), $$0.m_20189_());
                if (TerrorPhantom.this.m_20191_().m_82400_((double)0.2f).m_82381_($$0.m_20191_())) {
                    TerrorPhantom.this.m_7327_((Entity)$$0);
                    TerrorPhantom.this.f_33096_ = AttackPhase.CIRCLE;
                    if (!TerrorPhantom.this.m_20067_()) {
                        TerrorPhantom.this.m_9236_().m_46796_(1039, TerrorPhantom.this.m_20183_(), 0);
                    }
                }
            }
        }
    }

    class TerrorPhantomRollAttackGoal
    extends PhantomMoveTargetGoal {
        private int grenadeRollsLeft;
        private int grenadeTick;

        TerrorPhantomRollAttackGoal() {
            this.grenadeRollsLeft = 2;
            this.grenadeTick = 20;
        }

        public boolean m_8036_() {
            return !TerrorPhantom.this.isDying() && TerrorPhantom.this.m_5448_() != null && TerrorPhantom.this.f_33096_ == AttackPhase.ROLL;
        }

        public boolean m_8045_() {
            if (TerrorPhantom.this.isDying()) {
                return false;
            }
            LivingEntity $$0 = TerrorPhantom.this.m_5448_();
            if ($$0 == null) {
                return false;
            }
            if (!$$0.m_6084_()) {
                return false;
            }
            if ($$0 instanceof Player) {
                Player $$1 = (Player)$$0;
                if ($$0.m_5833_() || $$1.m_7500_()) {
                    return false;
                }
            }
            return this.m_8036_();
        }

        public void m_8056_() {
            this.grenadeRollsLeft = 2;
            this.grenadeTick = 20;
        }

        public void m_8041_() {
            TerrorPhantom.this.setRolling(false);
            TerrorPhantom.this.f_33096_ = AttackPhase.CIRCLE;
        }

        public void m_8037_() {
            BlockPos $$0 = TerrorPhantom.this.f_33098_;
            TerrorPhantom.this.f_33097_ = new Vec3((double)$$0.m_123341_(), TerrorPhantom.this.m_5448_().m_20227_(24.0), (double)$$0.m_123343_());
            TerrorPhantom.this.f_19802_ = 20;
            TerrorPhantom.this.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BULLET_PROTECTION.get(), 20));
            if (--this.grenadeTick == 0 && this.grenadeRollsLeft > 0) {
                this.dropGrenades(TerrorPhantom.this);
                this.grenadeTick = 20;
                --this.grenadeRollsLeft;
            }
            if (TerrorPhantom.this.attackTimer <= 0) {
                TerrorPhantom.this.setRolling(false);
            }
        }

        private void dropGrenades(TerrorPhantom terrorPhantom) {
            Level level = terrorPhantom.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockPos pos = terrorPhantom.m_20183_();
                serverLevel.m_245803_((Entity)terrorPhantom, pos, (SoundEvent)ModSounds.ITEM_GRENADE_PIN.get(), SoundSource.HOSTILE, 30.0f, 1.0f);
                RandomSource random = terrorPhantom.m_217043_();
                int grenadeCount = 6 + random.m_188503_(3);
                for (int i = 0; i < grenadeCount; ++i) {
                    ThrowableGrenadeEntity grenade = new ThrowableGrenadeEntity(terrorPhantom.m_9236_(), (LivingEntity)terrorPhantom, 50 + terrorPhantom.m_9236_().f_46441_.m_188503_(9));
                    if (i == 1 && TerrorPhantom.this.isHalfHealth && TerrorPhantom.this.f_19796_.m_216339_(1, 5) == 1) {
                        grenade = new ThrowableMolotovCocktailEntity(terrorPhantom.m_9236_(), (LivingEntity)terrorPhantom, 60 + terrorPhantom.m_9236_().f_46441_.m_188503_(9));
                    }
                    grenade.m_6034_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
                    double xVelocity = (random.m_188500_() - 0.5) * 1.5;
                    double yVelocity = (0.4 + random.m_188500_() * 0.6) * -1.0;
                    double zVelocity = (random.m_188500_() - 0.5) * 1.5;
                    grenade.m_20334_(xVelocity, yVelocity, zVelocity);
                    grenade.terrorPhantomThrown = true;
                    serverLevel.m_7967_((Entity)grenade);
                }
            }
        }
    }

    public class TerrorPhantomSwarmAttackGoal
    extends PhantomMoveTargetGoal {
        private final TerrorPhantom terrorPhantom;
        private final int summonInterval;
        private int tickCounter;

        public TerrorPhantomSwarmAttackGoal(TerrorPhantom terrorPhantom, int summonInterval) {
            this.terrorPhantom = terrorPhantom;
            this.summonInterval = summonInterval;
            this.tickCounter = 0;
        }

        public boolean m_8036_() {
            return !TerrorPhantom.this.isDying() && TerrorPhantom.this.m_5448_() != null && TerrorPhantom.this.f_33096_ == AttackPhase.SWARM;
        }

        public void m_8037_() {
            ++this.tickCounter;
            if (TerrorPhantom.this.isHalfHealth) {
                TerrorPhantom.this.m_21153_(TerrorPhantom.this.m_21223_() + 1.0f);
            }
            TerrorPhantom.this.f_19802_ = 20;
            TerrorPhantom.this.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BULLET_PROTECTION.get(), 20));
            if (this.tickCounter >= this.summonInterval) {
                this.tickCounter = 0;
                this.summonPhantoms();
            }
        }

        private void summonPhantoms() {
            int numPhantoms = 1 + TerrorPhantom.this.f_19796_.m_188503_(1);
            for (int i = 0; i < numPhantoms; ++i) {
                Phantom newPhantom = (Phantom)EntityType.f_20509_.m_20615_(this.terrorPhantom.m_9236_());
                if (newPhantom == null) continue;
                if (this.terrorPhantom.f_19796_.m_216339_(1, 5) == 1) {
                    newPhantom = new PhantomGunner((EntityType<? extends Phantom>)((EntityType)ModEntities.PHANTOM_GUNNER.get()), this.terrorPhantom.m_9236_());
                }
                Vec3 spawnPos = this.terrorPhantom.m_20182_().m_82520_(this.terrorPhantom.m_217043_().m_188583_() * 2.0, 2.0, this.terrorPhantom.m_217043_().m_188583_() * 2.0);
                newPhantom.m_6027_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
                newPhantom.m_6518_((ServerLevelAccessor)this.terrorPhantom.m_9236_(), this.terrorPhantom.m_9236_().m_6436_(this.terrorPhantom.m_20183_()), MobSpawnType.EVENT, null, null);
                newPhantom.m_6710_(this.terrorPhantom.m_5448_());
                this.terrorPhantom.m_9236_().m_7967_((Entity)newPhantom);
                newPhantom.m_20049_("GunnerPatroller");
                if (this.terrorPhantom.m_9236_().m_46461_() && newPhantom.m_6095_().m_204039_(ModTags.Entities.UNDEAD)) {
                    newPhantom.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 1200, 0, false, true));
                    newPhantom.m_252836_();
                }
                if (this.terrorPhantom.f_19796_.m_216339_(1, 4) != 1 || newPhantom instanceof PhantomGunner) continue;
                ThrowableExplosiveChargeEntity explosiveChargeEntity = new ThrowableExplosiveChargeEntity((EntityType<? extends ThrowableGrenadeEntity>)((EntityType)ModEntities.THROWABLE_EXPLOSIVE_CHARGE.get()), this.terrorPhantom.m_9236_());
                this.terrorPhantom.m_9236_().m_7967_((Entity)explosiveChargeEntity);
                explosiveChargeEntity.m_20329_((Entity)newPhantom);
            }
        }
    }

    class TerrorPhantomBombingAttackGoal
    extends PhantomMoveTargetGoal {
        private int grenadeTick;

        TerrorPhantomBombingAttackGoal() {
            this.grenadeTick = 0;
        }

        public boolean m_8036_() {
            return !TerrorPhantom.this.isDying() && TerrorPhantom.this.m_5448_() != null && TerrorPhantom.this.f_33096_ == AttackPhase.BOMBING;
        }

        public boolean m_8045_() {
            if (TerrorPhantom.this.isDying()) {
                return false;
            }
            LivingEntity $$0 = TerrorPhantom.this.m_5448_();
            if ($$0 == null) {
                return false;
            }
            if (!$$0.m_6084_()) {
                return false;
            }
            if ($$0 instanceof Player) {
                Player $$1 = (Player)$$0;
                if ($$0.m_5833_() || $$1.m_7500_()) {
                    return false;
                }
            }
            return this.m_8036_();
        }

        public void m_8056_() {
            this.grenadeTick = 2;
        }

        public void m_8041_() {
            TerrorPhantom.this.f_33096_ = AttackPhase.CIRCLE;
        }

        public void m_8037_() {
            BlockPos $$0 = TerrorPhantom.this.f_33098_;
            TerrorPhantom.this.f_33097_ = new Vec3((double)$$0.m_123341_(), TerrorPhantom.this.m_5448_().m_20227_(12.0), (double)$$0.m_123343_());
            TerrorPhantom.this.f_19802_ = 20;
            TerrorPhantom.this.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BULLET_PROTECTION.get(), 10));
            if (--this.grenadeTick == 0) {
                this.dropGrenade(TerrorPhantom.this);
                this.grenadeTick = 2;
            }
            if (TerrorPhantom.this.attackTimer <= 0) {
                TerrorPhantom.this.setRolling(false);
            }
        }

        private void dropGrenade(TerrorPhantom terrorPhantom) {
            Level level = terrorPhantom.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockPos pos = terrorPhantom.m_20183_();
                serverLevel.m_245803_((Entity)terrorPhantom, pos, (SoundEvent)ModSounds.ITEM_GRENADE_PIN.get(), SoundSource.HOSTILE, 30.0f, 1.0f);
                RandomSource random = terrorPhantom.m_217043_();
                int grenadeCount = 1;
                for (int i = 0; i < grenadeCount; ++i) {
                    ThrowableGrenadeEntity grenade = new ThrowableGrenadeEntity(terrorPhantom.m_9236_(), (LivingEntity)terrorPhantom, 100);
                    grenade.m_6034_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
                    double xVelocity = 0.0;
                    double yVelocity = -1.0;
                    double zVelocity = 0.0;
                    grenade.m_20334_(xVelocity, yVelocity, zVelocity);
                    grenade.terrorPhantomThrown = true;
                    serverLevel.m_7967_((Entity)grenade);
                    grenade.setShouldBounce(false);
                }
            }
        }
    }

    public class TerrorPhantomCircleAroundAnchorGoal
    extends PhantomMoveTargetGoal {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        public boolean m_8036_() {
            return !TerrorPhantom.this.isDying() && (TerrorPhantom.this.m_5448_() == null || TerrorPhantom.this.f_33096_ == AttackPhase.CIRCLE || TerrorPhantom.this.f_33096_ == AttackPhase.SWARM);
        }

        public void m_8056_() {
            this.distance = 5.0f + TerrorPhantom.this.f_19796_.m_188501_() * 10.0f;
            this.height = -4.0f + TerrorPhantom.this.f_19796_.m_188501_() * 9.0f;
            this.clockwise = TerrorPhantom.this.f_19796_.m_188499_() ? 1.0f : -1.0f;
            this.selectNext();
        }

        public void m_8037_() {
            if (TerrorPhantom.this.f_19796_.m_188503_(this.m_183277_(350)) == 0) {
                this.height = -4.0f + TerrorPhantom.this.f_19796_.m_188501_() * 9.0f;
            }
            if (TerrorPhantom.this.f_19796_.m_188503_(this.m_183277_(250)) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (TerrorPhantom.this.f_19796_.m_188503_(this.m_183277_(450)) == 0) {
                this.angle = TerrorPhantom.this.f_19796_.m_188501_() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (TerrorPhantom.this.f_33097_.f_82480_ < TerrorPhantom.this.m_20186_() && !TerrorPhantom.this.m_9236_().m_46859_(TerrorPhantom.this.m_20183_().m_6625_(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (TerrorPhantom.this.f_33097_.f_82480_ > TerrorPhantom.this.m_20186_() && !TerrorPhantom.this.m_9236_().m_46859_(TerrorPhantom.this.m_20183_().m_6630_(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (BlockPos.f_121853_.equals((Object)TerrorPhantom.this.f_33098_)) {
                TerrorPhantom.this.f_33098_ = TerrorPhantom.this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, TerrorPhantom.this.m_20183_()).m_6630_(40);
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            TerrorPhantom.this.f_33097_ = Vec3.m_82528_((Vec3i)TerrorPhantom.this.f_33098_).m_82520_((double)(this.distance * Mth.m_14089_((float)this.angle)), 24.0, (double)(this.distance * Mth.m_14031_((float)this.angle)));
        }
    }

    public class TerrorPhantomAttackPlayerTargetGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.m_148352_().m_26883_(64.0);
        private int nextScanTick = TerrorPhantomAttackPlayerTargetGoal.m_186073_((int)20);

        public boolean m_8036_() {
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
                return false;
            }
            this.nextScanTick = TerrorPhantomAttackPlayerTargetGoal.m_186073_((int)60);
            List players = TerrorPhantom.this.m_9236_().m_45955_(this.attackTargeting, (LivingEntity)TerrorPhantom.this, TerrorPhantom.this.m_20191_().m_82377_(64.0, 100.0, 64.0));
            if (!players.isEmpty()) {
                for (Player player : players) {
                    if (!TerrorPhantom.this.m_21040_((LivingEntity)player, TargetingConditions.m_148352_().m_148355_())) continue;
                    TerrorPhantom.this.m_6710_((LivingEntity)player);
                    return true;
                }
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity $$0 = TerrorPhantom.this.m_5448_();
            return $$0 != null ? TerrorPhantom.this.m_21040_($$0, TargetingConditions.m_148352_().m_148355_()) : false;
        }
    }

    public abstract class PhantomMoveTargetGoal
    extends Goal {
        public PhantomMoveTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean touchingTarget() {
            return TerrorPhantom.this.f_33097_.m_82531_(TerrorPhantom.this.m_20185_(), TerrorPhantom.this.m_20186_(), TerrorPhantom.this.m_20189_()) < 4.0;
        }
    }
}

