/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.throwable;

import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.entity.SmokeCloud;
import ttv.migami.jeg.entity.throwable.ThrowableGrenadeEntity;
import ttv.migami.jeg.entity.throwable.ThrowableItemEntity;
import ttv.migami.jeg.init.ModEntities;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModParticleTypes;
import ttv.migami.jeg.init.ModSounds;
import ttv.migami.jeg.network.PacketHandler;
import ttv.migami.jeg.network.message.S2CMessageSmokeGrenade;

public class ThrowableSmokeGrenadeEntity
extends ThrowableGrenadeEntity {
    public ThrowableSmokeGrenadeEntity(EntityType<? extends ThrowableGrenadeEntity> entityType, Level world) {
        super(entityType, world);
    }

    public ThrowableSmokeGrenadeEntity(EntityType<? extends ThrowableGrenadeEntity> entityType, Level world, LivingEntity player) {
        super(entityType, world, player);
        this.setItem(new ItemStack((ItemLike)ModItems.SMOKE_GRENADE.get()));
    }

    public ThrowableSmokeGrenadeEntity(Level world, LivingEntity player, int timeLeft) {
        super((EntityType<? extends ThrowableItemEntity>)((EntityType)ModEntities.THROWABLE_SMOKE_GRENADE.get()), world, player);
        this.setItem(new ItemStack((ItemLike)ModItems.SMOKE_GRENADE.get()));
        this.setMaxLife(timeLeft);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevRotation = this.rotation;
        double speed = this.m_20184_().m_82553_();
        if (speed > 0.1) {
            this.rotation = (float)((double)this.rotation + speed * 50.0);
        }
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123777_, true, this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), (Math.random() - 0.5) * 0.1, 0.1, (Math.random() - 0.5) * 0.1);
        }
    }

    @Override
    protected void m_6532_(HitResult result) {
        double radius;
        if (result.m_6662_() == HitResult.Type.BLOCK && !this.m_9236_().f_46443_ && (radius = (Double)Config.COMMON.smokeGrenades.smokeGrenadeCloudDiameter.get() * 0.75) > 0.0) {
            BlockPos grenadePos = new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_());
            int radiusInt = (int)Math.ceil(radius);
            boolean foundFire = false;
            for (int x = -radiusInt; x <= radiusInt; ++x) {
                for (int z = -radiusInt; z <= radiusInt; ++z) {
                    double distanceSq = x * x + z * z;
                    if (!(distanceSq <= radius * radius)) continue;
                    for (int y = -2; y <= 2; ++y) {
                        BlockPos checkPos = grenadePos.m_7918_(x, y, z);
                        if (!this.m_9236_().m_8055_(checkPos).m_204336_(BlockTags.f_13076_)) continue;
                        foundFire = true;
                        break;
                    }
                    if (foundFire) break;
                }
                if (foundFire) break;
            }
            if (foundFire) {
                this.m_142687_(Entity.RemovalReason.KILLED);
                this.onDeath();
                return;
            }
        }
        super.m_6532_(result);
    }

    @Override
    public void onDeath() {
        double y = this.m_20186_() + (double)this.m_6095_().m_20680_().f_20378_ * 0.5;
        double radius = (Double)Config.COMMON.smokeGrenades.smokeGrenadeCloudDiameter.get() * 0.5;
        double duration = ((Double)Config.COMMON.smokeGrenades.smokeGrenadeCloudDuration.get() - 3.0) * 20.0;
        @NotNull SimpleParticleType particle = (SimpleParticleType)ModParticleTypes.SMOKE_EFFECT.get();
        this.m_9236_().m_6263_(null, this.m_20185_(), y, this.m_20189_(), (SoundEvent)ModSounds.ENTITY_SMOKE_GRENADE_EXPLOSION.get(), SoundSource.BLOCKS, 4.0f, 1.0f);
        if (!this.m_9236_().f_46443_) {
            SmokeCloud cloudLow = new SmokeCloud(this.m_9236_(), this.m_20185_(), this.m_20186_() - 0.5, this.m_20189_(), particle, (float)radius, (int)duration);
            this.m_9236_().m_7967_((Entity)cloudLow);
            SmokeCloud cloudMid = new SmokeCloud(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), particle, (float)radius, (int)duration);
            this.m_9236_().m_7967_((Entity)cloudMid);
            SmokeCloud cloudHigh = new SmokeCloud(this.m_9236_(), this.m_20185_(), this.m_20186_() + 1.5, this.m_20189_(), particle, (float)radius, (int)duration);
            this.m_9236_().m_7967_((Entity)cloudHigh);
            SmokeCloud cloudHighest = new SmokeCloud(this.m_9236_(), this.m_20185_(), this.m_20186_() + 2.5, this.m_20189_(), particle, (float)radius, (int)duration);
            this.m_9236_().m_7967_((Entity)cloudHighest);
        }
        PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)this.m_9236_(), (double)this.m_20185_(), (double)y, (double)this.m_20189_(), (double)256.0), (IMessage)new S2CMessageSmokeGrenade(this.m_20185_(), y, this.m_20189_()));
    }
}

