/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.init;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.JustEnoughGuns;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.NetworkGunManager;
import ttv.migami.jeg.entity.monster.phantom.gunner.PhantomGunner;
import ttv.migami.jeg.entity.throwable.ThrowableExplosiveChargeEntity;
import ttv.migami.jeg.entity.throwable.ThrowableGrenadeEntity;
import ttv.migami.jeg.faction.Faction;
import ttv.migami.jeg.faction.GunMobValues;
import ttv.migami.jeg.faction.GunnerManager;
import ttv.migami.jeg.faction.jeg.FactionData;
import ttv.migami.jeg.faction.jeg.FactionDataManager;
import ttv.migami.jeg.faction.raid.RaidEntity;
import ttv.migami.jeg.faction.raid.TerrorRaidEntity;
import ttv.migami.jeg.init.ModEntities;
import ttv.migami.jeg.init.ModSounds;
import ttv.migami.jeg.init.ModTags;
import ttv.migami.jeg.item.GunItem;

public class ModCommands {
    private static final SuggestionProvider<CommandSourceStack> CFG_GUN_ID_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.m_82981_(NetworkGunManager.clientConfigGunIDs.keySet().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"justEnoughGuns").then(Commands.m_82127_((String)"give").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"gunId", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(CFG_GUN_ID_SUGGESTIONS).executes(ctx -> {
            ResourceLocation gunId = ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"gunId");
            ItemStack stack = GunItem.makeGunStack(gunId);
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            stack.m_41764_(1);
            return ModCommands.executeGiveDataGun((CommandSourceStack)ctx.getSource(), stack, (Player)player);
        })).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(ctx -> {
            ResourceLocation gunId = ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"gunId");
            int count = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count");
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            ItemStack stack = GunItem.makeGunStack(gunId);
            stack.m_41764_(count);
            return ModCommands.executeGiveDataGun((CommandSourceStack)ctx.getSource(), stack, (Player)player);
        })))))).then(Commands.m_82127_((String)"reload").executes(ctx -> {
            MinecraftServer srv = ((CommandSourceStack)ctx.getSource()).m_81377_();
            Collection enabled = srv.m_129891_().m_10523_();
            srv.m_129861_(enabled).thenAccept(v -> ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Data-Guns reloaded"), true));
            return 0;
        }))).then(Commands.m_82127_((String)"spawnPatrol").then(Commands.m_82129_((String)"faction", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            List<String> factionConfigs = GunnerManager.getConfigFactions();
            for (String factionConfig : factionConfigs) {
                String factionName = factionConfig.split("\\|")[0];
                builder.suggest(factionName);
            }
            return builder.buildFuture();
        }).then(Commands.m_82129_((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"forceGuns", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"spawnRadius", (ArgumentType)IntegerArgumentType.integer((int)0, (int)16)).executes(context -> {
            String factionName = StringArgumentType.getString((CommandContext)context, (String)"faction");
            int size = IntegerArgumentType.getInteger((CommandContext)context, (String)"size");
            Vec3 pos = Vec3Argument.m_120844_((CommandContext)context, (String)"pos");
            boolean forceGuns = BoolArgumentType.getBool((CommandContext)context, (String)"forceGuns");
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            int spread = IntegerArgumentType.getInteger((CommandContext)context, (String)"spawnRadius");
            return ModCommands.executeSpawnPatrol(source, factionName, size, pos, forceGuns, spread);
        }))).executes(context -> {
            String factionName = StringArgumentType.getString((CommandContext)context, (String)"faction");
            int size = IntegerArgumentType.getInteger((CommandContext)context, (String)"size");
            Vec3 pos = Vec3Argument.m_120844_((CommandContext)context, (String)"pos");
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            boolean forceGuns = BoolArgumentType.getBool((CommandContext)context, (String)"forceGuns");
            return ModCommands.executeSpawnPatrol(source, factionName, size, pos, forceGuns, 10);
        }))).executes(context -> {
            String factionName = StringArgumentType.getString((CommandContext)context, (String)"faction");
            int size = IntegerArgumentType.getInteger((CommandContext)context, (String)"size");
            Vec3 pos = Vec3Argument.m_120844_((CommandContext)context, (String)"pos");
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            return ModCommands.executeSpawnPatrol(source, factionName, size, pos, false, 10);
        })))))).then(Commands.m_82127_((String)"simulatePatrol").then(Commands.m_82129_((String)"faction", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            List<String> factionConfigs = GunnerManager.getConfigFactions();
            for (String factionConfig : factionConfigs) {
                String factionName = factionConfig.split("\\|")[0];
                builder.suggest(factionName);
            }
            return builder.buildFuture();
        }).then(Commands.m_82129_((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"forceGuns", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            String factionName = StringArgumentType.getString((CommandContext)context, (String)"faction");
            int size = IntegerArgumentType.getInteger((CommandContext)context, (String)"size");
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            boolean forceGuns = BoolArgumentType.getBool((CommandContext)context, (String)"forceGuns");
            return ModCommands.executeSimulatePatrol(source, factionName, size, (Player)player, forceGuns);
        }))).executes(context -> {
            String factionName = StringArgumentType.getString((CommandContext)context, (String)"faction");
            int size = IntegerArgumentType.getInteger((CommandContext)context, (String)"size");
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            return ModCommands.executeSimulatePatrol(source, factionName, size, (Player)player, false);
        })))))).then(Commands.m_82127_((String)"simulatePhantomSwarm").then(Commands.m_82129_((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> {
            int size = IntegerArgumentType.getInteger((CommandContext)context, (String)"size");
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            return ModCommands.executeSimulatePhantomSwarm(source, size, (Player)player);
        }))))).then(Commands.m_82127_((String)"startRaid").then(Commands.m_82129_((String)"faction", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            List<String> factionConfigs = GunnerManager.getConfigFactions();
            for (String factionConfig : factionConfigs) {
                String factionName = factionConfig.split("\\|")[0];
                builder.suggest(factionName);
            }
            return builder.buildFuture();
        }).then(Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Vec3 pos = Vec3Argument.m_120844_((CommandContext)context, (String)"pos");
            String factionName = StringArgumentType.getString((CommandContext)context, (String)"faction");
            ModCommands.executeStartRaid(source, factionName, pos);
            return 1;
        }))))).then(Commands.m_82127_((String)"startTerrorRaid").then(Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Vec3 pos = Vec3Argument.m_120844_((CommandContext)context, (String)"pos");
            ModCommands.executeStartTerrorRaid(source, pos);
            return 1;
        })))).then(Commands.m_82127_((String)"spawnTrumpetBoi").then(Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Vec3 pos = Vec3Argument.m_120844_((CommandContext)context, (String)"pos");
            return ModCommands.executeSpawnTrumpetBoi(source, pos);
        }))));
    }

    private static int executeGiveDataGun(CommandSourceStack source, ItemStack stack, Player player) {
        if (!source.m_6761_(2)) {
            source.m_81352_(Component.m_130674_((String)"You do not have permission to execute this command"));
            return 0;
        }
        if (stack == null) {
            source.m_81352_(Component.m_130674_((String)"Could not found the specified Data-Gun!"));
            return 0;
        }
        player.m_150109_().m_150079_(stack);
        source.m_288197_(() -> Component.m_130674_((String)"Enjoy your new Data-Gun!"), true);
        return 1;
    }

    private static int executeSpawnPatrol(CommandSourceStack source, String factionName, int size, Vec3 pos, boolean forceGuns, int spread) {
        if (!source.m_6761_(2)) {
            source.m_81352_(Component.m_130674_((String)"You do not have permission to execute this command"));
            return 0;
        }
        ServerLevel level = source.m_81372_();
        if (level.m_46791_() == Difficulty.PEACEFUL) {
            source.m_81352_(Component.m_130674_((String)"Mobs can't spawn in Peaceful!"));
            return 0;
        }
        GunnerManager gunnerManager = GunnerManager.getInstance();
        Faction faction = gunnerManager.getFactionByName(factionName);
        if (faction == null) {
            source.m_81352_(Component.m_130674_((String)("Faction '" + factionName + "' does not exist!")));
            return 0;
        }
        for (int i = 0; i < size; ++i) {
            Mob mob = ModCommands.getFactionMob(level, faction, pos, forceGuns, spread);
            if (mob == null) {
                source.m_81352_(Component.m_130674_((String)("Could not spawn mob for faction " + factionName)));
                return 0;
            }
            level.m_7967_((Entity)mob);
        }
        MutableComponent factionLang = Component.m_237115_((String)("faction.jeg." + factionName));
        source.m_288197_(() -> Component.m_130674_((String)("Spawned " + size + " mobs for faction " + factionLang.getString())), true);
        if (!forceGuns) {
            source.m_81352_(Component.m_130674_((String)"Please note that by not setting 'forceGuns' to true, the chance of them spawning with Guns is entirely determined by your Config Files!"));
        }
        return 1;
    }

    public static Mob getFactionMob(ServerLevel level, FactionData factionData, Vec3 startPos, boolean forceGuns, int spread) {
        Random random = new Random();
        String mobName = factionData.getMobList().get(random.nextInt(factionData.getMobList().size()));
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(mobName));
        if (entityType == null) {
            return null;
        }
        Mob mob = (Mob)entityType.m_20615_((Level)level);
        if (mob != null) {
            double offsetX = (random.nextDouble() - 0.5) * (double)spread;
            double offsetZ = (random.nextDouble() - 0.5) * (double)spread;
            mob.m_6034_(startPos.f_82479_ + offsetX, startPos.f_82480_, startPos.f_82481_ + offsetZ);
            long totalDayTime = mob.m_9236_().m_46468_();
            int currentDay = (int)(totalDayTime / 24000L);
            int currentChance = Math.min(GunMobValues.initialChance + currentDay * GunMobValues.chanceIncrement, GunMobValues.maxChance);
            if (mob.m_217043_().m_188503_(100) < currentChance || forceGuns) {
                mob.m_20049_("MobGunner");
            }
            mob.m_213945_(RandomSource.m_216327_(), mob.m_9236_().m_6436_(mob.m_20183_()));
            ModCommands.equipArmorWithRandomMaterial(mob, random);
            if (mob.m_19880_().contains("MobGunner")) {
                Item item;
                boolean elite;
                Item gun = factionData.getRandomGun(random.nextBoolean());
                boolean bl = elite = (double)mob.m_217043_().m_188501_() < GunMobValues.eliteChance && GunMobValues.elitesEnabled;
                if (elite) {
                    mob.m_20049_("EliteGunner");
                    gun = factionData.getEliteGun();
                    if (factionData == FactionDataManager.getTerrorArmadaWave1() || factionData == FactionDataManager.getTerrorArmadaWave2() || factionData == FactionDataManager.getTerrorArmadaWave3()) {
                        mob.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42055_));
                    } else {
                        mob.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42354_));
                    }
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19606_, -1, 2, false, true));
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19597_, -1, 1, false, false));
                } else if (mob.m_217043_().m_188501_() < 0.8f) {
                    mob.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42047_));
                }
                ItemStack modifiedGun = new ItemStack((ItemLike)gun);
                mob.m_8061_(EquipmentSlot.MAINHAND, modifiedGun);
                if (modifiedGun.m_41783_() != null && (item = modifiedGun.m_41720_()) instanceof GunItem) {
                    GunItem gunItem = (GunItem)item;
                    Gun gunModified = gunItem.getModifiedGun(modifiedGun);
                    modifiedGun.m_41783_().m_128405_("AmmoCount", mob.m_217043_().m_188503_(gunModified.getReloads().getMaxAmmo()));
                }
            } else if (mob instanceof Piglin) {
                Piglin piglin;
                piglin.m_8061_(EquipmentSlot.MAINHAND, (piglin = (Piglin)mob).m_217043_().m_188501_() < 0.5f ? new ItemStack((ItemLike)Items.f_42717_) : new ItemStack((ItemLike)Items.f_42430_));
            }
        }
        if (mob instanceof AbstractPiglin) {
            AbstractPiglin abstractPiglin = (AbstractPiglin)mob;
            abstractPiglin.m_34670_(true);
        }
        return mob;
    }

    public static Mob getFactionMob(ServerLevel level, Faction faction, Vec3 startPos, boolean forceGuns, int spread) {
        Random random = new Random();
        String mobName = faction.getMobs().get(random.nextInt(faction.getMobs().size()));
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(mobName));
        if (entityType == null) {
            return null;
        }
        Mob mob = (Mob)entityType.m_20615_((Level)level);
        if (mob != null) {
            double offsetX = (random.nextDouble() - 0.5) * (double)spread;
            double offsetZ = (random.nextDouble() - 0.5) * (double)spread;
            mob.m_6034_(startPos.f_82479_ + offsetX, startPos.f_82480_, startPos.f_82481_ + offsetZ);
            long totalDayTime = mob.m_9236_().m_46468_();
            int currentDay = (int)(totalDayTime / 24000L);
            int currentChance = Math.min(GunMobValues.initialChance + currentDay * GunMobValues.chanceIncrement, GunMobValues.maxChance);
            if (mob.m_217043_().m_188503_(100) < currentChance || forceGuns) {
                mob.m_20049_("MobGunner");
            }
            mob.m_213945_(RandomSource.m_216327_(), mob.m_9236_().m_6436_(mob.m_20097_()));
            ModCommands.equipArmorWithRandomMaterial(mob, random);
            if (mob.m_19880_().contains("MobGunner")) {
                Item item;
                boolean elite;
                Item gun = faction.getRandomGun(random.nextBoolean());
                boolean bl = elite = (double)mob.m_217043_().m_188501_() < GunMobValues.eliteChance && GunMobValues.elitesEnabled;
                if (elite) {
                    mob.m_20049_("EliteGunner");
                    gun = faction.getEliteGun();
                    mob.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42354_));
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19606_, -1, 2, false, true));
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19597_, -1, 1, false, false));
                }
                ItemStack modifiedGun = new ItemStack((ItemLike)gun);
                mob.m_8061_(EquipmentSlot.MAINHAND, modifiedGun);
                if (modifiedGun.m_41783_() != null && (item = modifiedGun.m_41720_()) instanceof GunItem) {
                    GunItem gunItem = (GunItem)item;
                    Gun gunModified = gunItem.getModifiedGun(modifiedGun);
                    modifiedGun.m_41783_().m_128405_("AmmoCount", mob.m_217043_().m_188503_(gunModified.getReloads().getMaxAmmo()));
                }
            } else if (mob instanceof Piglin) {
                Piglin piglin;
                piglin.m_8061_(EquipmentSlot.MAINHAND, (double)(piglin = (Piglin)mob).m_217043_().m_188501_() < 0.5 ? new ItemStack((ItemLike)Items.f_42717_) : new ItemStack((ItemLike)Items.f_42430_));
            }
        }
        return mob;
    }

    private static void equipArmorWithRandomMaterial(Mob mob, Random random) {
        Item[] helmetMaterials = new Item[]{Items.f_42407_, Items.f_42468_, Items.f_42476_, Items.f_42472_, Items.f_42464_};
        Item[] chestplateMaterials = new Item[]{Items.f_42408_, Items.f_42469_, Items.f_42477_, Items.f_42465_, Items.f_42465_};
        Item[] leggingsMaterials = new Item[]{Items.f_42462_, Items.f_42470_, Items.f_42478_, Items.f_42474_, Items.f_42466_};
        Item[] bootsMaterials = new Item[]{Items.f_42463_, Items.f_42471_, Items.f_42479_, Items.f_42475_, Items.f_42467_};
        if (random.nextInt(3) == 0) {
            mob.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)helmetMaterials[random.nextInt(helmetMaterials.length)]));
        }
        if (random.nextInt(3) == 0) {
            mob.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)chestplateMaterials[random.nextInt(chestplateMaterials.length)]));
        }
        if (random.nextInt(3) == 0) {
            mob.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)leggingsMaterials[random.nextInt(leggingsMaterials.length)]));
        }
        if (random.nextInt(3) == 0) {
            mob.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)bootsMaterials[random.nextInt(bootsMaterials.length)]));
        }
    }

    private static int executeSimulatePatrol(CommandSourceStack source, String factionName, int size, Player player, boolean forceGuns) {
        if (!source.m_6761_(2)) {
            source.m_81352_(Component.m_130674_((String)"You do not have permission to execute this command"));
            return 0;
        }
        ServerLevel level = source.m_81372_();
        if (level.m_46791_() == Difficulty.PEACEFUL) {
            source.m_81352_(Component.m_130674_((String)"Mobs can't spawn in Peaceful!"));
            return 0;
        }
        GunnerManager gunnerManager = GunnerManager.getInstance();
        Faction faction = gunnerManager.getFactionByName(factionName);
        if (faction == null) {
            source.m_81352_(Component.m_130674_((String)("Faction '" + factionName + "' does not exist!")));
            return 0;
        }
        RandomSource random = level.f_46441_;
        BlockPos.MutableBlockPos spawnPos = player.m_20183_().m_122032_().m_122184_((24 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1), 0, (24 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1));
        ModCommands.spawnPatrol(level, faction, size, player, spawnPos, forceGuns);
        MutableComponent factionLang = Component.m_237115_((String)("faction.jeg." + factionName));
        source.m_288197_(() -> Component.m_130674_((String)("Spawned a Patrol with " + size + " mobs for faction " + factionLang.getString())), true);
        if (!forceGuns) {
            source.m_81352_(Component.m_130674_((String)"Please note that by not setting 'forceGuns' to true, the chance of them spawning with Guns is entirely determined by your Config Files!"));
        }
        return 1;
    }

    private static int executeSimulatePhantomSwarm(CommandSourceStack source, int size, Player player) {
        if (!source.m_6761_(2)) {
            source.m_81352_(Component.m_130674_((String)"You do not have permission to execute this command"));
            return 0;
        }
        ServerLevel level = source.m_81372_();
        if (level.m_46791_() == Difficulty.PEACEFUL) {
            source.m_81352_(Component.m_130674_((String)"Mobs can't spawn in Peaceful!"));
            return 0;
        }
        RandomSource random = level.f_46441_;
        BlockPos.MutableBlockPos spawnPos = player.m_20183_().m_122032_().m_122184_((24 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1), 0, (24 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1));
        ModCommands.spawnPhantomSwarm(level, size, player, spawnPos);
        source.m_288197_(() -> Component.m_130674_((String)("Spawned a Phantom Swarm with " + size + " Phantoms!")), true);
        return 1;
    }

    private static int executeStartRaid(CommandSourceStack source, String factionName, Vec3 pos) {
        if (!source.m_6761_(2)) {
            source.m_81352_(Component.m_130674_((String)"You do not have permission to execute this command"));
            return 0;
        }
        ServerLevel level = source.m_81372_();
        if (level.m_46791_() == Difficulty.PEACEFUL) {
            source.m_81352_(Component.m_130674_((String)"Raids, can't be started on Peaceful, dummy."));
            return 0;
        }
        GunnerManager gunnerManager = GunnerManager.getInstance();
        Faction faction = gunnerManager.getFactionByName(factionName);
        if (faction == null) {
            source.m_81352_(Component.m_130674_((String)("Faction '" + factionName + "' does not exist!")));
            return 0;
        }
        ModCommands.startRaid(level, faction, pos, true);
        MutableComponent factionLang = Component.m_237115_((String)("faction.jeg." + factionName));
        source.m_288197_(() -> Component.m_130674_((String)("Started a Raid for the Faction " + factionLang.getString() + ", good luck!")), true);
        return 1;
    }

    public static void startRaid(ServerLevel level, Faction faction, Vec3 pos, boolean forceGun) {
        if (level.m_46791_().equals((Object)Difficulty.PEACEFUL)) {
            MutableComponent message = Component.m_237115_((String)"broadcast.jeg.raid.peaceful").m_130940_(ChatFormatting.WHITE);
            level.m_7654_().m_6846_().m_240416_((Component)message, true);
            return;
        }
        if (faction == null) {
            JustEnoughGuns.LOGGER.atInfo().log("A non existing Faction was trying to be summon for a Raid, but failed.");
            return;
        }
        int x = level.f_46441_.m_216339_(-50, 50);
        int z = level.f_46441_.m_216339_(-50, 50);
        RaidEntity.summonRaidEntity(level, faction, pos, true);
        level.m_5594_(null, BlockPos.m_274446_((Position)pos.m_82520_((double)x, 32.0, (double)z)), (SoundEvent)((Holder.Reference)SoundEvents.f_215702_.get(2)).get(), SoundSource.HOSTILE, 1000.0f, 1.0f);
    }

    private static int executeStartTerrorRaid(CommandSourceStack source, Vec3 pos) {
        if (!source.m_6761_(2)) {
            source.m_81352_(Component.m_130674_((String)"You do not have permission to execute this command"));
            return 0;
        }
        ServerLevel level = source.m_81372_();
        if (level.m_46791_() == Difficulty.PEACEFUL) {
            source.m_81352_(Component.m_130674_((String)"Raids, can't be started on Peaceful, dummy."));
            return 0;
        }
        ModCommands.startTerrorRaid(level, pos, true, false);
        MutableComponent factionLang = Component.m_237115_((String)"faction.jeg.terror_armada");
        source.m_288197_(() -> Component.m_130674_((String)("Started a Raid for the Faction " + factionLang.getString() + ", good luck!")), true);
        return 1;
    }

    public static void startTerrorRaid(ServerLevel level, Vec3 pos, boolean forceGun, boolean defeat) {
        if (level.m_46791_().equals((Object)Difficulty.PEACEFUL)) {
            MutableComponent message = Component.m_237115_((String)"broadcast.jeg.raid.peaceful").m_130940_(ChatFormatting.WHITE);
            level.m_7654_().m_6846_().m_240416_((Component)message, true);
            return;
        }
        int x = level.f_46441_.m_216339_(-50, 50);
        int z = level.f_46441_.m_216339_(-50, 50);
        TerrorRaidEntity.summonTerrorRaidEntity(level, pos, true, defeat);
        level.m_5594_(null, BlockPos.m_274446_((Position)pos.m_82520_((double)x, 32.0, (double)z)), (SoundEvent)ModSounds.TERROR_HORN.get(), SoundSource.HOSTILE, 1000.0f, 1.0f);
    }

    public static boolean spawnRaider(ServerLevel level, LivingEntity entity, Player player, BlockPos.MutableBlockPos spawnPos, Vec3 targetPos, boolean forceGuns) {
        RandomSource random = level.f_46441_;
        spawnPos.m_142448_(level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)spawnPos).m_123342_());
        return ModCommands.spawnRaidMember(level, (BlockPos)spawnPos, targetPos, entity, player, true, random);
    }

    private static boolean spawnRaidMember(ServerLevel level, BlockPos pos, Vec3 targetPos, LivingEntity entity, Player player, boolean forceGuns, RandomSource random) {
        if (!NaturalSpawner.m_47056_((BlockGetter)level, (BlockPos)pos, (BlockState)level.m_8055_(pos), (FluidState)level.m_8055_(pos).m_60819_(), (EntityType)EntityType.f_20513_)) {
            return false;
        }
        if (!Mob.m_217057_((EntityType)EntityType.f_20520_, (LevelAccessor)level, (MobSpawnType)MobSpawnType.NATURAL, (BlockPos)pos, (RandomSource)random)) {
            return false;
        }
        entity.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        entity.m_20049_("GunnerPatroller");
        if (level.m_46461_() && entity.m_6844_(EquipmentSlot.HEAD).m_41619_() && !entity.m_19880_().contains("EliteGunner") && entity.m_6095_().m_204039_(ModTags.Entities.UNDEAD)) {
            entity.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42407_));
        }
        level.m_7967_((Entity)entity);
        if (entity instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)entity;
            pathfinderMob.m_21573_().m_26519_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, (double)1.2f);
            pathfinderMob.m_6710_((LivingEntity)player);
        }
        return true;
    }

    public static int spawnPatrol(ServerLevel level, Faction faction, int size, Player player, BlockPos.MutableBlockPos spawnPos, boolean forceGuns) {
        RandomSource random = level.f_46441_;
        int spawns = 0;
        while (spawns < size) {
            spawnPos.m_142448_(level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)spawnPos).m_123342_());
            Mob entity = ModCommands.getFactionMob(level, faction, spawnPos.m_252807_(), forceGuns, 3);
            if (ModCommands.spawnDayPatrolMember(level, (BlockPos)spawnPos, random, entity, player)) {
                ++spawns;
            }
            spawnPos.m_122184_(random.m_188503_(5) - random.m_188503_(5), 0, random.m_188503_(5) - random.m_188503_(5));
        }
        return spawns;
    }

    private static boolean spawnDayPatrolMember(ServerLevel level, BlockPos pos, RandomSource random, Mob entity, Player player) {
        if (!NaturalSpawner.m_47056_((BlockGetter)level, (BlockPos)pos, (BlockState)level.m_8055_(pos), (FluidState)level.m_8055_(pos).m_60819_(), (EntityType)EntityType.f_20513_)) {
            return false;
        }
        if (!Mob.m_217057_((EntityType)EntityType.f_20520_, (LevelAccessor)level, (MobSpawnType)MobSpawnType.NATURAL, (BlockPos)pos, (RandomSource)random)) {
            return false;
        }
        entity.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        entity.m_20049_("GunnerPatroller");
        level.m_7967_((Entity)entity);
        if (entity.m_6844_(EquipmentSlot.HEAD).m_41619_() && !entity.m_19880_().contains("EliteGunner") && entity.m_6095_().m_204039_(ModTags.Entities.UNDEAD)) {
            entity.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42407_));
        }
        if (entity instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)entity;
            pathfinderMob.m_21573_().m_5624_((Entity)player, (double)1.2f);
        }
        entity.m_6710_((LivingEntity)player);
        if (entity.m_19880_().contains("EliteGunner") && level.f_46441_.m_188499_() && ((Boolean)Config.COMMON.gunnerMobs.horsemen.get()).booleanValue()) {
            if (entity instanceof Zombie) {
                ZombieHorse zombieHorse = new ZombieHorse(EntityType.f_20502_, (Level)level);
                zombieHorse.m_146884_(entity.m_20182_());
                zombieHorse.m_20049_("GunnerPatroller");
                level.m_7967_((Entity)zombieHorse);
                zombieHorse.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 400));
                entity.m_20329_((Entity)zombieHorse);
            } else if (entity instanceof AbstractSkeleton) {
                SkeletonHorse skeletonHorse = new SkeletonHorse(EntityType.f_20525_, (Level)level);
                skeletonHorse.m_146884_(entity.m_20182_());
                skeletonHorse.m_20049_("GunnerPatroller");
                level.m_7967_((Entity)skeletonHorse);
                skeletonHorse.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 400));
                entity.m_20329_((Entity)skeletonHorse);
            } else {
                Horse horse = new Horse(EntityType.f_20457_, (Level)level);
                horse.m_146884_(entity.m_20182_());
                horse.m_20049_("GunnerPatroller");
                level.m_7967_((Entity)horse);
                entity.m_20329_((Entity)horse);
            }
        }
        return true;
    }

    private static boolean spawnNightPatrolMember(ServerLevel level, BlockPos pos, RandomSource random, Mob entity, Player player) {
        if (!NaturalSpawner.m_47056_((BlockGetter)level, (BlockPos)pos, (BlockState)level.m_8055_(pos), (FluidState)level.m_8055_(pos).m_60819_(), (EntityType)EntityType.f_20501_)) {
            return false;
        }
        if (!Monster.m_219013_((EntityType)EntityType.f_20501_, (ServerLevelAccessor)level, (MobSpawnType)MobSpawnType.NATURAL, (BlockPos)pos, (RandomSource)random)) {
            return false;
        }
        entity.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        level.m_7967_((Entity)entity);
        entity.m_21573_().m_5624_((Entity)player, (double)1.2f);
        return true;
    }

    public static int spawnPhantomSwarm(ServerLevel level, int size, Player player, BlockPos.MutableBlockPos spawnPos) {
        RandomSource random = level.f_46441_;
        int spawns = 0;
        while (spawns < size) {
            spawnPos.m_142448_(player.m_20183_().m_6630_(32).m_123342_());
            Phantom phantom = new Phantom(EntityType.f_20509_, (Level)level);
            if ((double)level.f_46441_.m_188501_() < 0.4) {
                phantom = new PhantomGunner((EntityType<? extends Phantom>)((EntityType)ModEntities.PHANTOM_GUNNER.get()), (Level)level);
            } else if (((Boolean)Config.COMMON.gunnerMobs.explosiveMobs.get()).booleanValue() && (double)level.f_46441_.m_188501_() < 0.2) {
                ThrowableExplosiveChargeEntity explosiveChargeEntity = new ThrowableExplosiveChargeEntity((EntityType<? extends ThrowableGrenadeEntity>)((EntityType)ModEntities.THROWABLE_EXPLOSIVE_CHARGE.get()), (Level)level);
                level.m_7967_((Entity)explosiveChargeEntity);
                explosiveChargeEntity.m_20329_((Entity)phantom);
            }
            if (ModCommands.spawnPhantom(level, (BlockPos)spawnPos, phantom, player)) {
                ++spawns;
            }
            spawnPos.m_122184_(random.m_188503_(10) - random.m_188503_(10), random.m_188503_(10) - random.m_188503_(10), random.m_188503_(10) - random.m_188503_(10));
        }
        return spawns;
    }

    public static int spawnPhantomGunnerSquad(ServerLevel level, int size, Player player, BlockPos.MutableBlockPos spawnPos) {
        RandomSource random = level.f_46441_;
        int spawns = 0;
        while (spawns < size) {
            spawnPos.m_142448_(player.m_20183_().m_6630_(32).m_123342_());
            PhantomGunner phantom = new PhantomGunner((EntityType<? extends Phantom>)((EntityType)ModEntities.PHANTOM_GUNNER.get()), (Level)level);
            if (ModCommands.spawnPhantom(level, (BlockPos)spawnPos, phantom, player)) {
                ++spawns;
            }
            spawnPos.m_122184_(random.m_188503_(10) - random.m_188503_(10), random.m_188503_(10) - random.m_188503_(10), random.m_188503_(10) - random.m_188503_(10));
        }
        return spawns;
    }

    private static boolean spawnPhantom(ServerLevel level, BlockPos pos, Phantom phantom, Player player) {
        phantom.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        level.m_7967_((Entity)phantom);
        phantom.m_6710_((LivingEntity)player);
        if (level.m_46461_() && phantom.m_6095_().m_204039_(ModTags.Entities.UNDEAD)) {
            phantom.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 1200, 0, false, true));
            phantom.m_252836_();
        }
        return true;
    }

    private static int executeSpawnTrumpetBoi(CommandSourceStack source, Vec3 pos) {
        if (!source.m_6761_(2)) {
            source.m_81352_(Component.m_130674_((String)"You do not have permission to execute this command.\nNo Trumpet Boi :c"));
            return 0;
        }
        ServerLevel level = source.m_81372_();
        if (level.m_46791_() == Difficulty.PEACEFUL) {
            source.m_81352_(Component.m_130674_((String)"Mobs can't spawn in Peaceful!"));
            return 0;
        }
        ModCommands.spawnTrumpetBoi(level, pos);
        source.m_288197_(() -> Component.m_130674_((String)"Spawned a Trumpet Boi!"), true);
        return 1;
    }

    public static void spawnTrumpetBoi(ServerLevel level, Vec3 pos) {
        Skeleton trumpetBoi = new Skeleton(EntityType.f_20524_, (Level)level);
        trumpetBoi.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        trumpetBoi.m_20049_("TrumpetBoi");
        level.m_7967_((Entity)trumpetBoi);
    }
}

