/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.item.attachment.impl;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ttv.migami.jeg.interfaces.IGunModifier;
import ttv.migami.jeg.item.attachment.IAttachment;

@Mod.EventBusSubscriber(modid="jeg", value={Dist.CLIENT})
public abstract class Attachment {
    protected IGunModifier[] modifiers;
    private List<Component> perks = null;

    Attachment(IGunModifier ... modifiers) {
        this.modifiers = modifiers;
    }

    public IGunModifier[] getModifiers() {
        return this.modifiers;
    }

    void setPerks(List<Component> perks) {
        if (this.perks == null) {
            this.perks = perks;
        }
    }

    List<Component> getPerks() {
        return this.perks;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void addInformationEvent(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() instanceof IAttachment) {
            int inputRate;
            double inputAdsSpeed;
            float inputRecoil;
            int inputLife;
            float inputSpread;
            double inputSpeed;
            float inputDamage;
            double inputRadius;
            float inputSound;
            IAttachment attachment = (IAttachment)stack.m_41720_();
            List<Component> perks = ((Attachment)attachment.getProperties()).getPerks();
            if (perks != null && perks.size() > 0) {
                event.getToolTip().add(Component.m_237115_((String)"perk.jeg.title").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.BOLD}));
                event.getToolTip().addAll(perks);
                return;
            }
            IGunModifier[] modifiers = ((Attachment)attachment.getProperties()).getModifiers();
            ArrayList<Component> positivePerks = new ArrayList<Component>();
            ArrayList<Component> negativePerks = new ArrayList<Component>();
            float outputSound = inputSound = 1.0f;
            for (IGunModifier modifier : modifiers) {
                outputSound = modifier.modifyFireSoundVolume(outputSound);
            }
            if (outputSound > inputSound) {
                Attachment.addPerk(negativePerks, false, "perk.jeg.fire_volume.negative", new Object[0]);
            } else if (outputSound < inputSound) {
                Attachment.addPerk(positivePerks, true, "perk.jeg.fire_volume.positive", new Object[0]);
            }
            for (IGunModifier modifier : modifiers) {
                if (!modifier.flashlight()) continue;
                Attachment.addPerk(positivePerks, true, "perk.jeg.flashlight.positive", new Object[0]);
                break;
            }
            for (IGunModifier modifier : modifiers) {
                if (!modifier.laserPointer()) continue;
                Attachment.addPerk(positivePerks, true, "perk.jeg.laser_pointer.positive", new Object[0]);
                break;
            }
            for (IGunModifier modifier : modifiers) {
                if (!modifier.annoying()) continue;
                Attachment.addPerk(positivePerks, true, "perk.jeg.annoying.positive", new Object[0]);
                break;
            }
            for (IGunModifier modifier : modifiers) {
                if (!modifier.silencedFire()) continue;
                Attachment.addPerk(positivePerks, true, "perk.jeg.silenced.positive", new Object[0]);
                break;
            }
            for (IGunModifier modifier : modifiers) {
                if (!modifier.explosiveAmmo()) continue;
                Attachment.addPerk(positivePerks, true, "perk.jeg.explosive_ammo.positive", new Object[0]);
                break;
            }
            for (IGunModifier modifier : modifiers) {
                if (!modifier.increasedJamming()) continue;
                Attachment.addPerk(negativePerks, false, "perk.jeg.increased_jamming.negative", new Object[0]);
                break;
            }
            double outputRadius = inputRadius = 10.0;
            for (IGunModifier modifier : modifiers) {
                outputRadius = modifier.modifyFireSoundRadius(outputRadius);
            }
            if (outputRadius > inputRadius) {
                Attachment.addPerk(negativePerks, false, "perk.jeg.sound_radius.negative", new Object[0]);
            } else if (outputRadius < inputRadius) {
                Attachment.addPerk(positivePerks, true, "perk.jeg.sound_radius.positive", new Object[0]);
            }
            float additionalDamage = 0.0f;
            for (IGunModifier modifier : modifiers) {
                additionalDamage += modifier.additionalDamage();
            }
            if (additionalDamage > 0.0f) {
                Attachment.addPerk(positivePerks, true, "perk.jeg.additional_damage.positive", ItemStack.f_41584_.format((double)additionalDamage / 2.0));
            } else if (additionalDamage < 0.0f) {
                Attachment.addPerk(negativePerks, false, "perk.jeg.additional_damage.negative", ItemStack.f_41584_.format((double)additionalDamage / 2.0));
            }
            float outputDamage = inputDamage = 10.0f;
            for (IGunModifier modifier : modifiers) {
                outputDamage = modifier.modifyProjectileDamage(outputDamage);
            }
            if (outputDamage > inputDamage) {
                Attachment.addPerk(positivePerks, true, "perk.jeg.modified_damage.positive", new Object[0]);
            } else if (outputDamage < inputDamage) {
                Attachment.addPerk(negativePerks, false, "perk.jeg.modified_damage.negative", new Object[0]);
            }
            double outputSpeed = inputSpeed = 10.0;
            for (IGunModifier modifier : modifiers) {
                outputSpeed = modifier.modifyProjectileSpeed(outputSpeed);
            }
            if (outputSpeed > inputSpeed) {
                Attachment.addPerk(positivePerks, true, "perk.jeg.projectile_speed.positive", new Object[0]);
            } else if (outputSpeed < inputSpeed) {
                Attachment.addPerk(negativePerks, false, "perk.jeg.projectile_speed.negative", new Object[0]);
            }
            float outputSpread = inputSpread = 10.0f;
            for (IGunModifier modifier : modifiers) {
                outputSpread = modifier.modifyProjectileSpread(outputSpread);
            }
            if (outputSpread > inputSpread) {
                Attachment.addPerk(negativePerks, false, "perk.jeg.projectile_spread.negative", new Object[0]);
            } else if (outputSpread < inputSpread) {
                Attachment.addPerk(positivePerks, true, "perk.jeg.projectile_spread.positive", new Object[0]);
            }
            int outputLife = inputLife = 100;
            for (IGunModifier modifier : modifiers) {
                outputLife = modifier.modifyProjectileLife(outputLife);
            }
            if (outputLife > inputLife) {
                Attachment.addPerk(positivePerks, true, "perk.jeg.projectile_life.positive", new Object[0]);
            } else if (outputLife < inputLife) {
                Attachment.addPerk(negativePerks, false, "perk.jeg.projectile_life.negative", new Object[0]);
            }
            float outputRecoil = inputRecoil = 10.0f;
            for (IGunModifier modifier : modifiers) {
                outputRecoil *= modifier.recoilModifier();
            }
            if (outputRecoil > inputRecoil) {
                Attachment.addPerk(negativePerks, false, "perk.jeg.recoil.negative", new Object[0]);
            } else if (outputRecoil < inputRecoil) {
                Attachment.addPerk(positivePerks, true, "perk.jeg.recoil.positive", new Object[0]);
            }
            double outputAdsSpeed = inputAdsSpeed = 10.0;
            for (IGunModifier modifier : modifiers) {
                outputAdsSpeed = modifier.modifyAimDownSightSpeed(outputAdsSpeed);
            }
            if (outputAdsSpeed > inputAdsSpeed) {
                Attachment.addPerk(positivePerks, true, "perk.jeg.ads_speed.positive", new Object[0]);
            } else if (outputAdsSpeed < inputAdsSpeed) {
                Attachment.addPerk(negativePerks, false, "perk.jeg.ads_speed.negative", new Object[0]);
            }
            int outputRate = inputRate = 10;
            for (IGunModifier modifier : modifiers) {
                outputRate = modifier.modifyFireRate(outputRate);
            }
            if (outputRate > inputRate) {
                Attachment.addPerk(negativePerks, false, "perk.jeg.rate.negative", new Object[0]);
            } else if (outputRate < inputRate) {
                Attachment.addPerk(positivePerks, true, "perk.jeg.rate.positive", new Object[0]);
            }
            positivePerks.addAll(negativePerks);
            ((Attachment)attachment.getProperties()).setPerks(positivePerks);
            if (positivePerks.size() > 0) {
                event.getToolTip().add(Component.m_237115_((String)"perk.jeg.title").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.BOLD}));
                event.getToolTip().addAll(positivePerks);
            }
        }
    }

    private static void addPerk(List<Component> components, boolean positive, String id, Object ... params) {
        components.add((Component)Component.m_237110_((String)(positive ? "perk.jeg.entry.positive" : "perk.jeg.entry.negative"), (Object[])new Object[]{Component.m_237110_((String)id, (Object[])params).m_130940_(ChatFormatting.WHITE)}).m_130940_(positive ? ChatFormatting.DARK_AQUA : ChatFormatting.GOLD));
    }
}

