/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.jei;

import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import ttv.migami.jeg.JustEnoughGuns;
import ttv.migami.jeg.crafting.recycling.RecyclerRecipes;
import ttv.migami.jeg.crafting.recycling.RecyclingRecipe;
import ttv.migami.jeg.crafting.workbench.BlueprintWorkbenchRecipe;
import ttv.migami.jeg.crafting.workbench.GunmetalWorkbenchRecipe;
import ttv.migami.jeg.crafting.workbench.GunniteWorkbenchRecipe;
import ttv.migami.jeg.crafting.workbench.ScrapWorkbenchRecipe;
import ttv.migami.jeg.crafting.workbench.WorkbenchRecipes;
import ttv.migami.jeg.init.ModBlocks;
import ttv.migami.jeg.init.ModRecipeTypes;
import ttv.migami.jeg.jei.recycling.RecyclingCategory;
import ttv.migami.jeg.jei.workbench.BlueprintWorkbenchCategory;
import ttv.migami.jeg.jei.workbench.GunmetalWorkbenchCategory;
import ttv.migami.jeg.jei.workbench.GunniteWorkbenchCategory;
import ttv.migami.jeg.jei.workbench.ScrapWorkbenchCategory;

@JeiPlugin
public class JEGPlugin
implements IModPlugin {
    public static final RecipeType<RecyclingRecipe> RECYCLING = RecipeType.create((String)"jeg", (String)"recycling", RecyclingRecipe.class);
    public static final RecipeType<ScrapWorkbenchRecipe> SCRAP_WORKBENCH = RecipeType.create((String)"jeg", (String)"scrap_workbench", ScrapWorkbenchRecipe.class);
    public static final RecipeType<GunmetalWorkbenchRecipe> GUNMETAL_WORKBENCH = RecipeType.create((String)"jeg", (String)"gunmetal_workbench", GunmetalWorkbenchRecipe.class);
    public static final RecipeType<GunniteWorkbenchRecipe> GUNNITE_WORKBENCH = RecipeType.create((String)"jeg", (String)"gunnite_workbench", GunniteWorkbenchRecipe.class);
    public static final RecipeType<BlueprintWorkbenchRecipe> BLUEPRINT_WORKBENCH = RecipeType.create((String)"jeg", (String)"blueprint_workbench", BlueprintWorkbenchRecipe.class);

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jeg", "crafting");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new RecyclingCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ScrapWorkbenchCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new GunmetalWorkbenchCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new GunniteWorkbenchCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BlueprintWorkbenchCategory(helper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel world = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        NonNullList recyclingRecipes = RecyclerRecipes.getAll((Level)world, (net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.RECYCLING.get());
        JustEnoughGuns.LOGGER.atInfo().log("Registering {} recycling recipes", (Object)recyclingRecipes.size());
        registration.addRecipes(RECYCLING, recyclingRecipes);
        NonNullList scrapWorkbenchRecipes = WorkbenchRecipes.getAll((Level)world, (net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.SCRAP_WORKBENCH.get());
        JustEnoughGuns.LOGGER.atInfo().log("Registering {} Scrap Workbench recipes", (Object)scrapWorkbenchRecipes.size());
        registration.addRecipes(SCRAP_WORKBENCH, scrapWorkbenchRecipes);
        NonNullList gunmetalWorkbenchRecipes = WorkbenchRecipes.getAll((Level)world, (net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.GUNMETAL_WORKBENCH.get());
        JustEnoughGuns.LOGGER.atInfo().log("Registering {} Gunmetal Workbench recipes", (Object)gunmetalWorkbenchRecipes.size());
        registration.addRecipes(GUNMETAL_WORKBENCH, gunmetalWorkbenchRecipes);
        NonNullList gunniteWorkbenchRecipes = WorkbenchRecipes.getAll((Level)world, (net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.GUNNITE_WORKBENCH.get());
        JustEnoughGuns.LOGGER.atInfo().log("Registering {} Gunnite Workbench recipes", (Object)gunniteWorkbenchRecipes.size());
        registration.addRecipes(GUNNITE_WORKBENCH, gunniteWorkbenchRecipes);
        NonNullList blueprintWorkbenchRecipes = WorkbenchRecipes.getAll((Level)world, (net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.BLUEPRINT_WORKBENCH.get());
        JustEnoughGuns.LOGGER.atInfo().log("Registering {} Blueprint Workbench recipes", (Object)blueprintWorkbenchRecipes.size());
        registration.addRecipes(BLUEPRINT_WORKBENCH, blueprintWorkbenchRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.RECYCLER.get()), new RecipeType[]{RECYCLING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.SCRAP_WORKBENCH.get()), new RecipeType[]{SCRAP_WORKBENCH});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.GUNMETAL_WORKBENCH.get()), new RecipeType[]{GUNMETAL_WORKBENCH});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.GUNNITE_WORKBENCH.get()), new RecipeType[]{GUNNITE_WORKBENCH});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BLUEPRINT_WORKBENCH.get()), new RecipeType[]{BLUEPRINT_WORKBENCH});
    }
}

