/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.jei.workbench;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import ttv.migami.jeg.client.util.RenderUtil;
import ttv.migami.jeg.crafting.workbench.AbstractWorkbenchRecipe;

public abstract class AbstractWorkbenchCategory<T extends AbstractWorkbenchRecipe<?>>
implements IRecipeCategory<T> {
    protected static final ResourceLocation BACKGROUND = new ResourceLocation("jeg", "textures/gui/workbench.png");
    protected static final String TITLE_KEY = "jeg.category.workbench.title";
    protected static final String MATERIALS_KEY = "jeg.category.workbench.materials";
    protected final IDrawableStatic background;
    protected final IDrawableStatic window;
    protected final IDrawableStatic inventory;
    protected final IDrawable icon;
    protected final Component title;

    public AbstractWorkbenchCategory(IGuiHelper helper, ItemStack iconItem) {
        this.background = helper.createBlankDrawable(162, 124);
        this.window = helper.createDrawable(BACKGROUND, 7, 15, 162, 72);
        this.inventory = helper.createDrawable(BACKGROUND, 7, 101, 162, 36);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)iconItem);
        this.title = Component.m_237115_((String)TITLE_KEY);
    }

    public abstract RecipeType<T> getRecipeType();

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.window.draw(graphics, 0, 0);
        this.inventory.draw(graphics, 0, this.window.getHeight() + 2 + 11 + 2);
        graphics.m_280056_(Minecraft.m_91087_().f_91062_, I18n.m_118938_((String)MATERIALS_KEY, (Object[])new Object[0]), 0, 78, Color.DARK_GRAY.getRGB(), false);
        ItemStack output = ((AbstractWorkbenchRecipe)recipe).getItem();
        MutableComponent displayName = output.m_41786_().m_6881_();
        if (output.m_41613_() > 1) {
            displayName.m_7220_((Component)Component.m_237113_((String)(" x " + output.m_41613_())).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        }
        int titleX = this.window.getWidth() / 2;
        graphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)displayName, titleX, 5, Color.WHITE.getRGB());
        PoseStack stack = RenderSystem.getModelViewStack();
        stack.m_85836_();
        stack.m_252931_(graphics.m_280168_().m_85850_().m_252922_());
        stack.m_252880_(81.0f, 40.0f, 32.0f);
        stack.m_85841_(40.0f, 40.0f, 40.0f);
        stack.m_252781_(Axis.f_252529_.m_252977_(-5.0f));
        float partialTicks = Minecraft.m_91087_().m_91296_();
        stack.m_252781_(Axis.f_252436_.m_252977_((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks));
        stack.m_85841_(-1.0f, -1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        BakedModel model = RenderUtil.getModel(output);
        Lighting.m_84931_();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Minecraft.m_91087_().m_91291_().m_115143_(output, ItemDisplayContext.FIXED, false, new PoseStack(), (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_, model);
        buffer.m_109911_();
        stack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public abstract void setRecipe(IRecipeLayoutBuilder var1, T var2, IFocusGroup var3);
}

