/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.modifier;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Rarity;
import ttv.migami.jeg.modifier.Modifier;
import ttv.migami.jeg.modifier.type.ExplosiveAmmoModifier;
import ttv.migami.jeg.modifier.type.IModifierEffect;
import ttv.migami.jeg.modifier.type.PotionEffectModifier;
import ttv.migami.jeg.modifier.type.StatModifier;
import ttv.migami.jeg.modifier.type.StatType;

public class ModifierDeserializer
implements JsonDeserializer<Modifier> {
    public Modifier deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject json = jsonElement.getAsJsonObject();
        String name = json.get("name").getAsString();
        Rarity rarity = Rarity.valueOf((String)json.get("rarity").getAsString().toUpperCase());
        float chance = json.get("chance").getAsFloat();
        int color = json.get("color").getAsInt();
        ArrayList<IModifierEffect> effects = new ArrayList<IModifierEffect>();
        block10: for (JsonElement e : json.getAsJsonArray("modifiers")) {
            String typeKey;
            JsonObject obj = e.getAsJsonObject();
            switch (typeKey = obj.get("type").getAsString().toLowerCase()) {
                case "stat": {
                    StatType stat = StatType.valueOf(obj.get("attribute").getAsString().toUpperCase());
                    double value = obj.get("amount").getAsDouble();
                    effects.add(new StatModifier(stat, value));
                    continue block10;
                }
                case "potion_effect": {
                    String effectName = obj.get("effect").getAsString();
                    MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation(effectName));
                    if (effect == null) {
                        throw new JsonParseException("Unknown MobEffect: " + effectName);
                    }
                    int duration = obj.get("duration").getAsInt();
                    int amplifier = obj.get("amplifier").getAsInt();
                    effects.add(new PotionEffectModifier(effect, duration, amplifier));
                    continue block10;
                }
                case "explosive_ammo": {
                    effects.add(new ExplosiveAmmoModifier());
                    continue block10;
                }
            }
            throw new JsonParseException("Unknown modifier type: " + typeKey);
        }
        return new Modifier(name, rarity, chance, color, effects.toArray(new IModifierEffect[0]));
    }
}

