/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.modifier;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import ttv.migami.jeg.modifier.Modifier;

public class ModifierRegistry {
    private static final Map<ResourceLocation, Modifier> GROUPS = new HashMap<ResourceLocation, Modifier>();

    public static void setGroups(Map<ResourceLocation, Modifier> groups) {
        GROUPS.clear();
        GROUPS.putAll(groups);
    }

    @Nullable
    public static Modifier get(ResourceLocation id) {
        return GROUPS.get(id);
    }

    public static Collection<Modifier> getAll() {
        return GROUPS.values();
    }

    @Nullable
    public static Modifier getRandom(RandomSource random) {
        float totalWeight = 0.0f;
        for (Modifier group : GROUPS.values()) {
            totalWeight += group.getChance();
        }
        if (totalWeight <= 0.0f) {
            return null;
        }
        float roll = random.m_188501_() * totalWeight;
        float cumulative = 0.0f;
        for (Modifier group : GROUPS.values()) {
            if (!(roll <= (cumulative += group.getChance()))) continue;
            return group;
        }
        return null;
    }
}

