/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsutility.modules.environmental.blocks.EnvironmentalControllerTileEntity;
import mcjty.rftoolsutility.modules.environmental.modules.EnvironmentModule;
import mcjty.rftoolsutility.playerprops.BuffProperties;
import mcjty.rftoolsutility.playerprops.PlayerBuff;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class PotionEffectModule
implements EnvironmentModule {
    public static final int MAXTICKS = 180;
    private final MobEffect potion;
    private final int amplifier;
    private boolean active = false;
    private int ticks = 180;

    public PotionEffectModule(String potionname, int amplifier) {
        this.potion = Tools.getEffect((ResourceLocation)new ResourceLocation(potionname));
        this.amplifier = amplifier;
    }

    protected abstract PlayerBuff getBuff();

    protected boolean allowedForPlayers() {
        return true;
    }

    @Override
    public void tick(Level world, BlockPos pos, int radius, int miny, int maxy, EnvironmentalControllerTileEntity controllerTileEntity) {
        if (!this.active) {
            return;
        }
        --this.ticks;
        if (this.ticks > 0) {
            return;
        }
        this.ticks = 180;
        EnvironmentalControllerTileEntity.EnvironmentalMode mode = controllerTileEntity.getMode();
        switch (mode) {
            case MODE_BLACKLIST: 
            case MODE_WHITELIST: {
                if (!this.allowedForPlayers()) break;
                this.processPlayers(world, pos, radius, miny, maxy, controllerTileEntity);
                break;
            }
            case MODE_HOSTILE: 
            case MODE_PASSIVE: 
            case MODE_MOBS: 
            case MODE_ALL: {
                this.processEntities(world, pos, radius, miny, maxy, controllerTileEntity);
            }
        }
    }

    private void processPlayers(Level world, BlockPos pos, int radius, int miny, int maxy, EnvironmentalControllerTileEntity controllerTileEntity) {
        double maxsqdist = radius * radius;
        ArrayList players = new ArrayList(world.m_6907_());
        for (Player player : players) {
            double py = player.m_20186_();
            if (!(py >= (double)miny) || !(py <= (double)maxy)) continue;
            double px = player.m_20185_();
            double pz = player.m_20189_();
            double sqdist = (px - (double)pos.m_123341_()) * (px - (double)pos.m_123341_()) + (pz - (double)pos.m_123343_()) * (pz - (double)pos.m_123343_());
            if (!(sqdist < maxsqdist) || !controllerTileEntity.isPlayerAffected(player)) continue;
            player.m_7292_(new MobEffectInstance(this.potion, 540, this.amplifier, true, false));
            PlayerBuff buff = this.getBuff();
            if (buff == null) continue;
            BuffProperties.addBuffToPlayer(player, buff, 180);
        }
    }

    private void processEntities(Level world, BlockPos pos, int radius, int miny, int maxy, EnvironmentalControllerTileEntity controllerTileEntity) {
        double maxsqdist = radius * radius;
        List entities = world.m_142425_((EntityTypeTest)new EntityTypeTest<Entity, LivingEntity>(){

            @Nullable
            public LivingEntity tryCast(Entity pEntity) {
                if (pEntity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)pEntity;
                    return livingEntity;
                }
                return null;
            }

            public Class<? extends Entity> m_142225_() {
                return LivingEntity.class;
            }
        }, new AABB((double)(pos.m_123341_() - radius), (double)(pos.m_123342_() - radius), (double)(pos.m_123343_() - radius), (double)(pos.m_123341_() + radius), (double)(pos.m_123342_() + radius), (double)(pos.m_123343_() + radius)), Objects::nonNull);
        for (LivingEntity entity : entities) {
            PlayerBuff buff;
            double py = entity.m_20186_();
            if (!(py >= (double)miny) || !(py <= (double)maxy)) continue;
            double px = entity.m_20185_();
            double pz = entity.m_20189_();
            double sqdist = (px - (double)pos.m_123341_()) * (px - (double)pos.m_123341_()) + (pz - (double)pos.m_123343_()) * (pz - (double)pos.m_123343_());
            if (!(sqdist < maxsqdist)) continue;
            if (controllerTileEntity.isEntityAffected((Entity)entity)) {
                if (entity instanceof Player && !this.allowedForPlayers()) continue;
                entity.m_7292_(new MobEffectInstance(this.potion, 540, this.amplifier, true, false));
                buff = this.getBuff();
                if (buff == null || !(entity instanceof Player)) continue;
                BuffProperties.addBuffToPlayer((Player)entity, buff, 180);
                continue;
            }
            if (!(entity instanceof Player) || (buff = this.getBuff()) == null) continue;
            BuffProperties.addBuffToPlayer((Player)entity, buff, 180);
        }
    }

    @Override
    public boolean apply(Level world, BlockPos pos, LivingEntity entity, int duration) {
        entity.m_7292_(new MobEffectInstance(this.potion, duration, this.amplifier, true, false));
        return true;
    }

    @Override
    public void activate(boolean a) {
        if (this.active == a) {
            return;
        }
        this.active = a;
        this.ticks = 1;
    }

    public static PotionEffectModule create(String name, int amplifier, final PlayerBuff buff, final double rfPerTick) {
        return new PotionEffectModule(name, amplifier){

            @Override
            protected PlayerBuff getBuff() {
                return buff;
            }

            @Override
            public float getRfPerTick() {
                return (float)rfPerTick;
            }
        };
    }

    public static PotionEffectModule create(String name, int amplifier, final PlayerBuff buff, final double rfPerTick, final Supplier<Boolean> isAllowed) {
        return new PotionEffectModule(name, amplifier){

            @Override
            protected PlayerBuff getBuff() {
                return buff;
            }

            @Override
            public float getRfPerTick() {
                return (float)rfPerTick;
            }

            @Override
            protected boolean allowedForPlayers() {
                return (Boolean)isAllowed.get();
            }
        };
    }
}

