/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modules;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.CapabilityTools;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleDataContents;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.modules.ScreenModuleHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FluidBarScreenModule
implements IScreenModule<IModuleDataContents> {
    protected ResourceKey<Level> dim = Level.f_46428_;
    protected BlockPos coordinate = BlockPosTools.INVALID;
    protected ScreenModuleHelper helper = new ScreenModuleHelper();

    public IModuleDataContents getData(IScreenDataHelper h, Level worldObj, long millis) {
        ServerLevel world = LevelTools.getLevel((Level)worldObj, this.dim);
        if (world == null) {
            return null;
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)this.coordinate)) {
            return null;
        }
        AtomicInteger contents = new AtomicInteger();
        AtomicInteger maxContents = new AtomicInteger();
        BlockEntity te = world.m_7702_(this.coordinate);
        if (!CapabilityTools.getFluidCapabilitySafe((BlockEntity)te).map(hf -> {
            if (hf.getTanks() > 0) {
                if (!hf.getFluidInTank(0).isEmpty()) {
                    contents.set(hf.getFluidInTank(0).getAmount());
                }
                maxContents.set(hf.getTankCapacity(0));
            }
            return true;
        }).orElse(false).booleanValue()) {
            return null;
        }
        return this.helper.getContentsValue(millis, contents.get(), maxContents.get());
    }

    public void setupFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        if (tagCompound != null) {
            this.helper.setShowdiff(tagCompound.m_128471_("showdiff"));
            this.coordinate = BlockPosTools.INVALID;
            if (tagCompound.m_128441_("monitorx")) {
                this.dim = LevelTools.getId((String)tagCompound.m_128461_("monitordim"));
                if (Objects.equals(dim, this.dim)) {
                    BlockPos c = new BlockPos(tagCompound.m_128451_("monitorx"), tagCompound.m_128451_("monitory"), tagCompound.m_128451_("monitorz"));
                    int dx = Math.abs(c.m_123341_() - pos.m_123341_());
                    int dy = Math.abs(c.m_123342_() - pos.m_123342_());
                    int dz = Math.abs(c.m_123343_() - pos.m_123343_());
                    if (dx <= 64 && dy <= 64 && dz <= 64) {
                        this.coordinate = c;
                    }
                }
            }
        }
    }

    public int getRfPerTick() {
        return (Integer)ScreenConfiguration.FLUID_RFPERTICK.get();
    }

    public void mouseClick(Level world, int x, int y, boolean clicked, Player player) {
    }
}

