/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless;

import dev.huskuraft.effortless.EffortlessClient;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.networking.NetworkChannel;
import dev.huskuraft.effortless.api.networking.Packet;
import dev.huskuraft.effortless.api.networking.Side;
import dev.huskuraft.effortless.building.config.ClientConfig;
import dev.huskuraft.effortless.networking.packets.AllPacketListener;
import dev.huskuraft.effortless.networking.packets.player.PlayerBuildPacket;
import dev.huskuraft.effortless.networking.packets.player.PlayerBuildTooltipPacket;
import dev.huskuraft.effortless.networking.packets.player.PlayerCommandPacket;
import dev.huskuraft.effortless.networking.packets.player.PlayerPermissionCheckPacket;
import dev.huskuraft.effortless.networking.packets.player.PlayerSettingsPacket;
import dev.huskuraft.effortless.networking.packets.player.PlayerSnapshotCapturePacket;
import dev.huskuraft.effortless.networking.packets.player.PlayerSnapshotSharePacket;
import dev.huskuraft.effortless.networking.packets.session.SessionConfigPacket;
import dev.huskuraft.effortless.networking.packets.session.SessionPacket;

public final class EffortlessClientNetworkChannel
extends NetworkChannel<AllPacketListener> {
    private static final int COMPATIBILITY_VERSION = 13;
    private final EffortlessClient entrance;
    private final AllPacketListener listener;

    public EffortlessClientNetworkChannel(EffortlessClient entrance) {
        this(entrance, "default");
    }

    public EffortlessClientNetworkChannel(EffortlessClient entrance, String name) {
        super(entrance, name, Side.CLIENT);
        this.entrance = entrance;
        this.listener = new ClientPacketListener();
        this.registerPacket(SessionPacket.class, new SessionPacket.Serializer());
        this.registerPacket(SessionConfigPacket.class, new SessionConfigPacket.Serializer());
        this.registerPacket(PlayerCommandPacket.class, new PlayerCommandPacket.Serializer());
        this.registerPacket(PlayerSettingsPacket.class, new PlayerSettingsPacket.Serializer());
        this.registerPacket(PlayerBuildPacket.class, new PlayerBuildPacket.Serializer());
        this.registerPacket(PlayerPermissionCheckPacket.class, new PlayerPermissionCheckPacket.Serializer());
        this.registerPacket(PlayerBuildTooltipPacket.class, new PlayerBuildTooltipPacket.Serializer());
        this.registerPacket(PlayerSnapshotCapturePacket.class, new PlayerSnapshotCapturePacket.Serializer());
        this.registerPacket(PlayerSnapshotSharePacket.class, new PlayerSnapshotSharePacket.Serializer());
        this.getEntrance().getEventRegistry().getRegisterNetworkEvent().register(this::onRegisterNetwork);
    }

    private EffortlessClient getEntrance() {
        return this.entrance;
    }

    @Override
    public void receivePacket(Packet packet, Player player) {
        packet.handle(this.listener, player);
    }

    @Override
    public int getCompatibilityVersion() {
        return 13;
    }

    private class ClientPacketListener
    implements AllPacketListener {
        private ClientPacketListener() {
        }

        private boolean isValidReceiver() {
            if (EffortlessClientNetworkChannel.this.getEntrance().getClient() == null) {
                return false;
            }
            return EffortlessClientNetworkChannel.this.getEntrance().getClient().getWorld() != null;
        }

        @Override
        public void handle(PlayerCommandPacket packet, Player player) {
            switch (packet.action()) {
                default: 
            }
        }

        @Override
        public void handle(PlayerSettingsPacket packet, Player player) {
        }

        @Override
        public void handle(PlayerBuildPacket packet, Player player) {
            if (!this.isValidReceiver()) {
                return;
            }
            Player owner = EffortlessClientNetworkChannel.this.getEntrance().getClient().getWorld().getPlayer(packet.playerId());
            if (owner == null) {
                return;
            }
            EffortlessClientNetworkChannel.this.getEntrance().getClient().execute(() -> EffortlessClientNetworkChannel.this.getEntrance().getStructureBuilder().onContextReceived(owner, packet.context()));
        }

        @Override
        public void handle(PlayerPermissionCheckPacket packet, Player player) {
        }

        @Override
        public void handle(PlayerBuildTooltipPacket packet, Player player) {
            if (!this.isValidReceiver()) {
                return;
            }
            EffortlessClientNetworkChannel.this.getEntrance().getClient().execute(() -> EffortlessClientNetworkChannel.this.getEntrance().getStructureBuilder().onTooltipReceived(player, packet.operationTooltip()));
        }

        @Override
        public void handle(SessionPacket packet, Player player) {
            EffortlessClientNetworkChannel.this.getEntrance().getClient().execute(() -> EffortlessClientNetworkChannel.this.getEntrance().getSessionManager().onSession(packet.session(), player));
        }

        @Override
        public void handle(SessionConfigPacket packet, Player player) {
            EffortlessClientNetworkChannel.this.getEntrance().getClient().execute(() -> EffortlessClientNetworkChannel.this.getEntrance().getSessionManager().onSessionConfig(packet.sessionConfig(), player));
        }

        @Override
        public void handle(PlayerSnapshotCapturePacket packet, Player player) {
            EffortlessClientNetworkChannel.this.getEntrance().getConfigStorage().update(config -> new ClientConfig(config.renderConfig(), config.patternConfig(), config.clipboardConfig().appendHistory(packet.snapshot())));
            EffortlessClientNetworkChannel.this.getEntrance().getClient().execute(() -> EffortlessClientNetworkChannel.this.getEntrance().getStructureBuilder().onSnapshotCaptured(player, packet.snapshot()));
        }

        @Override
        public void handle(PlayerSnapshotSharePacket packet, Player player) {
            EffortlessClientNetworkChannel.this.getEntrance().getClient().execute(() -> {});
        }
    }
}

