/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.config.universal;

import dev.huskuraft.effortless.api.config.ConfigSerializer;
import dev.huskuraft.effortless.api.nightconfig.core.CommentedConfig;
import dev.huskuraft.effortless.api.nightconfig.core.Config;
import dev.huskuraft.effortless.api.nightconfig.core.ConfigSpec;
import dev.huskuraft.effortless.building.config.ClientConfig;
import dev.huskuraft.effortless.building.config.ClipboardConfig;
import dev.huskuraft.effortless.building.config.PatternConfig;
import dev.huskuraft.effortless.building.config.RenderConfig;
import dev.huskuraft.effortless.building.config.universal.SnapshotConfigSerializer;
import dev.huskuraft.effortless.building.config.universal.TransformerConfigSerializer;
import java.util.List;
import java.util.Objects;

public class ClientConfigConfigSerializer
implements ConfigSerializer<ClientConfig> {
    private static final String KEY_RENDER = "render";
    private static final String KEY_SHOW_OTHER_PLAYERS_BUILD = "showOtherPlayersBuild";
    private static final String KEY_SHOW_BLOCK_PREVIEW = "showBlockPreview";
    private static final String KEY_MAX_RENDER_VOLUME = "maxRenderVolume";
    private static final String KEY_BUILDER = "builder";
    private static final String KEY_PATTERN = "pattern";
    private static final String KEY_TRANSFORMER_PRESETS = "transformerPresets";
    private static final String KEY_CLIPBOARD = "clipboard";
    private static final String KEY_COLLECTIONS = "collections";
    private static final String KEY_RESERVED_TOOL_DURABILITY = "reservedToolDurability";

    @Override
    public ConfigSpec getSpec(Config config) {
        ConfigSpec spec = new ConfigSpec();
        spec.define(List.of(KEY_RENDER, KEY_SHOW_BLOCK_PREVIEW), () -> this.getDefault().renderConfig().showBlockPreview(), Boolean.class::isInstance);
        spec.define(List.of(KEY_RENDER, KEY_SHOW_OTHER_PLAYERS_BUILD), () -> this.getDefault().renderConfig().showOtherPlayersBuild(), Boolean.class::isInstance);
        spec.defineInRange(List.of(KEY_RENDER, KEY_MAX_RENDER_VOLUME), Integer.valueOf(this.getDefault().renderConfig().maxRenderVolume()), Integer.valueOf(0), Integer.valueOf(4096));
        spec.defineList(List.of(KEY_PATTERN, KEY_TRANSFORMER_PRESETS), () -> this.getDefault().patternConfig().itemRandomizers().stream().map(TransformerConfigSerializer.INSTANCE::serialize).toList(), Config.class::isInstance);
        spec.defineList(List.of(KEY_CLIPBOARD, KEY_COLLECTIONS), () -> this.getDefault().clipboardConfig().collections().stream().map(SnapshotConfigSerializer.INSTANCE::serialize).toList(), Config.class::isInstance);
        spec.defineInRange(List.of(KEY_BUILDER, KEY_RESERVED_TOOL_DURABILITY), Integer.valueOf(this.getDefault().builderConfig().reservedToolDurability()), Integer.valueOf(0), Integer.valueOf(32));
        return spec;
    }

    @Override
    public ClientConfig deserialize(Config config) {
        this.validate(config);
        return new ClientConfig(new RenderConfig((Boolean)config.get(List.of(KEY_RENDER, KEY_SHOW_BLOCK_PREVIEW)), (Boolean)config.get(List.of(KEY_RENDER, KEY_SHOW_OTHER_PLAYERS_BUILD)), false, (Integer)config.get(List.of(KEY_RENDER, KEY_MAX_RENDER_VOLUME)), 128), new PatternConfig(((List)config.get(List.of(KEY_PATTERN, KEY_TRANSFORMER_PRESETS))).stream().map(TransformerConfigSerializer.INSTANCE::deserialize).toList()), new ClipboardConfig(((List)config.get(List.of(KEY_CLIPBOARD, KEY_COLLECTIONS))).stream().map(SnapshotConfigSerializer.INSTANCE::deserialize).toList(), List.of()));
    }

    @Override
    public Config serialize(ClientConfig settings) {
        CommentedConfig config = CommentedConfig.inMemory();
        config.set(List.of(KEY_RENDER, KEY_SHOW_BLOCK_PREVIEW), (Object)settings.renderConfig().showBlockPreview());
        config.set(List.of(KEY_RENDER, KEY_SHOW_OTHER_PLAYERS_BUILD), (Object)settings.renderConfig().showOtherPlayersBuild());
        config.set(List.of(KEY_RENDER, KEY_MAX_RENDER_VOLUME), (Object)settings.renderConfig().maxRenderVolume());
        config.set(List.of(KEY_PATTERN, KEY_TRANSFORMER_PRESETS), settings.patternConfig().itemRandomizers().stream().map(TransformerConfigSerializer.INSTANCE::serialize).filter(Objects::nonNull).toList());
        config.set(List.of(KEY_CLIPBOARD, KEY_COLLECTIONS), settings.clipboardConfig().collections().stream().map(SnapshotConfigSerializer.INSTANCE::serialize).filter(Objects::nonNull).toList());
        this.validate(config);
        return config;
    }

    @Override
    public ClientConfig getDefault() {
        return ClientConfig.DEFAULT;
    }
}

