/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.config.universal;

import dev.huskuraft.effortless.api.config.ConfigSerializer;
import dev.huskuraft.effortless.api.core.Axis;
import dev.huskuraft.effortless.api.core.Item;
import dev.huskuraft.effortless.api.core.Items;
import dev.huskuraft.effortless.api.core.ResourceLocation;
import dev.huskuraft.effortless.api.math.BoundingBox3d;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.api.nightconfig.core.Config;
import dev.huskuraft.effortless.api.nightconfig.core.ConfigSpec;
import dev.huskuraft.effortless.api.nightconfig.core.EnumGetMethod;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.pattern.Transformer;
import dev.huskuraft.effortless.building.pattern.Transformers;
import dev.huskuraft.effortless.building.pattern.array.ArrayTransformer;
import dev.huskuraft.effortless.building.pattern.mirror.MirrorTransformer;
import dev.huskuraft.effortless.building.pattern.raidal.RadialTransformer;
import dev.huskuraft.effortless.building.pattern.randomize.Chance;
import dev.huskuraft.effortless.building.pattern.randomize.ItemRandomizer;
import dev.huskuraft.effortless.building.pattern.randomize.Randomizer;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class TransformerConfigSerializer
implements ConfigSerializer<Transformer> {
    public static final TransformerConfigSerializer INSTANCE = new TransformerConfigSerializer();
    private static final String KEY_ID = "id";
    private static final String KEY_TYPE = "type";

    private TransformerConfigSerializer() {
    }

    public static String randomIdString() {
        return UUID.randomUUID().toString();
    }

    public static boolean isIdCorrect(Object string) {
        try {
            UUID.fromString((String)string);
            return true;
        }
        catch (ClassCastException | IllegalArgumentException e) {
            return false;
        }
    }

    public static void defineVector3d(ConfigSpec configSpec, String key, Vector3d defaultValue, double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        configSpec.define(key, () -> List.of(Double.valueOf(defaultValue.x()), Double.valueOf(defaultValue.y()), Double.valueOf(defaultValue.z())), value -> {
            Number z;
            Object patt2$temp;
            Number y;
            Object patt1$temp;
            Number x;
            Object patt0$temp;
            List list;
            return value instanceof List && (list = (List)value).size() == 3 && (patt0$temp = list.get(0)) instanceof Number && (x = (Number)patt0$temp).doubleValue() >= minX && x.doubleValue() <= maxX && (patt1$temp = list.get(1)) instanceof Number && (y = (Number)patt1$temp).doubleValue() >= minY && y.doubleValue() <= maxY && (patt2$temp = list.get(2)) instanceof Number && (z = (Number)patt2$temp).doubleValue() >= minZ && z.doubleValue() <= maxZ;
        });
    }

    public static void defineVector3d(ConfigSpec configSpec, String key, Vector3d defaultValue, BoundingBox3d boundingBox3d) {
        TransformerConfigSerializer.defineVector3d(configSpec, key, defaultValue, boundingBox3d.minX(), boundingBox3d.maxX(), boundingBox3d.minY(), boundingBox3d.maxY(), boundingBox3d.minZ(), boundingBox3d.maxZ());
    }

    public static void defineVector3d(ConfigSpec configSpec, String key, Vector3d defaultValue) {
        TransformerConfigSerializer.defineVector3d(configSpec, key, defaultValue, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public static void defineVector3d(ConfigSpec configSpec, String key) {
        TransformerConfigSerializer.defineVector3d(configSpec, key, Vector3d.ZERO);
    }

    public static <T extends Enum<T>> void defineEnum(ConfigSpec configSpec, String key, T defaultValue) {
        configSpec.define(key, () -> defaultValue.name().toLowerCase(Locale.ROOT), value -> {
            if (!(value instanceof String)) return false;
            String name = (String)value;
            if (!Arrays.stream((Enum[])defaultValue.getDeclaringClass().getEnumConstants()).anyMatch(e -> e.name().equals(name.toUpperCase(Locale.ROOT)))) return false;
            return true;
        });
    }

    public static void setVector3d(Config config, String key, Vector3d value) {
        config.set(key, List.of(Double.valueOf(value.x()), Double.valueOf(value.y()), Double.valueOf(value.z())));
    }

    public static Vector3d getVector3d(Config config, String key) {
        Double[] values = (Double[])((List)config.get(key)).stream().map(Number::doubleValue).toArray(Double[]::new);
        return new Vector3d(values[0], values[1], values[2]);
    }

    public static <T extends Enum<T>> void setEnum(Config config, String key, T value) {
        config.set(key, (Object)value.name().toLowerCase(Locale.ROOT));
    }

    public static <T extends Enum<T>> T getEnum(Config config, String key, T ... typeGetter) {
        return (T)config.getEnum(key, typeGetter.getClass().getComponentType());
    }

    public static boolean isSuccess(Runnable runnable) {
        try {
            runnable.run();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Predicate<Object> predicate(Consumer<Object> consumer) {
        return object -> {
            try {
                consumer.accept(object);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        };
    }

    @Override
    public ConfigSpec getSpec(Config config) {
        ConfigSpec spec = new ConfigSpec();
        spec.define(KEY_ID, TransformerConfigSerializer::randomIdString, TransformerConfigSerializer::isIdCorrect);
        return spec;
    }

    @Override
    public Transformer deserialize(Config config) {
        Transformers type;
        try {
            type = Objects.requireNonNull(config.getEnum(KEY_TYPE, Transformers.class, EnumGetMethod.NAME_IGNORECASE));
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException e) {
            return null;
        }
        return (switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Transformers.ARRAY -> ArrayTransformerConfigSerializer.INSTANCE;
            case Transformers.MIRROR -> MirrorTransformerConfigSerializer.INSTANCE;
            case Transformers.RADIAL -> RadialTransformerConfigSerializer.INSTANCE;
            case Transformers.RANDOMIZER -> ItemRandomizerConfigSerializer.INSTANCE;
        }).deserialize(config);
    }

    @Override
    public Transformer getDefault() {
        return null;
    }

    @Override
    public Config serialize(Transformer transformer) {
        return switch (transformer.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case Transformers.ARRAY -> ArrayTransformerConfigSerializer.INSTANCE.serialize((ArrayTransformer)transformer);
            case Transformers.MIRROR -> MirrorTransformerConfigSerializer.INSTANCE.serialize((MirrorTransformer)transformer);
            case Transformers.RADIAL -> RadialTransformerConfigSerializer.INSTANCE.serialize((RadialTransformer)transformer);
            case Transformers.RANDOMIZER -> ItemRandomizerConfigSerializer.INSTANCE.serialize((ItemRandomizer)transformer);
        };
    }

    public static class ArrayTransformerConfigSerializer
    implements ConfigSerializer<ArrayTransformer> {
        private static final String KEY_OFFSET = "offset";
        private static final String KEY_COUNT = "count";
        public static ArrayTransformerConfigSerializer INSTANCE = new ArrayTransformerConfigSerializer();

        private ArrayTransformerConfigSerializer() {
        }

        @Override
        public ConfigSpec getSpec(Config config) {
            ConfigSpec spec = new ConfigSpec();
            spec.define(TransformerConfigSerializer.KEY_ID, TransformerConfigSerializer::randomIdString, TransformerConfigSerializer::isIdCorrect);
            TransformerConfigSerializer.defineEnum(spec, TransformerConfigSerializer.KEY_TYPE, this.getDefault().getType());
            TransformerConfigSerializer.defineVector3d(spec, KEY_OFFSET, ArrayTransformer.ZERO.offset().toVector3d(), ArrayTransformer.OFFSET_BOUND.toBoundingBox3d());
            spec.defineInRange(KEY_COUNT, Integer.valueOf(this.getDefault().count()), Integer.valueOf(ArrayTransformer.COUNT_RANGE.min()), Integer.valueOf(ArrayTransformer.COUNT_RANGE.max()));
            return spec;
        }

        @Override
        public ArrayTransformer getDefault() {
            return ArrayTransformer.ZERO;
        }

        @Override
        public ArrayTransformer deserialize(Config config) {
            this.validate(config);
            return new ArrayTransformer(UUID.fromString((String)config.get(TransformerConfigSerializer.KEY_ID)), Text.empty(), TransformerConfigSerializer.getVector3d(config, KEY_OFFSET).toVector3i(), (Integer)config.get(KEY_COUNT));
        }

        @Override
        public Config serialize(ArrayTransformer transformer) {
            Config config = Config.inMemory();
            config.set(TransformerConfigSerializer.KEY_ID, (Object)transformer.getId().toString());
            TransformerConfigSerializer.setEnum(config, TransformerConfigSerializer.KEY_TYPE, transformer.getType());
            TransformerConfigSerializer.setVector3d(config, KEY_OFFSET, transformer.offset().toVector3d());
            config.set(KEY_COUNT, (Object)transformer.count());
            this.validate(config);
            return config;
        }
    }

    public static class MirrorTransformerConfigSerializer
    implements ConfigSerializer<MirrorTransformer> {
        private static final String KEY_POSITION = "position";
        private static final String KEY_POSITION_TYPE = "positionType";
        private static final String KEY_AXIS = "axis";
        private static final String KEY_SIZE = "size";
        public static MirrorTransformerConfigSerializer INSTANCE = new MirrorTransformerConfigSerializer();

        private MirrorTransformerConfigSerializer() {
        }

        @Override
        public ConfigSpec getSpec(Config config) {
            ConfigSpec spec = new ConfigSpec();
            spec.define(TransformerConfigSerializer.KEY_ID, TransformerConfigSerializer::randomIdString, TransformerConfigSerializer::isIdCorrect);
            TransformerConfigSerializer.defineEnum(spec, TransformerConfigSerializer.KEY_TYPE, this.getDefault().getType());
            TransformerConfigSerializer.defineVector3d(spec, KEY_POSITION, MirrorTransformer.ZERO_Y.position());
            spec.defineInRange(KEY_SIZE, Integer.valueOf(this.getDefault().size()), Integer.valueOf(MirrorTransformer.SIZE_RANGE.min()), Integer.valueOf(MirrorTransformer.SIZE_RANGE.max()));
            TransformerConfigSerializer.defineEnum(spec, KEY_AXIS, this.getDefault().axis());
            return spec;
        }

        @Override
        public MirrorTransformer getDefault() {
            return MirrorTransformer.ZERO_Y;
        }

        @Override
        public MirrorTransformer deserialize(Config config) {
            this.validate(config);
            return new MirrorTransformer(UUID.fromString((String)config.get(TransformerConfigSerializer.KEY_ID)), Text.empty(), TransformerConfigSerializer.getVector3d(config, KEY_POSITION), (Axis)TransformerConfigSerializer.getEnum((Config)config, (String)KEY_AXIS, (Enum[])new Axis[0]), config.getInt(KEY_SIZE));
        }

        @Override
        public Config serialize(MirrorTransformer transformer) {
            Config config = Config.inMemory();
            config.set(TransformerConfigSerializer.KEY_ID, (Object)transformer.getId().toString());
            TransformerConfigSerializer.setEnum(config, TransformerConfigSerializer.KEY_TYPE, transformer.getType());
            TransformerConfigSerializer.setVector3d(config, KEY_POSITION, transformer.position());
            config.set(KEY_SIZE, (Object)transformer.size());
            config.set(KEY_AXIS, (Object)transformer.axis().name().toLowerCase(Locale.ROOT));
            this.validate(config);
            return config;
        }
    }

    public static class RadialTransformerConfigSerializer
    implements ConfigSerializer<RadialTransformer> {
        private static final String KEY_POSITION = "position";
        private static final String KEY_SLICE = "slices";
        private static final String KEY_RADIUS = "radius";
        private static final String KEY_LENGTH = "length";
        public static RadialTransformerConfigSerializer INSTANCE = new RadialTransformerConfigSerializer();

        private RadialTransformerConfigSerializer() {
        }

        @Override
        public ConfigSpec getSpec(Config config) {
            ConfigSpec spec = new ConfigSpec();
            spec.define(TransformerConfigSerializer.KEY_ID, TransformerConfigSerializer::randomIdString, TransformerConfigSerializer::isIdCorrect);
            TransformerConfigSerializer.defineEnum(spec, TransformerConfigSerializer.KEY_TYPE, this.getDefault().getType());
            TransformerConfigSerializer.defineVector3d(spec, KEY_POSITION, RadialTransformer.ZERO.position());
            spec.defineInRange(KEY_SLICE, Integer.valueOf(this.getDefault().slices()), Integer.valueOf(RadialTransformer.SLICE_RANGE.min()), Integer.valueOf(RadialTransformer.SLICE_RANGE.max()));
            spec.defineInRange(KEY_RADIUS, Integer.valueOf(this.getDefault().slices()), Integer.valueOf(RadialTransformer.RADIUS_RANGE.min()), Integer.valueOf(RadialTransformer.RADIUS_RANGE.max()));
            spec.defineInRange(KEY_LENGTH, Integer.valueOf(this.getDefault().length()), Integer.valueOf(RadialTransformer.LENGTH_RANGE.min()), Integer.valueOf(RadialTransformer.LENGTH_RANGE.max()));
            return spec;
        }

        @Override
        public RadialTransformer getDefault() {
            return RadialTransformer.ZERO;
        }

        @Override
        public RadialTransformer deserialize(Config config) {
            this.validate(config);
            return new RadialTransformer(UUID.fromString((String)config.get(TransformerConfigSerializer.KEY_ID)), Text.empty(), TransformerConfigSerializer.getVector3d(config, KEY_POSITION), (Axis)TransformerConfigSerializer.getEnum((Config)config, (String)TransformerConfigSerializer.KEY_TYPE, (Enum[])new Axis[0]), (Integer)config.get(KEY_SLICE), (Integer)config.get(KEY_RADIUS), (Integer)config.get(KEY_LENGTH));
        }

        @Override
        public Config serialize(RadialTransformer transformer) {
            Config config = Config.inMemory();
            config.set(TransformerConfigSerializer.KEY_ID, (Object)transformer.getId().toString());
            TransformerConfigSerializer.setEnum(config, TransformerConfigSerializer.KEY_TYPE, transformer.getType());
            TransformerConfigSerializer.setVector3d(config, KEY_POSITION, transformer.position());
            config.set(KEY_SLICE, (Object)transformer.slices());
            config.set(KEY_RADIUS, (Object)transformer.radius());
            config.set(KEY_LENGTH, (Object)transformer.length());
            this.validate(config);
            return config;
        }
    }

    public static class ItemRandomizerConfigSerializer
    implements ConfigSerializer<ItemRandomizer> {
        private static final String KEY_ORDER = "order";
        private static final String KEY_TARGET = "target";
        private static final String KEY_CATEGORY = "category";
        private static final String KEY_SOURCE = "source";
        private static final String KEY_CHANCES = "chances";
        public static ItemRandomizerConfigSerializer INSTANCE = new ItemRandomizerConfigSerializer();

        private ItemRandomizerConfigSerializer() {
        }

        @Override
        public ConfigSpec getSpec(Config config) {
            ConfigSpec spec = new ConfigSpec();
            spec.define(TransformerConfigSerializer.KEY_ID, TransformerConfigSerializer::randomIdString, TransformerConfigSerializer::isIdCorrect);
            TransformerConfigSerializer.defineEnum(spec, TransformerConfigSerializer.KEY_TYPE, this.getDefault().getType());
            TransformerConfigSerializer.defineEnum(spec, KEY_ORDER, this.getDefault().getOrder());
            TransformerConfigSerializer.defineEnum(spec, KEY_TARGET, this.getDefault().getTarget());
            TransformerConfigSerializer.defineEnum(spec, KEY_SOURCE, this.getDefault().getSource());
            spec.defineList(KEY_CHANCES, () -> this.getDefault().getChances().stream().map(ItemChanceConfigSerializer.INSTANCE::serialize).toList(), Config.class::isInstance);
            return spec;
        }

        @Override
        public ItemRandomizer getDefault() {
            return ItemRandomizer.EMPTY;
        }

        @Override
        public ItemRandomizer deserialize(Config config) {
            this.validate(config);
            return new ItemRandomizer(UUID.fromString((String)config.get(TransformerConfigSerializer.KEY_ID)), Text.empty(), (Randomizer.Order)TransformerConfigSerializer.getEnum((Config)config, (String)KEY_ORDER, (Enum[])new Randomizer.Order[0]), (Randomizer.Target)TransformerConfigSerializer.getEnum((Config)config, (String)KEY_TARGET, (Enum[])new Randomizer.Target[0]), (ItemRandomizer.Source)TransformerConfigSerializer.getEnum((Config)config, (String)KEY_SOURCE, (Enum[])new ItemRandomizer.Source[0]), ((List)config.get(KEY_CHANCES)).stream().map(ItemChanceConfigSerializer.INSTANCE::deserialize).toList());
        }

        @Override
        public Config serialize(ItemRandomizer transformer) {
            Config config = Config.inMemory();
            config.set(TransformerConfigSerializer.KEY_ID, (Object)transformer.getId().toString());
            TransformerConfigSerializer.setEnum(config, TransformerConfigSerializer.KEY_TYPE, transformer.getType());
            TransformerConfigSerializer.setEnum(config, KEY_ORDER, transformer.getOrder());
            TransformerConfigSerializer.setEnum(config, KEY_TARGET, transformer.getTarget());
            config.set(KEY_CHANCES, transformer.getChances().stream().map(ItemChanceConfigSerializer.INSTANCE::serialize).toList());
            this.validate(config);
            return config;
        }
    }

    public static class ItemChanceConfigSerializer
    implements ConfigSerializer<Chance<Item>> {
        private static final String KEY_CONTENT = "content";
        private static final String KEY_CHANCE = "chance";
        public static ItemChanceConfigSerializer INSTANCE = new ItemChanceConfigSerializer();

        private ItemChanceConfigSerializer() {
        }

        @Override
        public ConfigSpec getSpec(Config config) {
            ConfigSpec spec = new ConfigSpec();
            spec.define(KEY_CONTENT, () -> ((Item)this.getDefault().content()).getId().getString(), TransformerConfigSerializer.predicate(value -> Item.fromId(ResourceLocation.decompose((String)value))));
            spec.defineInRange(KEY_CHANCE, Integer.valueOf(this.getDefault().chance()), Integer.valueOf(0), Integer.valueOf(127));
            return spec;
        }

        @Override
        public Chance<Item> getDefault() {
            return Chance.item(Items.AIR.item(), 0);
        }

        @Override
        public Chance<Item> deserialize(Config config) {
            this.validate(config);
            return Chance.item(Item.fromId(ResourceLocation.decompose((String)config.get(KEY_CONTENT))), config.getInt(KEY_CHANCE));
        }

        @Override
        public Config serialize(Chance<Item> itemChance) {
            Config config = Config.inMemory();
            config.set(KEY_CONTENT, (Object)itemChance.content().getId().getString());
            config.set(KEY_CHANCE, (Object)itemChance.chance());
            this.validate(config);
            return config;
        }
    }
}

