/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.operation;

import dev.huskuraft.effortless.api.core.Item;
import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.math.MathUtils;
import dev.huskuraft.effortless.api.tag.RecordTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ItemStackUtils {
    private ItemStackUtils() {
    }

    public static List<ItemStack> flattenStack(List<ItemStack> stacks) {
        record Pair<A, B>(A first, B second) {
        }
        HashMap<Pair<Item, RecordTag>, ItemStack> map = new HashMap<Pair<Item, RecordTag>, ItemStack>();
        for (ItemStack stack : stacks) {
            Item item = stack.getItem();
            Pair<Item, RecordTag> key = new Pair<Item, RecordTag>(item, RecordTag.newRecord());
            if (map.containsKey(key)) {
                ((ItemStack)map.get(key)).increase(stack.getCount());
                continue;
            }
            map.put(key, stack.copy());
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack stack : map.values()) {
            int maxStackSize = Math.max(64, stack.getMaxStackSize());
            for (int count = stack.getCount(); count > 0; count -= maxStackSize) {
                ItemStack newStack = stack.copy();
                newStack.setCount(MathUtils.min(count, maxStackSize));
                result.add(newStack);
            }
        }
        return result;
    }
}

