/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.structure.builder.standard;

import com.google.common.collect.Sets;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.math.MathUtils;
import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.structure.BuildFeature;
import dev.huskuraft.effortless.building.structure.BuildFeatures;
import dev.huskuraft.effortless.building.structure.BuildMode;
import dev.huskuraft.effortless.building.structure.PlaneLength;
import dev.huskuraft.effortless.building.structure.builder.BlockStructure;
import dev.huskuraft.effortless.building.structure.builder.Structure;
import dev.huskuraft.effortless.building.structure.builder.standard.DiagonalLine;
import dev.huskuraft.effortless.building.structure.builder.standard.Floor;
import dev.huskuraft.effortless.building.structure.builder.standard.Line;
import dev.huskuraft.effortless.building.structure.builder.standard.Single;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Stream;

public record DiagonalWall(PlaneLength planeLength) implements BlockStructure
{
    public DiagonalWall() {
        this(PlaneLength.VARIABLE);
    }

    @Override
    public Structure withFeature(BuildFeature feature) {
        return switch (feature.getType()) {
            case BuildFeatures.PLANE_LENGTH -> new DiagonalWall((PlaneLength)feature);
            default -> this;
        };
    }

    public static Stream<BlockPosition> collectDiagonalWallBlocks(Context context) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        BlockPosition pos1 = context.getPosition(0);
        BlockPosition pos2 = context.getPosition(1);
        BlockPosition pos3 = context.getPosition(2);
        int x1 = pos1.x();
        int y1 = pos1.y();
        int z1 = pos1.z();
        int x2 = pos2.x();
        int y2 = pos2.y();
        int z2 = pos2.z();
        int x3 = pos3.x();
        int y3 = pos3.y();
        int z3 = pos3.z();
        List<BlockPosition> diagonalLineBlocks = DiagonalLine.collectDiagonalLine(context).toList();
        int lowest = MathUtils.min(y1, y3);
        int highest = MathUtils.max(y1, y3);
        for (int y = lowest; y <= highest; ++y) {
            for (BlockPosition blockPosition : diagonalLineBlocks) {
                set.add(new BlockPosition(blockPosition.x(), y, blockPosition.z()));
            }
        }
        return set.stream();
    }

    @Override
    public BlockInteraction trace(Player player, Context context, int index) {
        return switch (index) {
            case 0 -> Single.traceSingle(player, context);
            case 1 -> Floor.traceFloor(player, context, this.planeLength);
            case 2 -> Line.traceLineY(player, context.getPosition(1));
            default -> null;
        };
    }

    @Override
    public Stream<BlockPosition> collect(Context context, int index) {
        return switch (index) {
            case 1 -> Single.collectSingleBlocks(context);
            case 2 -> DiagonalLine.collectDiagonalLine(context);
            case 3 -> DiagonalWall.collectDiagonalWallBlocks(context);
            default -> Stream.empty();
        };
    }

    @Override
    public int traceSize(Context context) {
        return 3;
    }

    @Override
    public BuildMode getMode() {
        return BuildMode.DIAGONAL_WALL;
    }
}

