/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.structure.builder.standard;

import com.google.common.collect.Sets;
import dev.huskuraft.effortless.api.core.Axis;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.structure.BuildFeature;
import dev.huskuraft.effortless.building.structure.BuildFeatures;
import dev.huskuraft.effortless.building.structure.BuildMode;
import dev.huskuraft.effortless.building.structure.PlaneFilling;
import dev.huskuraft.effortless.building.structure.PlaneLength;
import dev.huskuraft.effortless.building.structure.builder.BlockStructure;
import dev.huskuraft.effortless.building.structure.builder.Structure;
import dev.huskuraft.effortless.building.structure.builder.standard.Line;
import dev.huskuraft.effortless.building.structure.builder.standard.Single;
import dev.huskuraft.effortless.building.structure.builder.standard.Square;
import java.util.LinkedHashSet;
import java.util.stream.Stream;

public record Floor(PlaneFilling planeFilling, PlaneLength planeLength) implements BlockStructure
{
    public Floor() {
        this(PlaneFilling.FILLED, PlaneLength.VARIABLE);
    }

    @Override
    public Structure withFeature(BuildFeature feature) {
        return switch (feature.getType()) {
            case BuildFeatures.PLANE_FILLING -> new Floor((PlaneFilling)feature, this.planeLength);
            case BuildFeatures.PLANE_LENGTH -> new Floor(this.planeFilling, (PlaneLength)feature);
            default -> this;
        };
    }

    protected static BlockInteraction traceFloor(Player player, Context context, PlaneLength planeLength) {
        return Floor.traceFloor(player, context.getInteraction(0), planeLength == PlaneLength.EQUAL);
    }

    protected static BlockInteraction traceFloor(Player player, BlockInteraction start, boolean uniformLength) {
        Vector3d center = start.getBlockPosition().getCenter();
        int reach = 1024;
        boolean skipRaytrace = false;
        BlockInteraction result = Stream.of(new BlockStructure.NearestLineCriteria(Axis.Y, player, center, reach, skipRaytrace)).filter(BlockStructure.AxisCriteria::isInRange).findAny().map(BlockStructure.AxisCriteria::tracePlane).orElse(null);
        return BlockStructure.transformUniformLengthInteraction(start, result, uniformLength);
    }

    public static Stream<BlockPosition> collectFloorBlocks(Context context, PlaneFilling planeFilling) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        BlockPosition pos1 = context.getPosition(0);
        BlockPosition pos2 = context.getPosition(1);
        int x1 = pos1.x();
        int y1 = pos1.y();
        int z1 = pos1.z();
        int x2 = pos2.x();
        int y2 = pos2.y();
        int z2 = pos2.z();
        block0 : switch (BlockStructure.getShape(pos1, pos2)) {
            case SINGLE: {
                Single.addSingleBlock(set, x1, y1, z1);
                break;
            }
            case LINE_X: 
            case LINE_Y: 
            case LINE_Z: {
                Line.addLineBlocks(set, x1, y1, z1, x2, y2, z2);
                break;
            }
            case PLANE_Y: {
                switch (planeFilling) {
                    case FILLED: {
                        Square.addFullSquareBlocksY(set, x1, x2, y1, z1, z2);
                        break block0;
                    }
                    case HOLLOW: {
                        Square.addHollowSquareBlocksY(set, x1, x2, y1, z1, z2);
                    }
                }
            }
        }
        return set.stream();
    }

    @Override
    public BlockInteraction trace(Player player, Context context, int index) {
        return switch (index) {
            case 0 -> Single.traceSingle(player, context);
            case 1 -> Floor.traceFloor(player, context, this.planeLength);
            default -> null;
        };
    }

    @Override
    public Stream<BlockPosition> collect(Context context, int index) {
        return switch (index) {
            case 1 -> Single.collectSingleBlocks(context);
            case 2 -> Floor.collectFloorBlocks(context, this.planeFilling);
            default -> Stream.empty();
        };
    }

    @Override
    public int traceSize(Context context) {
        return 2;
    }

    @Override
    public BuildMode getMode() {
        return BuildMode.FLOOR;
    }
}

