/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.structure.builder.standard;

import com.google.common.collect.Sets;
import dev.huskuraft.effortless.api.core.Axis;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.structure.BuildFeature;
import dev.huskuraft.effortless.building.structure.BuildFeatures;
import dev.huskuraft.effortless.building.structure.BuildMode;
import dev.huskuraft.effortless.building.structure.PlaneFacing;
import dev.huskuraft.effortless.building.structure.PlaneFilling;
import dev.huskuraft.effortless.building.structure.PlaneLength;
import dev.huskuraft.effortless.building.structure.builder.BlockStructure;
import dev.huskuraft.effortless.building.structure.builder.Structure;
import dev.huskuraft.effortless.building.structure.builder.standard.Line;
import dev.huskuraft.effortless.building.structure.builder.standard.Single;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;

public record Square(PlaneFacing planeFacing, PlaneFilling planeFilling, PlaneLength planeLength) implements BlockStructure
{
    public Square() {
        this(PlaneFacing.BOTH, PlaneFilling.FILLED, PlaneLength.VARIABLE);
    }

    @Override
    public Structure withFeature(BuildFeature feature) {
        return switch (feature.getType()) {
            case BuildFeatures.PLANE_FACING -> new Square((PlaneFacing)feature, this.planeFilling, this.planeLength);
            case BuildFeatures.PLANE_FILLING -> new Square(this.planeFacing, (PlaneFilling)feature, this.planeLength);
            case BuildFeatures.PLANE_LENGTH -> new Square(this.planeFacing, this.planeFilling, (PlaneLength)feature);
            default -> this;
        };
    }

    public static void addFullSquareBlocksX(Set<BlockPosition> set, int x, int y1, int y2, int z1, int z2) {
        int z = z1;
        while (z1 < z2 ? z <= z2 : z >= z2) {
            int y = y1;
            while (y1 < y2 ? y <= y2 : y >= y2) {
                set.add(new BlockPosition(x, y, z));
                y += y1 < y2 ? 1 : -1;
            }
            z += z1 < z2 ? 1 : -1;
        }
    }

    public static void addFullSquareBlocksY(Set<BlockPosition> set, int x1, int x2, int y, int z1, int z2) {
        int x = x1;
        while (x1 < x2 ? x <= x2 : x >= x2) {
            int z = z1;
            while (z1 < z2 ? z <= z2 : z >= z2) {
                set.add(new BlockPosition(x, y, z));
                z += z1 < z2 ? 1 : -1;
            }
            x += x1 < x2 ? 1 : -1;
        }
    }

    public static void addFullSquareBlocksZ(Set<BlockPosition> set, int x1, int x2, int y1, int y2, int z) {
        int x = x1;
        while (x1 < x2 ? x <= x2 : x >= x2) {
            int y = y1;
            while (y1 < y2 ? y <= y2 : y >= y2) {
                set.add(new BlockPosition(x, y, z));
                y += y1 < y2 ? 1 : -1;
            }
            x += x1 < x2 ? 1 : -1;
        }
    }

    public static void addHollowSquareBlocksX(Set<BlockPosition> set, int x, int y1, int y2, int z1, int z2) {
        Line.addZLineBlocks(set, z1, z2, x, y1);
        Line.addZLineBlocks(set, z1, z2, x, y2);
        Line.addYLineBlocks(set, y1, y2, x, z1);
        Line.addYLineBlocks(set, y1, y2, x, z2);
    }

    public static void addHollowSquareBlocksY(Set<BlockPosition> set, int x1, int x2, int y, int z1, int z2) {
        Line.addXLineBlocks(set, x1, x2, y, z1);
        Line.addXLineBlocks(set, x1, x2, y, z2);
        Line.addZLineBlocks(set, z1, z2, x1, y);
        Line.addZLineBlocks(set, z1, z2, x2, y);
    }

    public static void addHollowSquareBlocksZ(Set<BlockPosition> set, int x1, int x2, int y1, int y2, int z) {
        Line.addXLineBlocks(set, x1, x2, y1, z);
        Line.addXLineBlocks(set, x1, x2, y2, z);
        Line.addYLineBlocks(set, y1, y2, x1, z);
        Line.addYLineBlocks(set, y1, y2, x2, z);
    }

    public static void addFullSquareBlocks(Set<BlockPosition> set, int x1, int x2, int y1, int y2, int z1, int z2) {
        if (y1 == y2) {
            Square.addFullSquareBlocksY(set, x1, x2, y1, z1, z2);
        } else if (x1 == x2) {
            Square.addFullSquareBlocksX(set, x1, y1, y2, z1, z2);
        } else if (z1 == z2) {
            Square.addFullSquareBlocksZ(set, x1, x2, y1, y2, z1);
        }
    }

    public static void addHollowSquareBlocks(Set<BlockPosition> set, int x1, int x2, int y1, int y2, int z1, int z2) {
        if (y1 == y2) {
            Square.addHollowSquareBlocksY(set, x1, x2, y1, z1, z2);
        } else if (x1 == x2) {
            Square.addHollowSquareBlocksX(set, x1, y1, y2, z1, z2);
        } else if (z1 == z2) {
            Square.addHollowSquareBlocksZ(set, x1, x2, y1, y2, z1);
        }
    }

    public static Stream<BlockPosition> collectSquareBlocks(Context context, PlaneFilling planeFilling) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        BlockPosition pos1 = context.getPosition(0);
        BlockPosition pos2 = context.getPosition(1);
        int x1 = pos1.x();
        int y1 = pos1.y();
        int z1 = pos1.z();
        int x2 = pos2.x();
        int y2 = pos2.y();
        int z2 = pos2.z();
        block0 : switch (BlockStructure.getShape(pos1, pos2)) {
            case SINGLE: {
                Single.addSingleBlock(set, x1, y1, z1);
                break;
            }
            case LINE_X: 
            case LINE_Y: 
            case LINE_Z: {
                Line.addLineBlocks(set, x1, y1, z1, x2, y2, z2);
                break;
            }
            case PLANE_X: {
                switch (planeFilling) {
                    case FILLED: {
                        Square.addFullSquareBlocksX(set, x1, y1, y2, z1, z2);
                        break;
                    }
                    case HOLLOW: {
                        Square.addHollowSquareBlocksX(set, x1, y1, y2, z1, z2);
                    }
                }
                break;
            }
            case PLANE_Y: {
                switch (planeFilling) {
                    case FILLED: {
                        Square.addFullSquareBlocksY(set, x1, x2, y1, z1, z2);
                        break;
                    }
                    case HOLLOW: {
                        Square.addHollowSquareBlocksY(set, x1, x2, y1, z1, z2);
                    }
                }
                break;
            }
            case PLANE_Z: {
                switch (planeFilling) {
                    case FILLED: {
                        Square.addFullSquareBlocksZ(set, x1, x2, y1, y2, z1);
                        break block0;
                    }
                    case HOLLOW: {
                        Square.addHollowSquareBlocksZ(set, x1, x2, y1, y2, z1);
                    }
                }
            }
        }
        return set.stream();
    }

    protected static BlockInteraction traceSquare(Player player, Context context, PlaneFacing planeFacing, PlaneLength planeLength) {
        return Square.traceSquare(player, context.getInteraction(0), planeFacing.getAxes(), planeLength == PlaneLength.EQUAL);
    }

    protected static BlockInteraction traceSquare(Player player, BlockInteraction start, Set<Axis> axes, boolean uniformLength) {
        Vector3d center = start.getBlockPosition().getCenter();
        int reach = 1024;
        boolean skipRaytrace = false;
        BlockInteraction result = Stream.of(new BlockStructure.NearestLineCriteria(Axis.X, player, center, reach, skipRaytrace), new BlockStructure.NearestLineCriteria(Axis.Y, player, center, reach, skipRaytrace), new BlockStructure.NearestLineCriteria(Axis.Z, player, center, reach, skipRaytrace)).filter(nearestLineCriteria -> axes.contains((Object)nearestLineCriteria.getAxis())).filter(BlockStructure.AxisCriteria::isInRange).min(Comparator.comparing(BlockStructure.AxisCriteria::distanceToEyeSqr)).map(BlockStructure.AxisCriteria::tracePlane).orElse(null);
        return BlockStructure.transformUniformLengthInteraction(start, result, uniformLength);
    }

    @Override
    public BlockInteraction trace(Player player, Context context, int index) {
        return switch (index) {
            case 0 -> Single.traceSingle(player, context);
            case 1 -> Square.traceSquare(player, context, this.planeFacing, this.planeLength);
            default -> null;
        };
    }

    @Override
    public Stream<BlockPosition> collect(Context context, int index) {
        return switch (index) {
            case 1 -> Single.collectSingleBlocks(context);
            case 2 -> Square.collectSquareBlocks(context, this.planeFilling);
            default -> Stream.empty();
        };
    }

    @Override
    public int traceSize(Context context) {
        return 2;
    }

    @Override
    public BuildMode getMode() {
        return null;
    }
}

