/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.forge.core;

import dev.huskuraft.effortless.api.core.Axis;
import dev.huskuraft.effortless.api.core.Block;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockState;
import dev.huskuraft.effortless.api.core.InteractionResult;
import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.core.PropertyValue;
import dev.huskuraft.effortless.api.core.Revolve;
import dev.huskuraft.effortless.api.core.fluid.Fluid;
import dev.huskuraft.effortless.api.sound.SoundSet;
import dev.huskuraft.effortless.forge.core.MinecraftBlock;
import dev.huskuraft.effortless.forge.core.MinecraftConvertor;
import dev.huskuraft.effortless.forge.core.MinecraftProperty;
import dev.huskuraft.effortless.forge.core.MinecraftPropertyValue;
import dev.huskuraft.effortless.forge.sound.MinecraftSoundSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public final class MinecraftBlockState
extends Record
implements BlockState {
    private final net.minecraft.world.level.block.state.BlockState refs;

    public MinecraftBlockState(net.minecraft.world.level.block.state.BlockState refs) {
        this.refs = refs;
    }

    public static BlockState ofNullable(net.minecraft.world.level.block.state.BlockState refs) {
        if (refs == null) {
            return null;
        }
        return new MinecraftBlockState(refs);
    }

    public static net.minecraft.world.level.block.state.BlockState mirrorTopBottom(net.minecraft.world.level.block.state.BlockState value) {
        if (value.m_60734_() instanceof StairBlock) {
            return switch ((Half)value.m_61143_((Property)StairBlock.f_56842_)) {
                default -> throw new IncompatibleClassChangeError();
                case Half.TOP -> (net.minecraft.world.level.block.state.BlockState)value.m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.BOTTOM);
                case Half.BOTTOM -> (net.minecraft.world.level.block.state.BlockState)value.m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP);
            };
        }
        if (value.m_60734_() instanceof SlabBlock) {
            return switch ((SlabType)value.m_61143_((Property)SlabBlock.f_56353_)) {
                default -> throw new IncompatibleClassChangeError();
                case SlabType.TOP -> (net.minecraft.world.level.block.state.BlockState)value.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM);
                case SlabType.BOTTOM -> (net.minecraft.world.level.block.state.BlockState)value.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP);
                case SlabType.DOUBLE -> value;
            };
        }
        if (value.m_60734_() instanceof DirectionalBlock) {
            switch ((Direction)value.m_61143_((Property)DirectionalBlock.f_52588_)) {
                case DOWN: {
                    return (net.minecraft.world.level.block.state.BlockState)value.m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)Direction.UP);
                }
                case UP: {
                    return (net.minecraft.world.level.block.state.BlockState)value.m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)Direction.DOWN);
                }
            }
        }
        if (value.m_60734_() instanceof DispenserBlock) {
            switch ((Direction)value.m_61143_((Property)DispenserBlock.f_52659_)) {
                case DOWN: {
                    return (net.minecraft.world.level.block.state.BlockState)value.m_61124_((Property)DispenserBlock.f_52659_, (Comparable)Direction.UP);
                }
                case UP: {
                    return (net.minecraft.world.level.block.state.BlockState)value.m_61124_((Property)DispenserBlock.f_52659_, (Comparable)Direction.DOWN);
                }
            }
        }
        return value;
    }

    public static net.minecraft.world.level.block.state.BlockState mirrorLeftRight(net.minecraft.world.level.block.state.BlockState value) {
        return value.m_60715_(Mirror.LEFT_RIGHT);
    }

    public static net.minecraft.world.level.block.state.BlockState mirrorFrontBack(net.minecraft.world.level.block.state.BlockState value) {
        return value.m_60715_(Mirror.FRONT_BACK);
    }

    @Override
    public BlockState rotate(Revolve revolve) {
        return MinecraftBlockState.ofNullable(this.refs.m_60717_(switch (revolve) {
            default -> throw new IncompatibleClassChangeError();
            case Revolve.NONE -> Rotation.NONE;
            case Revolve.CLOCKWISE_90 -> Rotation.CLOCKWISE_90;
            case Revolve.CLOCKWISE_180 -> Rotation.CLOCKWISE_180;
            case Revolve.COUNTERCLOCKWISE_90 -> Rotation.COUNTERCLOCKWISE_90;
        }));
    }

    @Override
    public boolean isAir() {
        return this.refs.m_60795_();
    }

    @Override
    public BlockState mirror(Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.Y -> MinecraftBlockState.ofNullable(MinecraftBlockState.mirrorTopBottom(this.refs));
            case Axis.X -> MinecraftBlockState.ofNullable(MinecraftBlockState.mirrorFrontBack(this.refs));
            case Axis.Z -> MinecraftBlockState.ofNullable(MinecraftBlockState.mirrorLeftRight(this.refs));
        };
    }

    @Override
    public boolean canBeReplaced(dev.huskuraft.effortless.api.core.Player player, BlockInteraction interaction) {
        ItemStack itemStack = player.getItemStack(interaction.getHand());
        return this.refs.m_60629_(new BlockPlaceContext((Player)player.reference(), MinecraftConvertor.toPlatformInteractionHand(interaction.getHand()), (net.minecraft.world.item.ItemStack)itemStack.reference(), MinecraftConvertor.toPlatformBlockInteraction(interaction)));
    }

    @Override
    public boolean isReplaceable() {
        return this.refs.m_247087_();
    }

    @Override
    public boolean hasTagFeatureCannotReplace() {
        return this.refs.m_204336_(BlockTags.f_144287_);
    }

    @Override
    public SoundSet getSoundSet() {
        return new MinecraftSoundSet(this.refs.m_60827_());
    }

    @Override
    public Map<dev.huskuraft.effortless.api.core.Property, PropertyValue> getPropertiesMap() {
        return this.refs.m_61148_().entrySet().stream().collect(Collectors.toMap(entry -> new MinecraftProperty((Property)entry.getKey()), entry -> new MinecraftPropertyValue((Comparable)entry.getValue())));
    }

    @Override
    public Block getBlock() {
        return new MinecraftBlock(this.refs.m_60734_());
    }

    @Override
    public boolean canBeReplaced(Fluid fluid) {
        return this.refs.m_60722_((net.minecraft.world.level.material.Fluid)fluid.reference());
    }

    @Override
    public InteractionResult use(dev.huskuraft.effortless.api.core.Player player, BlockInteraction blockInteraction) {
        return MinecraftConvertor.fromPlatformInteractionResult(this.refs.m_60664_((Level)player.getWorld().reference(), (Player)player.reference(), MinecraftConvertor.toPlatformInteractionHand(blockInteraction.getHand()), MinecraftConvertor.toPlatformBlockInteraction(blockInteraction)));
    }

    @Override
    public boolean requiresCorrectToolForDrops() {
        return this.refs.m_60834_();
    }

    @Override
    public int getRequiredItemCount() {
        if (this.refs.m_60734_() instanceof SlabBlock && this.refs.m_61143_((Property)SlabBlock.f_56353_) == SlabType.DOUBLE) {
            return 2;
        }
        return 1;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{MinecraftBlockState.class, "refs", "refs"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MinecraftBlockState.class, "refs", "refs"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MinecraftBlockState.class, "refs", "refs"}, this, o);
    }

    public net.minecraft.world.level.block.state.BlockState refs() {
        return this.refs;
    }
}

