/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.forge.networking;

import com.google.auto.service.AutoService;
import dev.huskuraft.effortless.api.core.ResourceLocation;
import dev.huskuraft.effortless.api.networking.ByteBufReceiver;
import dev.huskuraft.effortless.api.networking.ByteBufSender;
import dev.huskuraft.effortless.api.networking.Networking;
import dev.huskuraft.effortless.api.networking.Side;
import dev.huskuraft.effortless.forge.core.MinecraftPlayer;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.event.EventNetworkChannel;
import org.apache.commons.lang3.tuple.Pair;

@AutoService(value={Networking.class})
public class ForgeNetworking
implements Networking {
    private static final Map<ResourceLocation, EventNetworkChannel> MAP = new HashMap<ResourceLocation, EventNetworkChannel>();

    private static void register(ResourceLocation channelId, Consumer<NetworkEvent> eventConsumer) {
        MAP.computeIfAbsent(channelId, id -> NetworkRegistry.ChannelBuilder.named((net.minecraft.resources.ResourceLocation)((net.minecraft.resources.ResourceLocation)channelId.reference())).networkProtocolVersion(() -> "0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).eventNetworkChannel()).addListener(eventConsumer);
    }

    public static ByteBufSender register(ResourceLocation channelId, Side side, ByteBufReceiver receiver) {
        switch (side) {
            case CLIENT: {
                ForgeNetworking.register(channelId, event -> {
                    if (event.getPayload() != null && ((NetworkEvent.Context)event.getSource().get()).getDirection().equals((Object)NetworkDirection.PLAY_TO_CLIENT)) {
                        receiver.receiveBuffer((ByteBuf)event.getPayload(), MinecraftPlayer.ofNullable((Player)((NetworkEvent.Context)event.getSource().get()).getSender()));
                        ((NetworkEvent.Context)event.getSource().get()).setPacketHandled(true);
                    }
                });
                break;
            }
            case SERVER: {
                ForgeNetworking.register(channelId, event -> {
                    if (event.getPayload() != null && ((NetworkEvent.Context)event.getSource().get()).getDirection().equals((Object)NetworkDirection.PLAY_TO_SERVER)) {
                        receiver.receiveBuffer((ByteBuf)event.getPayload(), MinecraftPlayer.ofNullable((Player)((NetworkEvent.Context)event.getSource().get()).getSender()));
                        ((NetworkEvent.Context)event.getSource().get()).setPacketHandled(true);
                    }
                });
            }
        }
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Side.CLIENT -> (byteBuf, player) -> PacketDistributor.SERVER.noArg().send(NetworkDirection.PLAY_TO_SERVER.buildPacket(Pair.of((Object)new FriendlyByteBuf(byteBuf), (Object)0), (net.minecraft.resources.ResourceLocation)channelId.reference()).getThis());
            case Side.SERVER -> (byteBuf, player) -> PacketDistributor.PLAYER.with(player::reference).send(NetworkDirection.PLAY_TO_CLIENT.buildPacket(Pair.of((Object)new FriendlyByteBuf(byteBuf), (Object)0), (net.minecraft.resources.ResourceLocation)channelId.reference()).getThis());
        };
    }
}

