/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.clipboard;

import dev.huskuraft.effortless.EffortlessClient;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.gui.AbstractPanelScreen;
import dev.huskuraft.effortless.api.gui.AbstractWidget;
import dev.huskuraft.effortless.api.gui.button.Button;
import dev.huskuraft.effortless.api.gui.container.EditableEntryList;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.clipboard.Snapshot;
import dev.huskuraft.effortless.building.config.ClientConfig;
import dev.huskuraft.effortless.screen.clipboard.StructureSnapshotList;
import java.util.List;
import java.util.function.Consumer;

public class EffortlessStructureSnapshotsHistoryScreen
extends AbstractPanelScreen {
    private final Consumer<Snapshot> consumer;
    private List<Snapshot> history;
    private AbstractWidget titleTextWidget;
    private StructureSnapshotList entries;
    private Button cancelButton;
    private Button selectButton;
    private Button editButton;
    private Button shareButton;
    private Button deleteButton;
    private Button exportButton;
    private Button favButton;
    private Button addToLibraryButton;

    public EffortlessStructureSnapshotsHistoryScreen(Entrance entrance, Consumer<Snapshot> consumer) {
        super(entrance, Text.translate("effortless.structure_snapshots_history.title"), 264, 238);
        this.consumer = consumer;
        this.history = ((ClientConfig)this.getEntrance().getConfigStorage().get()).clipboardConfig().history();
    }

    @Override
    protected EffortlessClient getEntrance() {
        return (EffortlessClient)super.getEntrance();
    }

    protected Player getPlayer() {
        return this.getEntrance().getClient().getPlayer();
    }

    @Override
    public void onCreate() {
        this.titleTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getLeft() + this.getWidth() / 2, this.getTop() + 18 - 10, this.getScreenTitle().withColor(0x404040), TextWidget.Gravity.CENTER));
        this.entries = this.addWidget(new StructureSnapshotList(this.getEntrance(), this.getLeft() + 6, this.getTop() + 18, this.getWidth() - 12 - 8, this.getHeight() - 18 - 30));
        this.entries.setAlwaysShowScrollbar(true);
        this.entries.reset(this.history);
        this.cancelButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.done"), button -> this.detach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.0f, 0.5f).build());
        this.selectButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.use_in_clipboard"), button -> {
            if (this.entries.hasSelected()) {
                this.consumer.accept((Snapshot)((EditableEntryList.Entry)this.entries.getSelected()).getItem());
            }
            this.detach();
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.5f, 0.5f).build());
    }

    @Override
    public void onReload() {
        this.selectButton.setActive(this.entries.hasSelected());
        if (this.entries.consumeDoubleClick() && this.entries.hasSelected()) {
            this.consumer.accept((Snapshot)((EditableEntryList.Entry)this.entries.getSelected()).getItem());
            this.detach();
        }
    }
}

