/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.clipboard;

import dev.huskuraft.effortless.api.gui.AbstractWidget;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.api.math.Vector3f;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.renderer.Renderer;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.clipboard.BlockData;
import dev.huskuraft.effortless.building.clipboard.Snapshot;
import dev.huskuraft.effortless.renderer.opertaion.BlockRenderLayers;
import java.awt.Color;

public final class StructureSnapshotWidget
extends AbstractWidget {
    private Snapshot snapshot;
    private int backgroundColor = -603979776;

    public StructureSnapshotWidget(Entrance entrance, int x, int y, int width, int height, Snapshot snapshot) {
        super(entrance, x, y, width, height, Text.empty());
        this.snapshot = snapshot;
    }

    @Override
    public void onCreate() {
    }

    @Override
    public void renderWidget(Renderer renderer, int mouseX, int mouseY, float deltaTick) {
        renderer.pushPose();
        renderer.translate((float)this.getX() + (float)this.getWidth() / 2.0f, (float)this.getY() + (float)this.getHeight() / 2.0f, 100.0f);
        Vector3d center = this.snapshot.getCenter();
        double maxY = this.snapshot.blockData().stream().mapToDouble(blockData -> (blockData.blockPosition().getCenter().sub(center).x() - blockData.blockPosition().getCenter().sub(center).z()) * Math.sin(0.7853981633974483) * 0.8 + blockData.blockPosition().getCenter().sub(center).y()).max().orElse(0.0) + 1.5;
        double minY = this.snapshot.blockData().stream().mapToDouble(blockData -> (blockData.blockPosition().getCenter().sub(center).x() - blockData.blockPosition().getCenter().sub(center).z()) * Math.sin(0.7853981633974483) * 0.8 + blockData.blockPosition().getCenter().sub(center).y()).min().orElse(0.0) - 1.5;
        double maxX = this.snapshot.blockData().stream().mapToDouble(blockData -> (blockData.blockPosition().getCenter().sub(center).x() - blockData.blockPosition().getCenter().sub(center).z()) * 0.8).max().orElse(0.0) + 1.5;
        double minX = this.snapshot.blockData().stream().mapToDouble(blockData -> (blockData.blockPosition().getCenter().sub(center).x() - blockData.blockPosition().getCenter().sub(center).z()) * 0.8).min().orElse(0.0) - 1.5;
        renderer.scale(-Math.min((double)this.getWidth() / (maxX - minX), (double)this.getHeight() / Math.max(maxY - minY, 8.0) * 1.1));
        renderer.rotate(Vector3f.XP.rotationDegrees(-30.0f));
        renderer.rotate(Vector3f.YP.rotationDegrees(45.0f));
        renderer.pushPose();
        renderer.translate(-this.snapshot.getCenter().x(), -this.snapshot.getCenter().y(), -this.snapshot.getCenter().z());
        for (BlockData blockData2 : this.snapshot.blockData()) {
            if (blockData2.blockState() != null) {
                renderer.pushPose();
                renderer.translate(blockData2.blockPosition().x(), blockData2.blockPosition().y(), blockData2.blockPosition().z());
                renderer.renderBlockState(BlockRenderLayers.block(Color.WHITE.getRGB()), this.getEntrance().getClient().getWorld(), blockData2.blockPosition().add(this.getEntrance().getClient().getPlayer().getPosition().toVector3i()), blockData2.blockState());
                renderer.popPose();
            }
            if (blockData2.blockEntity() == null) continue;
            renderer.pushPose();
            renderer.translate(blockData2.blockPosition().x(), blockData2.blockPosition().y(), blockData2.blockPosition().z());
            renderer.renderBlockEntity(BlockRenderLayers.block(Color.WHITE.getRGB()), this.getEntrance().getClient().getWorld(), blockData2.blockPosition().add(this.getEntrance().getClient().getPlayer().getPosition().toVector3i()), blockData2.blockEntity());
            renderer.popPose();
        }
        renderer.popPose();
        renderer.popPose();
    }

    @Override
    public void renderWidgetBackground(Renderer renderer, int mouseX, int mouseY, float deltaTick) {
        renderer.renderGradientRect(this.getLeft(), this.getTop(), this.getRight(), this.getBottom(), this.backgroundColor, this.backgroundColor);
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setSnapshot(Snapshot snapshot) {
        this.snapshot = snapshot;
    }
}

