/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.general;

import dev.huskuraft.effortless.EffortlessClient;
import dev.huskuraft.effortless.api.core.Item;
import dev.huskuraft.effortless.api.core.ResourceLocation;
import dev.huskuraft.effortless.api.gui.AbstractPanelScreen;
import dev.huskuraft.effortless.api.gui.AbstractWidget;
import dev.huskuraft.effortless.api.gui.button.Button;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.screen.general.EffortlessPlayerGeneralSettingsListScreen;
import dev.huskuraft.effortless.screen.item.EffortlessItemsScreen;
import dev.huskuraft.effortless.screen.settings.SettingOptionsList;
import dev.huskuraft.effortless.session.config.ConstraintConfig;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;

public class EffortlessGlobalGeneralSettingsScreen
extends AbstractPanelScreen {
    private final Consumer<ConstraintConfig> consumer;
    private ConstraintConfig defaultConfig = ConstraintConfig.DEFAULT;
    private ConstraintConfig originalConfig;
    private ConstraintConfig config;
    private AbstractWidget playerButton;
    private AbstractWidget cancelButton;
    private AbstractWidget resetButton;
    private AbstractWidget saveButton;

    public EffortlessGlobalGeneralSettingsScreen(Entrance entrance, ConstraintConfig config, Consumer<ConstraintConfig> consumer) {
        super(entrance, Text.translate("effortless.global_general_settings.title"), 264, 238);
        this.originalConfig = config;
        this.config = config;
        this.consumer = consumer;
    }

    @Override
    public void onCreate() {
        this.addWidget(new TextWidget(this.getEntrance(), this.getLeft() + this.getWidth() / 2, this.getTop() + 18 - 10, this.getScreenTitle().withColor(0x404040), TextWidget.Gravity.CENTER));
        SettingOptionsList entries = this.addWidget(new SettingOptionsList(this.getEntrance(), this.getLeft() + 6, this.getTop() + 18, this.getWidth() - 12 - 8, this.getHeight() - 18 - 54, false, false));
        entries.setAlwaysShowScrollbar(true);
        entries.addSwitchEntry(Text.translate("effortless.general_settings.allow_use_mod"), null, this.config.allowUseMod(), value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), (Boolean)value, this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), this.config.maxReachDistance(), this.config.maxBlockBreakVolume(), this.config.maxBlockPlaceVolume(), this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), this.config.blacklistedItems());
        });
        entries.addSwitchEntry(Text.translate("effortless.general_settings.allow_break_blocks"), null, this.config.allowBreakBlocks(), value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), (Boolean)value, this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), this.config.maxReachDistance(), this.config.maxBlockBreakVolume(), this.config.maxBlockPlaceVolume(), this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), this.config.blacklistedItems());
        });
        entries.addSwitchEntry(Text.translate("effortless.general_settings.allow_place_blocks"), null, this.config.allowPlaceBlocks(), value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), (Boolean)value, this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), this.config.maxReachDistance(), this.config.maxBlockBreakVolume(), this.config.maxBlockPlaceVolume(), this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), this.config.blacklistedItems());
        });
        entries.addSwitchEntry(Text.translate("effortless.general_settings.allow_interact_blocks"), null, this.config.allowInteractBlocks(), value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), (Boolean)value, this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), this.config.maxReachDistance(), this.config.maxBlockBreakVolume(), this.config.maxBlockPlaceVolume(), this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), this.config.blacklistedItems());
        });
        entries.addSwitchEntry(Text.translate("effortless.general_settings.allow_copy_paste_structures"), null, this.config.allowCopyPasteStructures(), value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), (Boolean)value, this.config.useProperToolsOnly(), this.config.maxReachDistance(), this.config.maxBlockBreakVolume(), this.config.maxBlockPlaceVolume(), this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), this.config.blacklistedItems());
        });
        entries.addSwitchEntry(Text.translate("effortless.general_settings.use_proper_tools"), null, this.config.useProperToolsOnly(), value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), (Boolean)value, this.config.maxReachDistance(), this.config.maxBlockBreakVolume(), this.config.maxBlockPlaceVolume(), this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), this.config.blacklistedItems());
        });
        entries.addIntegerEntry(Text.translate("effortless.general_settings.max_reach_distance"), null, this.config.maxReachDistance(), 0, Short.MAX_VALUE, 8, value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), (Integer)value, this.config.maxBlockBreakVolume(), this.config.maxBlockPlaceVolume(), this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), this.config.blacklistedItems());
        });
        entries.addIntegerEntry(Text.translate("effortless.general_settings.max_block_break_volume"), null, this.config.maxBlockBreakVolume(), 0, 1000000, 100, value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), this.config.maxReachDistance(), (Integer)value, this.config.maxBlockPlaceVolume(), this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), this.config.blacklistedItems());
        });
        entries.addIntegerEntry(Text.translate("effortless.general_settings.max_block_place_volume"), null, this.config.maxBlockPlaceVolume(), 0, 1000000, 100, value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), this.config.maxReachDistance(), this.config.maxBlockBreakVolume(), (Integer)value, this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), this.config.blacklistedItems());
        });
        entries.addIntegerEntry(Text.translate("effortless.general_settings.max_block_interact_volume"), null, this.config.maxBlockInteractVolume(), 0, 1000000, 100, value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), this.config.maxReachDistance(), this.config.maxBlockBreakVolume(), this.config.maxBlockPlaceVolume(), (Integer)value, this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), this.config.blacklistedItems());
        });
        entries.addIntegerEntry(Text.translate("effortless.general_settings.max_structure_copy_paste_volume"), null, this.config.maxStructureCopyPasteVolume(), 0, 1000000, 100, value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), this.config.maxReachDistance(), this.config.maxBlockBreakVolume(), this.config.maxBlockPlaceVolume(), this.config.maxBlockInteractVolume(), (Integer)value, this.config.whitelistedItems(), this.config.blacklistedItems());
        });
        entries.addTab(Text.translate("effortless.general_settings.whitelisted_items"), null, this.config.whitelistedItems(), value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), this.config.maxReachDistance(), this.config.maxBlockBreakVolume(), this.config.maxBlockPlaceVolume(), this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), (List<ResourceLocation>)value, this.config.blacklistedItems());
        }, (entry, value) -> {
            entry.getButton().setOnPressListener(button1 -> new EffortlessItemsScreen((Entrance)this.getEntrance(), Text.translate("effortless.general_settings.whitelisted_items"), value.stream().map(Item::fromIdOptional).filter(Optional::isPresent).map(Optional::get).toList(), value1 -> entry.setItem(value1.stream().map(Item::getId).distinct().toList())).attach());
            entry.getButton().setMessage(Text.translate("effortless.general_settings.items", value.size()));
        });
        entries.addTab(Text.translate("effortless.general_settings.blacklisted_items"), null, this.config.blacklistedItems(), value -> {
            this.config = new ConstraintConfig(this.config.useCommands(), this.config.allowUseMod(), this.config.allowBreakBlocks(), this.config.allowPlaceBlocks(), this.config.allowInteractBlocks(), this.config.allowCopyPasteStructures(), this.config.useProperToolsOnly(), this.config.maxReachDistance(), this.config.maxBlockBreakVolume(), this.config.maxBlockPlaceVolume(), this.config.maxBlockInteractVolume(), this.config.maxStructureCopyPasteVolume(), this.config.whitelistedItems(), (List<ResourceLocation>)value);
        }, (entry, value) -> {
            entry.getButton().setOnPressListener(button1 -> new EffortlessItemsScreen((Entrance)this.getEntrance(), Text.translate("effortless.general_settings.blacklisted_items"), value.stream().map(Item::fromIdOptional).filter(Optional::isPresent).map(Optional::get).toList(), value1 -> entry.setItem(value1.stream().map(Item::getId).distinct().toList())).attach());
            entry.getButton().setMessage(Text.translate("effortless.general_settings.items", value.size()));
        });
        this.playerButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.per_player_overrides"), button -> new EffortlessPlayerGeneralSettingsListScreen(this.getEntrance(), this.getEntrance().getSessionManager().getServerSessionConfigOrEmpty().playerConfigs(), playerConfigs -> this.getEntrance().getSessionManager().updatePlayerConfig((Map<UUID, ConstraintConfig>)playerConfigs)).attach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.0f, 1.0f).build());
        this.cancelButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.cancel"), button -> this.detach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.0f, 0.33333334f).build());
        this.resetButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.reset"), button -> {
            this.config = this.defaultConfig;
            this.recreate();
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.33333334f, 0.33333334f).build());
        this.saveButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.save"), button -> {
            this.consumer.accept(this.config);
            this.detachAll();
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.6666667f, 0.33333334f).build());
        this.resetButton.setActive(false);
    }

    @Override
    protected EffortlessClient getEntrance() {
        return (EffortlessClient)super.getEntrance();
    }

    @Override
    public void onReload() {
        this.resetButton.setActive(!this.config.equals(this.defaultConfig));
    }
}

