/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.transformer;

import dev.huskuraft.effortless.EffortlessClient;
import dev.huskuraft.effortless.api.gui.AbstractPanelScreen;
import dev.huskuraft.effortless.api.gui.button.Button;
import dev.huskuraft.effortless.api.gui.container.EditableEntryList;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.gui.tooltip.TooltipHelper;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.ChatFormatting;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.config.ClientConfig;
import dev.huskuraft.effortless.building.config.PatternConfig;
import dev.huskuraft.effortless.building.pattern.Transformer;
import dev.huskuraft.effortless.building.pattern.randomize.ItemRandomizer;
import dev.huskuraft.effortless.screen.transformer.EffortlessItemRandomizerEditScreen;
import dev.huskuraft.effortless.screen.transformer.TransformerList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class EffortlessItemRandomizerPresetsScreen
extends AbstractPanelScreen {
    private Consumer<List<? extends Transformer>> consumer = transformers -> this.getEntrance().getConfigStorage().update(config -> config.withPatternConfig(new PatternConfig((List<? extends Transformer>)transformers)));
    private List<? extends Transformer> config = ((ClientConfig)this.getEntrance().getConfigStorage().get()).patternConfig().itemRandomizers();
    private TransformerList entries;
    private TextWidget titleTextWidget;
    private Button editButton;
    private Button deleteButton;
    private Button clearButton;
    private Button addButton;
    private Button cancelButton;
    private Button saveButton;

    public EffortlessItemRandomizerPresetsScreen(Entrance entrance) {
        super(entrance, Text.translate("effortless.transformer_presets.title").withStyle(ChatFormatting.DARK_GRAY), 264, 238);
    }

    public EffortlessItemRandomizerPresetsScreen(Entrance entrance, Consumer<List<? extends Transformer>> consumer) {
        this(entrance);
        this.consumer = consumer;
    }

    @Override
    protected EffortlessClient getEntrance() {
        return (EffortlessClient)super.getEntrance();
    }

    @Override
    public void onCreate() {
        this.titleTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getLeft() + this.getWidth() / 2, this.getTop() + 18 - 10, this.getScreenTitle().withColor(0x404040), TextWidget.Gravity.CENTER));
        this.editButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.edit"), button -> {
            if (this.entries.getSelected() != null && !((Transformer)((EditableEntryList.Entry)this.entries.getSelected()).getItem()).isBuiltIn()) {
                this.editTransformer((ItemRandomizer)((EditableEntryList.Entry)this.entries.getSelected()).getItem());
            }
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.0f, 0.25f).build());
        this.deleteButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.delete"), button -> {
            if (this.entries.getSelected() != null && !((Transformer)((EditableEntryList.Entry)this.entries.getSelected()).getItem()).isBuiltIn()) {
                this.entries.deleteSelected();
            }
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.25f, 0.25f).build());
        this.clearButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.clear"), button -> this.entries.reset(this.entries.items().stream().filter(transformer1 -> transformer1.isBuiltIn()).toList())).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.5f, 0.25f).build());
        this.addButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.add"), button -> this.editTransformer(ItemRandomizer.EMPTY.withName(Text.empty()).withRandomId())).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.75f, 0.25f).build());
        this.cancelButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.cancel"), button -> this.detach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.0f, 0.5f).build());
        this.saveButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.save"), button -> {
            this.detach();
            this.consumer.accept(this.config);
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.5f, 0.5f).build());
        this.entries = this.addWidget(new TransformerList(this.getEntrance(), this.getLeft() + 6, this.getTop() + 18, this.getWidth() - 12 - 8, this.getHeight() - 18 - 54));
        this.entries.setAlwaysShowScrollbar(true);
        this.entries.reset(this.config);
    }

    @Override
    public void onReload() {
        this.editButton.setActive(this.entries.getSelected() != null && !((Transformer)((EditableEntryList.Entry)this.entries.getSelected()).getItem()).isBuiltIn());
        this.deleteButton.setActive(this.entries.getSelected() != null && !((Transformer)((EditableEntryList.Entry)this.entries.getSelected()).getItem()).isBuiltIn());
        if (this.entries.getSelected() != null && ((Transformer)((EditableEntryList.Entry)this.entries.getSelected()).getItem()).isBuiltIn()) {
            this.editButton.setTooltip(Stream.concat(Stream.of(Text.translate("effortless.transformer.edit.tooltip.cannot_edit_built_in.title")), TooltipHelper.wrapLines(this.getTypeface(), Text.translate("effortless.transformer.edit.tooltip.cannot_edit_built_in.message").withStyle(ChatFormatting.GRAY)).stream()).toList());
        } else {
            this.editButton.clearTooltip();
        }
        if (this.entries.getSelected() != null && ((Transformer)((EditableEntryList.Entry)this.entries.getSelected()).getItem()).isBuiltIn()) {
            this.deleteButton.setTooltip(Stream.concat(Stream.of(Text.translate("effortless.transformer.delete.tooltip.cannot_delete_built_in.title")), TooltipHelper.wrapLines(this.getTypeface(), Text.translate("effortless.transformer.delete.tooltip.cannot_delete_built_in.message").withStyle(ChatFormatting.GRAY)).stream()).toList());
        } else {
            this.deleteButton.clearTooltip();
        }
        this.addButton.setTooltip(Stream.concat(Stream.of(Text.translate("effortless.transformer.add.tooltip.random.title")), TooltipHelper.wrapLines(this.getTypeface(), Text.translate("effortless.transformer.add.tooltip.random.message").withStyle(ChatFormatting.GRAY)).stream()).toList());
        if (this.entries.consumeDoubleClick() && this.entries.hasSelected() && !((Transformer)((EditableEntryList.Entry)this.entries.getSelected()).getItem()).isBuiltIn()) {
            this.editTransformer((ItemRandomizer)((EditableEntryList.Entry)this.entries.getSelected()).getItem());
        }
        this.config = this.entries.items();
    }

    private void editTransformer(ItemRandomizer transformer) {
        new EffortlessItemRandomizerEditScreen(this.getEntrance(), result -> {
            if (this.entries.hasSelected()) {
                this.entries.replaceSelect(result.withName(Text.empty()));
            } else {
                this.entries.insertSelected(result.withName(Text.empty()));
            }
            this.onReload();
        }, transformer).attach();
    }
}

