/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Calendar;
import net.lyivx.ls_furniture.LYIVXsFurnitureMod;
import net.lyivx.ls_furniture.common.blocks.entity.CustomChestBlockEntity;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CustomChestRenderer<T extends BlockEntity>
implements BlockEntityRenderer<CustomChestBlockEntity> {
    private static final String BOTTOM = "bottom";
    private static final String LID = "lid";
    private static final String LOCK = "lock";
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;
    private final ModelPart doubleLeftLid;
    private final ModelPart doubleLeftBottom;
    private final ModelPart doubleLeftLock;
    private final ModelPart doubleRightLid;
    private final ModelPart doubleRightBottom;
    private final ModelPart doubleRightLock;
    private boolean christmas;
    private boolean starwarsday;

    public CustomChestRenderer(BlockEntityRendererProvider.Context context) {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.christmas = true;
        }
        if (calendar.get(2) + 1 == 5 && calendar.get(5) >= 3 && calendar.get(5) <= 5) {
            this.starwarsday = true;
        }
        ModelPart modelPart = context.m_173582_(ModelLayers.f_171275_);
        this.bottom = modelPart.m_171324_(BOTTOM);
        this.lid = modelPart.m_171324_(LID);
        this.lock = modelPart.m_171324_(LOCK);
        ModelPart modelPart2 = context.m_173582_(ModelLayers.f_171133_);
        this.doubleLeftBottom = modelPart2.m_171324_(BOTTOM);
        this.doubleLeftLid = modelPart2.m_171324_(LID);
        this.doubleLeftLock = modelPart2.m_171324_(LOCK);
        ModelPart modelPart3 = context.m_173582_(ModelLayers.f_171134_);
        this.doubleRightBottom = modelPart3.m_171324_(BOTTOM);
        this.doubleRightLid = modelPart3.m_171324_(LID);
        this.doubleRightLock = modelPart3.m_171324_(LOCK);
    }

    public static LayerDefinition createSingleBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_(BOTTOM, CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partDefinition.m_171599_(LID, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.m_171599_(LOCK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(7.0f, -2.0f, 14.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyRightLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_(BOTTOM, CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partDefinition.m_171599_(LID, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.m_171599_(LOCK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(15.0f, -2.0f, 14.0f, 1.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyLeftLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_(BOTTOM, CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partDefinition.m_171599_(LID, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.m_171599_(LOCK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -2.0f, 14.0f, 1.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void render(CustomChestBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level level = blockEntity.m_58904_();
        boolean bl = level != null;
        BlockState blockState = bl ? blockEntity.m_58900_() : (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.SOUTH);
        ChestType chestType = blockState.m_61138_((Property)ChestBlock.f_51479_) ? (ChestType)blockState.m_61143_((Property)ChestBlock.f_51479_) : ChestType.SINGLE;
        Block block = blockState.m_60734_();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock abstractChestBlock = (AbstractChestBlock)block;
            boolean bl2 = chestType != ChestType.SINGLE;
            poseStack.m_85836_();
            float f = ((Direction)blockState.m_61143_((Property)ChestBlock.f_51478_)).m_122435_();
            poseStack.m_252880_(0.5f, 0.5f, 0.5f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-f));
            poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
            DoubleBlockCombiner.NeighborCombineResult neighborCombineResult = bl ? abstractChestBlock.m_5641_(blockState, level, blockEntity.m_58899_(), true) : DoubleBlockCombiner.Combiner::m_6502_;
            float g = ((Float2FloatFunction)neighborCombineResult.m_5649_(ChestBlock.m_51517_((LidBlockEntity)blockEntity))).get(partialTick);
            g = 1.0f - g;
            g = 1.0f - g * g * g;
            int i = ((Int2IntFunction)neighborCombineResult.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(packedLight);
            Material material = this.getChestMaterial(blockEntity, chestType);
            VertexConsumer vertexConsumer = material.m_119194_(buffer, RenderType::m_110452_);
            if (bl2) {
                if (chestType == ChestType.LEFT) {
                    this.render(poseStack, vertexConsumer, this.doubleLeftLid, this.doubleLeftLock, this.doubleLeftBottom, g, i, packedOverlay);
                } else {
                    this.render(poseStack, vertexConsumer, this.doubleRightLid, this.doubleRightLock, this.doubleRightBottom, g, i, packedOverlay);
                }
            } else {
                this.render(poseStack, vertexConsumer, this.lid, this.lock, this.bottom, g, i, packedOverlay);
            }
            poseStack.m_85849_();
        }
    }

    private void render(PoseStack poseStack, VertexConsumer consumer, ModelPart lidPart, ModelPart lockPart, ModelPart bottomPart, float lidAngle, int packedLight, int packedOverlay) {
        lockPart.f_104203_ = lidPart.f_104203_ = -(lidAngle * 1.5707964f);
        lidPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        lockPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        bottomPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
    }

    public static Material chooseMaterial(ChestType type, Material left, Material right, Material single) {
        return switch (type) {
            case ChestType.LEFT -> left;
            case ChestType.RIGHT -> right;
            default -> single;
        };
    }

    public static Material getChestPath(String name) {
        return new Material(Sheets.f_110740_, LYIVXsFurnitureMod.res("entity/chest/" + name));
    }

    private Material getChestMaterial(CustomChestBlockEntity blockEntity, ChestType type) {
        if (this.christmas) {
            return Sheets.m_110767_((BlockEntity)blockEntity, (ChestType)type, (boolean)true);
        }
        if (this.starwarsday) {
            return CustomChestRenderer.chooseMaterial(type, CustomChestRenderer.getChestPath("starwars_left"), CustomChestRenderer.getChestPath("starwars_right"), CustomChestRenderer.getChestPath("starwars"));
        }
        return CustomChestRenderer.chooseMaterial(type, CustomChestRenderer.getChestPath(blockEntity.getBlock().chestType + "_left"), CustomChestRenderer.getChestPath(blockEntity.getBlock().chestType + "_right"), CustomChestRenderer.getChestPath(blockEntity.getBlock().chestType));
    }
}

