/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.client.screens.widgets;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.resources.ResourceLocation;

public class HoverImageButton
extends ImageButton {
    private final ResourceLocation texture;
    private final int xTexStart;
    private final int yTexStart;
    private final int xDiffTex;
    private final int textureWidth;
    private final int textureHeight;
    private final int sourceWidth;
    private final int sourceHeight;
    private boolean stayClicked;
    private boolean stayClickedHover;
    private List<HoverImageButton> group;

    public HoverImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int xDiffTex, ResourceLocation texture, int textureWidth, int textureHeight, int sourceWidth, int sourceHeight, Button.OnPress onPress, boolean stayClicked, boolean stayClickedHover) {
        super(x, y, width, height, xTexStart, yTexStart, sourceWidth, texture, onPress);
        this.texture = texture;
        this.xTexStart = xTexStart;
        this.yTexStart = yTexStart;
        this.xDiffTex = xDiffTex;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.sourceWidth = sourceWidth;
        this.sourceHeight = sourceHeight;
        this.stayClicked = stayClicked;
        this.stayClickedHover = stayClickedHover;
        this.group = new ArrayList<HoverImageButton>();
    }

    public void setStayClicked(boolean stayClicked) {
        this.stayClicked = stayClicked;
        if (stayClicked) {
            for (HoverImageButton button : this.group) {
                if (button == this) continue;
                button.setStayClicked(false);
            }
        }
    }

    public boolean isStayClicked() {
        return this.stayClicked;
    }

    public void addToGroup(HoverImageButton ... buttons) {
        for (HoverImageButton button : buttons) {
            if (this.group.contains((Object)button)) continue;
            this.group.add(button);
            button.addToGroup(this);
        }
    }

    public static void group(HoverImageButton ... buttons) {
        if (buttons == null || buttons.length <= 1) {
            return;
        }
        for (int i = 0; i < buttons.length; ++i) {
            for (int j = i + 1; j < buttons.length; ++j) {
                HoverImageButton first = buttons[i];
                HoverImageButton second = buttons[j];
                if (first == null || second == null) continue;
                first.addToGroup(second);
            }
        }
    }

    public void m_5691_() {
        this.setStayClicked(true);
        super.m_5691_();
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int xTex = this.xTexStart;
        if (this.stayClicked && !this.m_274382_()) {
            xTex += this.xDiffTex * 2;
        } else if (this.stayClicked && this.m_274382_() && this.stayClickedHover) {
            xTex += this.xDiffTex * 3;
        } else if (this.stayClicked && this.m_274382_() && !this.stayClickedHover) {
            xTex += this.xDiffTex * 2;
        } else if (!this.stayClicked && !this.m_274382_()) {
            xTex += 0;
        } else if (!this.stayClicked && this.m_274382_()) {
            xTex += this.xDiffTex;
        }
        guiGraphics.m_280411_(this.texture, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, (float)xTex, (float)this.yTexStart, this.sourceWidth, this.sourceHeight, this.textureWidth, this.textureHeight);
    }
}

