/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.List;
import java.util.stream.Stream;
import net.lyivx.ls_furniture.common.blocks.entity.DrainerBlockEntity;
import net.lyivx.ls_furniture.common.items.WrenchItem;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.lyivx.ls_furniture.common.utils.block.BlockPart;
import net.lyivx.ls_furniture.registry.ModItems;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DrainerBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
WrenchItem.WrenchableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape NORTH = Stream.of(Block.m_49796_((double)-1.0, (double)0.0, (double)3.0, (double)8.0, (double)1.0, (double)13.0), Block.m_49796_((double)-1.0, (double)0.0, (double)2.0, (double)9.0, (double)1.0999999999999999, (double)3.0), Block.m_49796_((double)-1.0, (double)0.0, (double)13.0, (double)9.0, (double)1.0999999999999999, (double)14.0), Block.m_49796_((double)0.0, (double)0.1, (double)11.0, (double)8.0, (double)1.0999999999999999, (double)12.0), Block.m_49796_((double)0.0, (double)0.1, (double)9.0, (double)8.0, (double)1.0999999999999999, (double)10.0), Block.m_49796_((double)0.0, (double)0.1, (double)6.0, (double)8.0, (double)1.0999999999999999, (double)7.0), Block.m_49796_((double)0.0, (double)0.1, (double)4.0, (double)8.0, (double)1.0999999999999999, (double)5.0), Block.m_49796_((double)8.0, (double)0.0, (double)3.0, (double)9.0, (double)1.0999999999999999, (double)13.0), Block.m_49796_((double)8.0, (double)1.0999999999999999, (double)13.0, (double)9.0, (double)3.0, (double)14.0), Block.m_49796_((double)-1.0, (double)1.0999999999999999, (double)13.0, (double)0.0, (double)3.0, (double)14.0), Block.m_49796_((double)0.0, (double)2.0, (double)13.0, (double)8.0, (double)3.0, (double)14.0), Block.m_49796_((double)8.0, (double)1.0999999999999999, (double)11.0, (double)9.0, (double)3.0, (double)12.0), Block.m_49796_((double)-1.0, (double)1.0, (double)11.0, (double)0.0, (double)3.0, (double)12.0), Block.m_49796_((double)0.0, (double)2.0, (double)11.0, (double)8.0, (double)3.0, (double)12.0), Block.m_49796_((double)8.0, (double)1.0999999999999999, (double)9.0, (double)9.0, (double)3.0, (double)10.0), Block.m_49796_((double)-1.0, (double)1.0, (double)9.0, (double)0.0, (double)3.0, (double)10.0), Block.m_49796_((double)0.0, (double)2.0, (double)9.0, (double)8.0, (double)3.0, (double)10.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape[] SHAPES = new VoxelShape[4];

    public DrainerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof WrenchItem) {
            return InteractionResult.FAIL;
        }
        if (hit.m_82434_() != Direction.UP) {
            return InteractionResult.PASS;
        }
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockEntity blockentity = level.m_7702_(pos);
        if (!(blockentity instanceof DrainerBlockEntity)) {
            return InteractionResult.PASS;
        }
        DrainerBlockEntity drainerBlockEntity = (DrainerBlockEntity)blockentity;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        int slot = BlockPart.get1D(pos, hit.m_82450_(), facing, 2);
        if (!stack.m_41619_()) {
            if (stack.m_150930_(ModItems.PLATE.get()) && !level.f_46443_ && drainerBlockEntity.placeItem(player.m_150110_().f_35937_ ? stack.m_41777_() : stack, slot)) {
                level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        if (drainerBlockEntity.removeItem(slot, player, level)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof DrainerBlockEntity) {
            DrainerBlockEntity drainerBlockEntity = (DrainerBlockEntity)blockentity;
            Containers.m_19010_((Level)level, (BlockPos)pos, drainerBlockEntity.getItems());
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return SHAPES[direction.m_122416_()];
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean waterlogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DrainerBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.blank"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.properties"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.wrenchable"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.shift"));
        }
        super.m_5871_(stack, level, tooltip, flag);
    }

    @Override
    public List<Property<?>> getWrenchableProperties() {
        return List.of(FACING);
    }

    static {
        DrainerBlock.SHAPES[0] = ShapeUtil.rotateShape(NORTH, Direction.SOUTH);
        DrainerBlock.SHAPES[1] = ShapeUtil.rotateShape(NORTH, Direction.WEST);
        DrainerBlock.SHAPES[2] = ShapeUtil.rotateShape(NORTH, Direction.NORTH);
        DrainerBlock.SHAPES[3] = ShapeUtil.rotateShape(NORTH, Direction.EAST);
    }
}

