/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.Locale;
import java.util.stream.Stream;
import net.lyivx.ls_furniture.common.blocks.entity.FreezerBlockEntity;
import net.lyivx.ls_furniture.common.blocks.entity.FridgeBlockEntity;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FridgeFreezerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<FridgeModelType> MODEL_TYPE = EnumProperty.m_61587_((String)"model", FridgeModelType.class);
    private static final VoxelShape BASE_LOWER_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)32.0, (double)16.0), Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)21.0, (double)1.0), Block.m_49796_((double)2.0, (double)24.0, (double)0.0, (double)14.0, (double)30.0, (double)1.0), Block.m_49796_((double)12.0, (double)28.0, (double)-1.0, (double)13.0, (double)29.0, (double)0.0), Block.m_49796_((double)12.0, (double)25.0, (double)-1.0, (double)13.0, (double)26.0, (double)0.0), Block.m_49796_((double)12.0, (double)25.0, (double)-2.0, (double)13.0, (double)29.0, (double)-1.0), Block.m_49796_((double)12.0, (double)16.0, (double)-2.0, (double)13.0, (double)20.0, (double)-1.0), Block.m_49796_((double)12.0, (double)19.0, (double)-1.0, (double)13.0, (double)20.0, (double)0.0), Block.m_49796_((double)12.0, (double)16.0, (double)-1.0, (double)13.0, (double)17.0, (double)0.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape BASE_UPPER_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)-16.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)2.0, (double)-14.0, (double)0.0, (double)14.0, (double)5.0, (double)1.0), Block.m_49796_((double)2.0, (double)8.0, (double)0.0, (double)14.0, (double)14.0, (double)1.0), Block.m_49796_((double)12.0, (double)12.0, (double)-1.0, (double)13.0, (double)13.0, (double)0.0), Block.m_49796_((double)12.0, (double)9.0, (double)-1.0, (double)13.0, (double)10.0, (double)0.0), Block.m_49796_((double)12.0, (double)9.0, (double)-2.0, (double)13.0, (double)13.0, (double)-1.0), Block.m_49796_((double)12.0, (double)0.0, (double)-2.0, (double)13.0, (double)4.0, (double)-1.0), Block.m_49796_((double)12.0, (double)3.0, (double)-1.0, (double)13.0, (double)4.0, (double)0.0), Block.m_49796_((double)12.0, (double)0.0, (double)-1.0, (double)13.0, (double)1.0, (double)0.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape BASE_LOWER_OPEN_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)21.0, (double)1.0, (double)16.0, (double)32.0, (double)16.0), Block.m_49796_((double)2.0, (double)24.0, (double)0.0, (double)14.0, (double)30.0, (double)1.0), Block.m_49796_((double)12.0, (double)28.0, (double)-1.0, (double)13.0, (double)29.0, (double)0.0), Block.m_49796_((double)12.0, (double)25.0, (double)-1.0, (double)13.0, (double)26.0, (double)0.0), Block.m_49796_((double)12.0, (double)25.0, (double)-2.0, (double)13.0, (double)29.0, (double)-1.0), Block.m_49796_((double)0.0, (double)2.0, (double)1.0, (double)2.0, (double)21.0, (double)16.0), Block.m_49796_((double)14.0, (double)2.0, (double)1.0, (double)16.0, (double)21.0, (double)16.0), Block.m_49796_((double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)21.0, (double)16.0), Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), Block.m_49796_((double)2.0, (double)15.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)1.0, (double)2.0, (double)0.0, (double)3.0, (double)21.0, (double)2.0), Block.m_49796_((double)2.0, (double)2.0, (double)-1.0, (double)4.0, (double)21.0, (double)1.0), Block.m_49796_((double)3.0, (double)2.0, (double)-2.0, (double)5.0, (double)21.0, (double)0.0), Block.m_49796_((double)4.0, (double)2.0, (double)-3.0, (double)6.0, (double)21.0, (double)-1.0), Block.m_49796_((double)5.0, (double)2.0, (double)-4.0, (double)7.0, (double)21.0, (double)-2.0), Block.m_49796_((double)6.0, (double)2.0, (double)-5.0, (double)8.0, (double)21.0, (double)-3.0), Block.m_49796_((double)7.0, (double)2.0, (double)-6.0, (double)9.0, (double)21.0, (double)-4.0), Block.m_49796_((double)8.0, (double)2.0, (double)-7.0, (double)10.0, (double)21.0, (double)-5.0), Block.m_49796_((double)9.0, (double)2.0, (double)-8.0, (double)11.0, (double)21.0, (double)-6.0), Block.m_49796_((double)8.0, (double)16.0, (double)-8.0, (double)9.0, (double)20.0, (double)-7.0), Block.m_49796_((double)7.0, (double)16.0, (double)-9.0, (double)8.0, (double)20.0, (double)-8.0), Block.m_49796_((double)7.5, (double)16.0, (double)-8.5, (double)8.5, (double)20.0, (double)-7.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape BASE_UPPER_OPEN_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)14.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)7.0, (double)1.0, (double)2.0, (double)14.0, (double)16.0), Block.m_49796_((double)14.0, (double)7.0, (double)1.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)2.0, (double)7.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0), Block.m_49796_((double)1.0, (double)8.0, (double)0.0, (double)3.0, (double)14.0, (double)2.0), Block.m_49796_((double)2.0, (double)8.0, (double)-1.0, (double)4.0, (double)14.0, (double)1.0), Block.m_49796_((double)3.0, (double)8.0, (double)-2.0, (double)5.0, (double)14.0, (double)0.0), Block.m_49796_((double)4.0, (double)8.0, (double)-3.0, (double)6.0, (double)14.0, (double)-1.0), Block.m_49796_((double)5.0, (double)8.0, (double)-4.0, (double)7.0, (double)14.0, (double)-2.0), Block.m_49796_((double)6.0, (double)8.0, (double)-5.0, (double)8.0, (double)14.0, (double)-3.0), Block.m_49796_((double)7.0, (double)8.0, (double)-6.0, (double)9.0, (double)14.0, (double)-4.0), Block.m_49796_((double)8.0, (double)8.0, (double)-7.0, (double)10.0, (double)14.0, (double)-5.0), Block.m_49796_((double)9.0, (double)8.0, (double)-8.0, (double)11.0, (double)14.0, (double)-6.0), Block.m_49796_((double)8.0, (double)9.0, (double)-8.0, (double)9.0, (double)13.0, (double)-7.0), Block.m_49796_((double)7.0, (double)9.0, (double)-9.0, (double)8.0, (double)13.0, (double)-8.0), Block.m_49796_((double)7.5, (double)9.0, (double)-8.5, (double)8.5, (double)13.0, (double)-7.5), Block.m_49796_((double)2.0, (double)7.0, (double)1.0, (double)14.0, (double)8.0, (double)3.0), Block.m_49796_((double)0.0, (double)-16.0, (double)1.0, (double)16.0, (double)7.0, (double)16.0), Block.m_49796_((double)2.0, (double)-14.0, (double)0.0, (double)14.0, (double)5.0, (double)2.0), Block.m_49796_((double)12.0, (double)3.0, (double)-1.0, (double)13.0, (double)4.0, (double)0.0), Block.m_49796_((double)12.0, (double)0.0, (double)-1.0, (double)13.0, (double)1.0, (double)0.0), Block.m_49796_((double)12.0, (double)0.0, (double)-2.0, (double)13.0, (double)4.0, (double)-1.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape[] SHAPES = new VoxelShape[8];
    private static final VoxelShape[] SHAPES_OPEN = new VoxelShape[8];

    public FridgeFreezerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(MODEL_TYPE, (Comparable)((Object)FridgeModelType.BOTTOM))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, MODEL_TYPE, OPEN});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockPos = context.m_8083_();
        Level level = context.m_43725_();
        if (level.m_8055_(blockPos.m_7494_()).m_60629_(context)) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (state.m_61143_(MODEL_TYPE) == FridgeModelType.BOTTOM) {
            if (blockEntity instanceof FridgeBlockEntity) {
                FridgeBlockEntity fridgeBlockEntity = (FridgeBlockEntity)blockEntity;
                player.m_5893_((MenuProvider)fridgeBlockEntity);
                PiglinAi.m_34873_((Player)player, (boolean)true);
                return InteractionResult.SUCCESS;
            }
        } else if (state.m_61143_(MODEL_TYPE) == FridgeModelType.TOP && blockEntity instanceof FreezerBlockEntity) {
            FreezerBlockEntity freezerBlockEntity = (FreezerBlockEntity)blockEntity;
            player.m_5893_((MenuProvider)freezerBlockEntity);
            PiglinAi.m_34873_((Player)player, (boolean)true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Container) {
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((Container)blockEntity));
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    private static Direction getNeighbourDirection(FridgeModelType modelType) {
        return modelType == FridgeModelType.BOTTOM ? Direction.UP : Direction.DOWN;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        FridgeModelType modelType;
        BlockPos otherPos;
        BlockState otherState;
        if (!level.f_46443_ && (otherState = level.m_8055_(otherPos = pos.m_121945_(FridgeFreezerBlock.getNeighbourDirection(modelType = (FridgeModelType)((Object)state.m_61143_(MODEL_TYPE)))))).m_60734_() == this && otherState.m_61143_(MODEL_TYPE) != modelType) {
            BlockPos bottomPos = modelType == FridgeModelType.BOTTOM ? pos : otherPos;
            BlockPos topPos = modelType == FridgeModelType.TOP ? pos : otherPos;
            level.m_7731_(bottomPos, Blocks.f_50016_.m_49966_(), 3);
            level.m_5898_(player, 2001, bottomPos, Block.m_49956_((BlockState)state));
            level.m_7731_(topPos, Blocks.f_50016_.m_49966_(), 3);
            level.m_5898_(player, 2001, topPos, Block.m_49956_((BlockState)otherState));
            if (!player.m_7500_()) {
                FridgeFreezerBlock.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
                FridgeFreezerBlock.m_49881_((BlockState)otherState, (Level)level, (BlockPos)otherPos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (!level.f_46443_) {
            level.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(MODEL_TYPE, (Comparable)((Object)FridgeModelType.TOP)), 3);
            level.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)level, pos, 3);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FridgeBlockEntity) {
            FridgeBlockEntity fridgeBE = (FridgeBlockEntity)blockEntity;
            fridgeBE.recheckOpen();
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (state.m_61143_(MODEL_TYPE) == FridgeModelType.TOP) {
            return new FreezerBlockEntity(pos, state);
        }
        return new FridgeBlockEntity(pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        int shape = ((Direction)state.m_61143_((Property)FACING)).m_122416_();
        if (state.m_61143_(MODEL_TYPE) == FridgeModelType.BOTTOM && !((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return SHAPES[4 + direction.m_122416_()];
        }
        if (state.m_61143_(MODEL_TYPE) == FridgeModelType.BOTTOM && ((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return SHAPES_OPEN[4 + direction.m_122416_()];
        }
        if (state.m_61143_(MODEL_TYPE) == FridgeModelType.TOP && !((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return SHAPES[direction.m_122416_()];
        }
        if (state.m_61143_(MODEL_TYPE) == FridgeModelType.TOP && ((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return SHAPES_OPEN[direction.m_122416_()];
        }
        return SHAPES[shape];
    }

    static {
        FridgeFreezerBlock.SHAPES[0] = ShapeUtil.rotateShape(BASE_UPPER_SHAPE, Direction.SOUTH);
        FridgeFreezerBlock.SHAPES[1] = ShapeUtil.rotateShape(BASE_UPPER_SHAPE, Direction.WEST);
        FridgeFreezerBlock.SHAPES[2] = ShapeUtil.rotateShape(BASE_UPPER_SHAPE, Direction.NORTH);
        FridgeFreezerBlock.SHAPES[3] = ShapeUtil.rotateShape(BASE_UPPER_SHAPE, Direction.EAST);
        FridgeFreezerBlock.SHAPES[4] = ShapeUtil.rotateShape(BASE_LOWER_SHAPE, Direction.SOUTH);
        FridgeFreezerBlock.SHAPES[5] = ShapeUtil.rotateShape(BASE_LOWER_SHAPE, Direction.WEST);
        FridgeFreezerBlock.SHAPES[6] = ShapeUtil.rotateShape(BASE_LOWER_SHAPE, Direction.NORTH);
        FridgeFreezerBlock.SHAPES[7] = ShapeUtil.rotateShape(BASE_LOWER_SHAPE, Direction.EAST);
        FridgeFreezerBlock.SHAPES_OPEN[0] = ShapeUtil.rotateShape(BASE_UPPER_OPEN_SHAPE, Direction.SOUTH);
        FridgeFreezerBlock.SHAPES_OPEN[1] = ShapeUtil.rotateShape(BASE_UPPER_OPEN_SHAPE, Direction.WEST);
        FridgeFreezerBlock.SHAPES_OPEN[2] = ShapeUtil.rotateShape(BASE_UPPER_OPEN_SHAPE, Direction.NORTH);
        FridgeFreezerBlock.SHAPES_OPEN[3] = ShapeUtil.rotateShape(BASE_UPPER_OPEN_SHAPE, Direction.EAST);
        FridgeFreezerBlock.SHAPES_OPEN[4] = ShapeUtil.rotateShape(BASE_LOWER_OPEN_SHAPE, Direction.SOUTH);
        FridgeFreezerBlock.SHAPES_OPEN[5] = ShapeUtil.rotateShape(BASE_LOWER_OPEN_SHAPE, Direction.WEST);
        FridgeFreezerBlock.SHAPES_OPEN[6] = ShapeUtil.rotateShape(BASE_LOWER_OPEN_SHAPE, Direction.NORTH);
        FridgeFreezerBlock.SHAPES_OPEN[7] = ShapeUtil.rotateShape(BASE_LOWER_OPEN_SHAPE, Direction.EAST);
    }

    public static enum FridgeModelType implements StringRepresentable
    {
        BOTTOM,
        TOP;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.m_7912_();
        }
    }
}

