/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.lyivx.ls_furniture.common.blocks.entity.MailboxBlockEntity;
import net.lyivx.ls_furniture.common.blocks.properties.ModBlockStateProperties;
import net.lyivx.ls_furniture.common.items.WrenchItem;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.lyivx.ls_furniture.registry.ModBlockEntitys;
import net.lyivx.ls_furniture.registry.ModBlocksTags;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MailboxBlock
extends BaseEntityBlock
implements WrenchItem.WrenchableBlock {
    public static ArrayList<MailboxBlock> ALL_MAILBOXES = new ArrayList();
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty HAS_MAIL = ModBlockStateProperties.HAS_MAIL;
    protected static final VoxelShape SHAPE_NORTH = Stream.of(Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)10.0, (double)9.0), Block.m_49796_((double)5.0, (double)10.0, (double)3.5, (double)11.0, (double)12.0, (double)12.5), Block.m_49796_((double)9.0, (double)12.0, (double)3.5, (double)11.0, (double)13.0, (double)12.5), Block.m_49796_((double)5.0, (double)12.0, (double)3.5, (double)7.0, (double)13.0, (double)12.5), Block.m_49796_((double)6.0, (double)13.0, (double)3.5, (double)7.0, (double)14.0, (double)12.5), Block.m_49796_((double)9.0, (double)13.0, (double)3.5, (double)10.0, (double)14.0, (double)12.5), Block.m_49796_((double)7.0, (double)14.0, (double)3.5, (double)9.0, (double)15.0, (double)12.5), Block.m_49796_((double)7.0, (double)12.0, (double)11.5, (double)9.0, (double)14.0, (double)12.5), Block.m_49796_((double)4.0, (double)12.0, (double)3.0, (double)5.0, (double)13.0, (double)13.0), Block.m_49796_((double)5.0, (double)13.0, (double)3.0, (double)6.0, (double)14.0, (double)13.0), Block.m_49796_((double)6.0, (double)14.0, (double)3.0, (double)7.0, (double)15.0, (double)13.0), Block.m_49796_((double)7.0, (double)15.0, (double)3.0, (double)9.0, (double)16.0, (double)13.0), Block.m_49796_((double)9.0, (double)14.0, (double)3.0, (double)10.0, (double)15.0, (double)13.0), Block.m_49796_((double)10.0, (double)13.0, (double)3.0, (double)11.0, (double)14.0, (double)13.0), Block.m_49796_((double)11.0, (double)12.0, (double)3.0, (double)12.0, (double)13.0, (double)13.0), Block.m_49796_((double)10.999999999999998, (double)11.0, (double)4.0, (double)12.049999999999999, (double)12.0, (double)9.0), Block.m_49796_((double)10.999999999999998, (double)10.0, (double)8.0, (double)12.049999999999999, (double)11.0, (double)9.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_EAST = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.EAST);
    protected static final VoxelShape SHAPE_SOUTH = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.SOUTH);
    protected static final VoxelShape SHAPE_WEST = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.WEST);
    protected static final VoxelShape SHAPE_NORTH_OPEN = Stream.of(Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)10.0, (double)9.0), Block.m_49796_((double)5.0, (double)10.0, (double)3.5, (double)11.0, (double)12.0, (double)12.5), Block.m_49796_((double)9.0, (double)12.0, (double)3.5, (double)11.0, (double)13.0, (double)12.5), Block.m_49796_((double)5.0, (double)12.0, (double)3.5, (double)7.0, (double)13.0, (double)12.5), Block.m_49796_((double)6.0, (double)13.0, (double)3.5, (double)7.0, (double)14.0, (double)12.5), Block.m_49796_((double)9.0, (double)13.0, (double)3.5, (double)10.0, (double)14.0, (double)12.5), Block.m_49796_((double)7.0, (double)14.0, (double)3.5, (double)9.0, (double)15.0, (double)12.5), Block.m_49796_((double)7.0, (double)12.0, (double)11.5, (double)9.0, (double)14.0, (double)12.5), Block.m_49796_((double)4.0, (double)12.0, (double)3.0, (double)5.0, (double)13.0, (double)13.0), Block.m_49796_((double)5.0, (double)13.0, (double)3.0, (double)6.0, (double)14.0, (double)13.0), Block.m_49796_((double)6.0, (double)14.0, (double)3.0, (double)7.0, (double)15.0, (double)13.0), Block.m_49796_((double)7.0, (double)15.0, (double)3.0, (double)9.0, (double)16.0, (double)13.0), Block.m_49796_((double)9.0, (double)14.0, (double)3.0, (double)10.0, (double)15.0, (double)13.0), Block.m_49796_((double)10.0, (double)13.0, (double)3.0, (double)11.0, (double)14.0, (double)13.0), Block.m_49796_((double)11.0, (double)12.0, (double)3.0, (double)12.0, (double)13.0, (double)13.0), Block.m_49796_((double)10.999999999999998, (double)11.0, (double)4.0, (double)12.049999999999999, (double)16.0, (double)5.0), Block.m_49796_((double)10.999999999999998, (double)15.0, (double)5.0, (double)12.049999999999999, (double)16.0, (double)6.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_EAST_OPEN = ShapeUtil.rotateShape(SHAPE_NORTH_OPEN, Direction.EAST);
    protected static final VoxelShape SHAPE_SOUTH_OPEN = ShapeUtil.rotateShape(SHAPE_NORTH_OPEN, Direction.SOUTH);
    protected static final VoxelShape SHAPE_WEST_OPEN = ShapeUtil.rotateShape(SHAPE_NORTH_OPEN, Direction.WEST);
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_SOUTH, SHAPE_WEST, SHAPE_NORTH, SHAPE_EAST, SHAPE_SOUTH_OPEN, SHAPE_WEST_OPEN, SHAPE_NORTH_OPEN, SHAPE_EAST_OPEN};

    public MailboxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HAS_MAIL, (Comparable)Boolean.valueOf(false)));
        ALL_MAILBOXES.add(this);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : MailboxBlock.m_152132_(type, ModBlockEntitys.MAILBOX_ENTITY.get(), MailboxBlockEntity::tick);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof MailboxBlockEntity)) {
            return InteractionResult.FAIL;
        }
        MailboxBlockEntity mailbox = (MailboxBlockEntity)blockEntity;
        if (!mailbox.hasOwner()) {
            mailbox.setOwner(player);
            player.m_5661_((Component)Component.m_237115_((String)"msg.ls_furniture.mailbox.set_owner"), true);
            return InteractionResult.m_19078_((boolean)false);
        }
        if (mailbox.isOwner(player)) {
            mailbox.updateDisplayName(player);
            player.m_5893_((MenuProvider)mailbox);
            return InteractionResult.m_19078_((boolean)false);
        }
        if (player.m_21120_(hand).m_41619_()) {
            player.m_5661_((Component)Component.m_237115_((String)"msg.ls_furniture.mailbox.no_permission"), true);
            return InteractionResult.FAIL;
        }
        if (mailbox.isFull()) {
            player.m_5661_((Component)Component.m_237115_((String)"msg.ls_furniture.mailbox.full"), true);
            return InteractionResult.FAIL;
        }
        ItemStack result = mailbox.addMail(player.m_21120_(hand));
        player.m_21008_(hand, result);
        if (result.m_41619_()) {
            Component ownerName = mailbox.getOwnerDisplayName();
            if (ownerName != null) {
                player.m_5661_((Component)Component.m_237110_((String)"msg.ls_furniture.mailbox.mail_delivered_to", (Object[])new Object[]{ownerName}), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"msg.ls_furniture.mailbox.mail_delivered"), true);
            }
            return InteractionResult.m_19078_((boolean)false);
        }
        player.m_5661_((Component)Component.m_237115_((String)"msg.ls_furniture.mailbox.invalid_mail"), true);
        return InteractionResult.FAIL;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Container) {
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((Container)blockEntity));
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_6240_(Level level, Player player, BlockPos blockPos, BlockState state, BlockEntity blockEntity, ItemStack stack) {
        if (!level.m_5776_() && blockEntity != null && blockEntity instanceof MailboxBlockEntity) {
            MailboxBlockEntity mailboxBlockEntity = (MailboxBlockEntity)blockEntity;
            if (mailboxBlockEntity.isOwner(player) || player.m_7500_() && (player.m_20310_(1) || state.m_204336_(ModBlocksTags.NON_OP_CREATIVE_CAN_DESTROY_TAG))) {
                super.m_6240_(level, player, blockPos, state, blockEntity, stack);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"msg.ls_furniture.mailbox.no_permission"), true);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MailboxBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        BlockEntity tileEntity;
        BlockEntity blockEntity = level.m_7702_(pos);
        MailboxBlockEntity mailbox = (MailboxBlockEntity)blockEntity;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            mailbox.setOwner(player);
            player.m_5661_((Component)Component.m_237115_((String)"msg.ls_furniture.mailbox.set_owner"), true);
        }
        if (stack.m_41788_() && (tileEntity = level.m_7702_(pos)) instanceof MailboxBlockEntity) {
            ((MailboxBlockEntity)tileEntity).m_58638_(stack.m_41786_());
        }
        mailbox.m_6596_();
        level.m_7260_(pos, state, state, 3);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HAS_MAIL});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int shape = ((Direction)state.m_61143_((Property)FACING)).m_122416_();
        if (((Boolean)state.m_61143_((Property)HAS_MAIL)).booleanValue()) {
            shape += 4;
        }
        return SHAPES[shape];
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.blank"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.properties"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.wrenchable"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.shift"));
        }
        super.m_5871_(stack, level, tooltip, flag);
    }

    @Override
    public List<Property<?>> getWrenchableProperties() {
        return List.of(FACING);
    }
}

