/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.List;
import java.util.stream.Stream;
import net.lyivx.ls_core.common.utils.WoolHelper;
import net.lyivx.ls_furniture.common.blocks.SeatBlock;
import net.lyivx.ls_furniture.common.blocks.entity.LockableBlockEntity;
import net.lyivx.ls_furniture.common.blocks.properties.ColorType;
import net.lyivx.ls_furniture.common.blocks.properties.ModBlockStateProperties;
import net.lyivx.ls_furniture.common.items.HammerItem;
import net.lyivx.ls_furniture.common.items.WrenchItem;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.lyivx.ls_furniture.common.utils.block.ILockable;
import net.lyivx.ls_furniture.common.utils.block.TuckableBlock;
import net.lyivx.ls_furniture.registry.ModItems;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoolBlock
extends SeatBlock
implements SimpleWaterloggedBlock,
WrenchItem.WrenchableBlock,
HammerItem.HammerableBlock,
TuckableBlock,
EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<ColorType> COLOR = ModBlockStateProperties.COLOR;
    protected static final VoxelShape SHAPE_NORTH = Stream.of(Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)5.0, (double)9.0, (double)5.0), Block.m_49796_((double)3.0, (double)0.0, (double)11.0, (double)5.0, (double)9.0, (double)13.0), Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)13.0, (double)9.0, (double)13.0), Block.m_49796_((double)11.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)5.0), Block.m_49796_((double)3.0, (double)9.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0), Block.m_49796_((double)5.0, (double)5.0, (double)3.0, (double)11.0, (double)7.0, (double)5.0), Block.m_49796_((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)7.0, (double)13.0), Block.m_49796_((double)3.0, (double)5.0, (double)5.0, (double)5.0, (double)7.0, (double)11.0), Block.m_49796_((double)11.0, (double)5.0, (double)5.0, (double)13.0, (double)7.0, (double)11.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_EAST = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.EAST);
    protected static final VoxelShape SHAPE_SOUTH = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.SOUTH);
    protected static final VoxelShape SHAPE_WEST = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.WEST);
    protected static final VoxelShape SHAPE_NORTH_TUCKED = Stream.of(Block.m_49796_((double)3.0, (double)0.0, (double)-6.0, (double)5.0, (double)9.0, (double)-4.0), Block.m_49796_((double)3.0, (double)0.0, (double)2.0, (double)5.0, (double)9.0, (double)4.0), Block.m_49796_((double)11.0, (double)0.0, (double)2.0, (double)13.0, (double)9.0, (double)4.0), Block.m_49796_((double)11.0, (double)0.0, (double)-6.0, (double)13.0, (double)9.0, (double)-4.0), Block.m_49796_((double)3.0, (double)9.0, (double)-6.0, (double)13.0, (double)11.0, (double)4.0), Block.m_49796_((double)5.0, (double)5.0, (double)-6.0, (double)11.0, (double)7.0, (double)-4.0), Block.m_49796_((double)5.0, (double)5.0, (double)2.0, (double)11.0, (double)7.0, (double)4.0), Block.m_49796_((double)3.0, (double)5.0, (double)-4.0, (double)5.0, (double)7.0, (double)2.0), Block.m_49796_((double)11.0, (double)5.0, (double)-4.0, (double)13.0, (double)7.0, (double)2.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_EAST_TUCKED = ShapeUtil.rotateShape(SHAPE_NORTH_TUCKED, Direction.EAST);
    protected static final VoxelShape SHAPE_SOUTH_TUCKED = ShapeUtil.rotateShape(SHAPE_NORTH_TUCKED, Direction.SOUTH);
    protected static final VoxelShape SHAPE_WEST_TUCKED = ShapeUtil.rotateShape(SHAPE_NORTH_TUCKED, Direction.WEST);
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_SOUTH, SHAPE_WEST, SHAPE_NORTH, SHAPE_EAST, SHAPE_SOUTH_TUCKED, SHAPE_WEST_TUCKED, SHAPE_NORTH_TUCKED, SHAPE_EAST_TUCKED};

    public StoolBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TUCKED, (Comparable)Boolean.valueOf(false))).m_61124_(COLOR, (Comparable)((Object)ColorType.DEFAULT)));
    }

    @Override
    public float seatHeight(BlockState state) {
        return 0.45f;
    }

    @Override
    public boolean isSittable(BlockState state) {
        return (Boolean)state.m_61143_((Property)TUCKED) == false;
    }

    @Override
    public BlockPos primaryDismountLocation(Level level, BlockState state, BlockPos pos) {
        return pos.m_121945_((Direction)state.m_61143_((Property)FACING));
    }

    @Override
    public float setRiderRotation(BlockState state, Entity entity) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122435_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int shape = ((Direction)state.m_61143_((Property)FACING)).m_122416_();
        if (((Boolean)state.m_61143_((Property)TUCKED)).booleanValue()) {
            shape += 4;
        }
        return SHAPES[shape];
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean waterlogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        Level level1;
        ILockable lockable;
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if ((blockEntity = level.m_7702_(currentPos)) instanceof ILockable && (lockable = (ILockable)blockEntity).isLocked()) {
            return state;
        }
        if (((Boolean)state.m_61143_((Property)TUCKED)).booleanValue() && level instanceof Level && !TuckableBlock.canTuckUnderBlockInfront(state, level1 = (Level)level, currentPos)) {
            return (BlockState)state.m_61124_((Property)TUCKED, (Comparable)Boolean.valueOf(false));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public static ColorType getColorTypeFromDye(DyeColor dyeColor) {
        for (ColorType colorType : ColorType.values()) {
            if (colorType.getDyeColor() != dyeColor) continue;
            return colorType;
        }
        return ColorType.WHITE;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        DyeColor dye;
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof HammerItem || item instanceof WrenchItem) {
            return InteractionResult.FAIL;
        }
        DyeColor woolDye = WoolHelper.getDyeColor((ItemLike)stack.m_41720_());
        if (woolDye != null && state.m_61143_(COLOR) == ColorType.DEFAULT) {
            ColorType newColorType = StoolBlock.getColorTypeFromDye(woolDye);
            state = (BlockState)state.m_61124_(COLOR, (Comparable)((Object)newColorType));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            level.m_7731_(pos, state, 3);
            level.m_7260_(pos, state, state, 3);
            return InteractionResult.SUCCESS;
        }
        Item item2 = stack.m_41720_();
        if (item2 instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item2;
            v0 = dyeItem.m_41089_();
        } else {
            v0 = dye = null;
        }
        if (dye != null && state.m_61143_(COLOR) != ColorType.DEFAULT) {
            ColorType newColorType = StoolBlock.getColorTypeFromDye(dye);
            state = (BlockState)state.m_61124_(COLOR, (Comparable)((Object)newColorType));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            level.m_7731_(pos, state, 3);
            level.m_7260_(pos, state, state, 3);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_(ModItems.SHEARS.get()) && state.m_61143_(COLOR) != ColorType.DEFAULT) {
            this.dropCushion(state, level, pos);
            state = (BlockState)state.m_61124_(COLOR, (Comparable)((Object)ColorType.DEFAULT));
            level.m_7731_(pos, state, 3);
            level.m_7260_(pos, state, state, 3);
            return InteractionResult.SUCCESS;
        }
        if (TuckableBlock.tryTuck(state, level, pos, player)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TUCKED, WATERLOGGED, COLOR});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.blank"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.properties"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.dyeable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.lockable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.hammerable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.wrenchable"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.shift"));
        }
        super.m_5871_(stack, level, tooltip, flag);
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new LockableBlockEntity(pos, state);
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean moving) {
        if (!state.m_60713_(newState.m_60734_())) {
            this.dropCushion(state, level, pos);
        }
        super.m_6810_(state, level, pos, newState, moving);
    }

    public void dropCushion(BlockState state, Level level, BlockPos pos) {
        if (state.m_61138_(COLOR) && state.m_61143_(COLOR) != ColorType.DEFAULT) {
            Block block = WoolHelper.getBlock((DyeColor)((ColorType)((Object)state.m_61143_(COLOR))).getDyeColor());
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)(block != null ? block : Blocks.f_50041_)));
        }
    }

    @Override
    public List<Property<?>> getHammerableProperties() {
        return List.of(TUCKED);
    }

    @Override
    public List<Property<?>> getWrenchableProperties() {
        return List.of(FACING);
    }

    @Override
    public BlockState updateAfterCycle(BlockState state, LevelAccessor level, BlockPos pos) {
        return WrenchItem.WrenchableBlock.super.updateAfterCycle(state, level, pos);
    }
}

