/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.List;
import java.util.stream.Stream;
import net.lyivx.ls_furniture.common.blocks.properties.ModBlockStateProperties;
import net.lyivx.ls_furniture.common.items.WrenchItem;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TVBlock
extends Block
implements SimpleWaterloggedBlock,
WrenchItem.WrenchableBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty STAND = ModBlockStateProperties.STAND;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty VARIANT = ModBlockStateProperties.VARIANT;
    protected static final VoxelShape STAND_VS = Stream.of(Block.m_49796_((double)2.0, (double)0.0, (double)9.0, (double)14.0, (double)1.0, (double)13.0), Block.m_49796_((double)7.0, (double)1.0, (double)11.0, (double)9.0, (double)3.0, (double)13.0), Block.m_49796_((double)16.0, (double)3.0, (double)11.0, (double)21.0, (double)19.0, (double)13.0), Block.m_49796_((double)0.0, (double)3.0, (double)11.0, (double)16.0, (double)19.0, (double)13.0), Block.m_49796_((double)-5.0, (double)3.0, (double)11.0, (double)0.0, (double)19.0, (double)13.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape WALL_VS = Stream.of(Block.m_49796_((double)-5.0, (double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)15.0), Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)15.0), Block.m_49796_((double)16.0, (double)0.0, (double)13.0, (double)21.0, (double)16.0, (double)15.0), Block.m_49796_((double)12.0, (double)6.0, (double)15.0, (double)13.0, (double)10.0, (double)16.0), Block.m_49796_((double)3.0, (double)6.0, (double)15.0, (double)4.0, (double)10.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape[] WALL_SHAPE = new VoxelShape[4];
    private static final VoxelShape[] STAND_SHAPE;

    public TVBlock(int defaultBackVariant, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)STAND, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(defaultBackVariant)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, FACING, STAND, VARIANT});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction clickedFace = context.m_43719_();
        boolean isStand = clickedFace == Direction.UP;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)STAND, (Comparable)Boolean.valueOf(isStand));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        boolean isStand = (Boolean)state.m_61143_((Property)STAND);
        if (!isStand) {
            return WALL_SHAPE[direction.m_122416_()];
        }
        return STAND_SHAPE[direction.m_122416_()];
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof WrenchItem) {
            return InteractionResult.FAIL;
        }
        BlockState onState = (BlockState)state.m_61122_((Property)VARIANT);
        level.m_7731_(pos, onState, 3);
        if (player != null && player.m_6144_()) {
            BlockState standState = (BlockState)state.m_61122_((Property)STAND);
            level.m_7731_(pos, standState, 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.blank"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.properties"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.wrenchable"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.shift"));
        }
        super.m_5871_(stack, level, tooltip, flag);
    }

    @Override
    public List<Property<?>> getWrenchableProperties() {
        return List.of(FACING);
    }

    static {
        TVBlock.WALL_SHAPE[0] = ShapeUtil.rotateShape(WALL_VS, Direction.SOUTH);
        TVBlock.WALL_SHAPE[1] = ShapeUtil.rotateShape(WALL_VS, Direction.WEST);
        TVBlock.WALL_SHAPE[2] = ShapeUtil.rotateShape(WALL_VS, Direction.NORTH);
        TVBlock.WALL_SHAPE[3] = ShapeUtil.rotateShape(WALL_VS, Direction.EAST);
        STAND_SHAPE = new VoxelShape[4];
        TVBlock.STAND_SHAPE[0] = ShapeUtil.rotateShape(STAND_VS, Direction.SOUTH);
        TVBlock.STAND_SHAPE[1] = ShapeUtil.rotateShape(STAND_VS, Direction.WEST);
        TVBlock.STAND_SHAPE[2] = ShapeUtil.rotateShape(STAND_VS, Direction.NORTH);
        TVBlock.STAND_SHAPE[3] = ShapeUtil.rotateShape(STAND_VS, Direction.EAST);
    }
}

