/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks.entity;

import dev.architectury.injectables.annotations.PlatformOnly;
import net.lyivx.ls_furniture.registry.ModBlockEntitys;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class PlateBlockEntity
extends BlockEntity
implements Clearable {
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);

    public PlateBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(ModBlockEntitys.PLATE_ENTITY.get(), blockPos, blockState);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18976_((CompoundTag)tag, this.items, (boolean)true);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundtag = new CompoundTag();
        ContainerHelper.m_18976_((CompoundTag)compoundtag, this.items, (boolean)true);
        return compoundtag;
    }

    public boolean placeItem(ItemStack stack, int position) {
        ItemStack itemstack = (ItemStack)this.items.get(position);
        if (!itemstack.m_41619_()) {
            return false;
        }
        this.items.set(position, (Object)stack.m_41620_(stack.m_41613_()));
        this.markUpdated();
        return true;
    }

    public boolean removeItem(int index, Player player, Level level) {
        if (((ItemStack)this.items.get(index)).m_41619_()) {
            return false;
        }
        if (level.m_5776_()) {
            player.m_216990_(SoundEvents.f_12016_);
            return true;
        }
        ItemStack item = ((ItemStack)this.items.get(index)).m_41777_();
        player.m_8061_(EquipmentSlot.MAINHAND, item);
        this.items.set(index, (Object)ItemStack.f_41583_);
        this.markUpdated();
        return true;
    }

    private void markUpdated() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void removeAllItems() {
        boolean update = false;
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            double posX = (double)this.f_58858_.m_123341_() + 0.3 + 0.4 * (double)(i % 2);
            double posY = (double)this.f_58858_.m_123342_() + 1.0;
            double posZ = (double)this.f_58858_.m_123343_() + 0.3 + 0.4 * (double)(i / 2);
            ItemEntity entity = new ItemEntity(this.f_58857_, posX, posY + 0.1, posZ, ((ItemStack)this.items.get(i)).m_41777_());
            this.f_58857_.m_7967_((Entity)entity);
            this.items.set(i, (Object)ItemStack.f_41583_);
            update = true;
        }
        if (update) {
            this.markUpdated();
        }
    }

    @PlatformOnly(value={"forge"})
    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(0, 0, 0), this.f_58858_.m_7918_(1, 2, 1));
    }
}

