/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks.properties;

import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public enum ColorType implements StringRepresentable
{
    WHITE(DyeColor.WHITE),
    LIGHT_GRAY(DyeColor.LIGHT_GRAY),
    GRAY(DyeColor.GRAY),
    BLACK(DyeColor.BLACK),
    BROWN(DyeColor.BROWN),
    RED(DyeColor.RED),
    ORANGE(DyeColor.ORANGE),
    YELLOW(DyeColor.YELLOW),
    LIME(DyeColor.LIME),
    GREEN(DyeColor.GREEN),
    CYAN(DyeColor.CYAN),
    LIGHT_BLUE(DyeColor.LIGHT_BLUE),
    BLUE(DyeColor.BLUE),
    MAGENTA(DyeColor.MAGENTA),
    PURPLE(DyeColor.PURPLE),
    PINK(DyeColor.PINK),
    DEFAULT(null);

    private final DyeColor dyeColor;

    private ColorType(DyeColor dyeColor) {
        this.dyeColor = dyeColor;
    }

    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    public String m_7912_() {
        return this == DEFAULT ? "default" : this.dyeColor.m_41065_();
    }

    public static ColorType fromDyeColor(DyeColor dyeColor) {
        if (dyeColor == null) {
            return DEFAULT;
        }
        for (ColorType colorType : ColorType.values()) {
            if (colorType.getDyeColor() != dyeColor) continue;
            return colorType;
        }
        throw new IllegalArgumentException("No ColorType found for DyeColor: " + String.valueOf(dyeColor));
    }

    public static ColorType fromId(int id) {
        if (id == -1) {
            return DEFAULT;
        }
        for (ColorType colorType : ColorType.values()) {
            if (colorType == DEFAULT || colorType.getDyeColor().m_41060_() != id) continue;
            return colorType;
        }
        throw new IllegalArgumentException("No ColorType found for id: " + id);
    }

    public ItemStack getDyeItemStack() {
        if (this == DEFAULT) {
            return ItemStack.f_41583_;
        }
        switch (this.dyeColor) {
            case WHITE: {
                return new ItemStack((ItemLike)Items.f_42535_);
            }
            case ORANGE: {
                return new ItemStack((ItemLike)Items.f_42536_);
            }
            case MAGENTA: {
                return new ItemStack((ItemLike)Items.f_42537_);
            }
            case LIGHT_BLUE: {
                return new ItemStack((ItemLike)Items.f_42538_);
            }
            case YELLOW: {
                return new ItemStack((ItemLike)Items.f_42539_);
            }
            case LIME: {
                return new ItemStack((ItemLike)Items.f_42540_);
            }
            case PINK: {
                return new ItemStack((ItemLike)Items.f_42489_);
            }
            case GRAY: {
                return new ItemStack((ItemLike)Items.f_42490_);
            }
            case LIGHT_GRAY: {
                return new ItemStack((ItemLike)Items.f_42491_);
            }
            case CYAN: {
                return new ItemStack((ItemLike)Items.f_42492_);
            }
            case PURPLE: {
                return new ItemStack((ItemLike)Items.f_42493_);
            }
            case BLUE: {
                return new ItemStack((ItemLike)Items.f_42494_);
            }
            case BROWN: {
                return new ItemStack((ItemLike)Items.f_42495_);
            }
            case GREEN: {
                return new ItemStack((ItemLike)Items.f_42496_);
            }
            case RED: {
                return new ItemStack((ItemLike)Items.f_42497_);
            }
            case BLACK: {
                return new ItemStack((ItemLike)Items.f_42498_);
            }
        }
        throw new IllegalStateException("Unexpected DyeColor: " + String.valueOf(this.dyeColor));
    }
}

