/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.items;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.lyivx.ls_furniture.common.blocks.OvenVentBlock;
import net.lyivx.ls_furniture.registry.ModBlocks;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class OvenVentItem
extends BlockItem {
    private static final Map<Block, Supplier<Block>> CABINET_BLOCKS = new HashMap<Block, Supplier<Block>>();

    public OvenVentItem(Block blockPlace, Item.Properties properties) {
        super(blockPlace, properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        Supplier<Block> cabinetBlockSupplier = CABINET_BLOCKS.get(block);
        if (cabinetBlockSupplier != null) {
            level.m_7731_(pos, (BlockState)cabinetBlockSupplier.get().m_49966_().m_61124_((Property)OvenVentBlock.FACING, (Comparable)((Direction)state.m_61143_((Property)OvenVentBlock.FACING))), 3);
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = this.m_40576_(new BlockPlaceContext(context));
        if (!interactionResult.m_19077_() && this.m_41472_()) {
            InteractionResult interactionResult2 = this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
            return interactionResult2 == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : interactionResult2;
        }
        return interactionResult;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.oven_vent"));
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.blank"));
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.properties"));
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.wrenchable"));
        } else {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.shift"));
        }
        super.m_7373_(stack, level, tooltipComponents, flag);
    }

    static {
        CABINET_BLOCKS.put((Block)ModBlocks.OAK_CABINET.get(), ModBlocks.OAK_CABINET_OVEN_VENT::get);
        CABINET_BLOCKS.put((Block)ModBlocks.SPRUCE_CABINET.get(), ModBlocks.SPRUCE_CABINET_OVEN_VENT::get);
        CABINET_BLOCKS.put((Block)ModBlocks.BIRCH_CABINET.get(), ModBlocks.BIRCH_CABINET_OVEN_VENT::get);
        CABINET_BLOCKS.put((Block)ModBlocks.JUNGLE_CABINET.get(), ModBlocks.JUNGLE_CABINET_OVEN_VENT::get);
        CABINET_BLOCKS.put((Block)ModBlocks.ACACIA_CABINET.get(), ModBlocks.ACACIA_CABINET_OVEN_VENT::get);
        CABINET_BLOCKS.put((Block)ModBlocks.DARK_OAK_CABINET.get(), ModBlocks.DARK_OAK_CABINET_OVEN_VENT::get);
        CABINET_BLOCKS.put((Block)ModBlocks.MANGROVE_CABINET.get(), ModBlocks.MANGROVE_CABINET_OVEN_VENT::get);
        CABINET_BLOCKS.put((Block)ModBlocks.CHERRY_CABINET.get(), ModBlocks.CHERRY_CABINET_OVEN_VENT::get);
        CABINET_BLOCKS.put((Block)ModBlocks.BAMBOO_CABINET.get(), ModBlocks.BAMBOO_CABINET_OVEN_VENT::get);
        CABINET_BLOCKS.put((Block)ModBlocks.CRIMSON_CABINET.get(), ModBlocks.CRIMSON_CABINET_OVEN_VENT::get);
        CABINET_BLOCKS.put((Block)ModBlocks.WARPED_CABINET.get(), ModBlocks.WARPED_CABINET_OVEN_VENT::get);
    }
}

