/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.utils.block;

import net.lyivx.ls_furniture.common.blocks.ChairBlock;
import net.lyivx.ls_furniture.common.blocks.CounterIslandBlock;
import net.lyivx.ls_furniture.common.blocks.ShelfBlock;
import net.lyivx.ls_furniture.common.blocks.TableBlock;
import net.lyivx.ls_furniture.common.blocks.properties.HorizontalConnectionType;
import net.lyivx.ls_furniture.common.blocks.properties.ModBlockStateProperties;
import net.lyivx.ls_furniture.common.entity.SeatEntity;
import net.lyivx.ls_furniture.registry.ModBlocksTags;
import net.lyivx.ls_furniture.registry.ModSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.AABB;

public interface TuckableBlock {
    public static final BooleanProperty TUCKED = ModBlockStateProperties.TUCKED;

    public static boolean tryTuck(BlockState state, Level level, BlockPos pos, Player player) {
        boolean tucked = (Boolean)state.m_61143_((Property)TUCKED);
        if (!player.m_6047_() || !TuckableBlock.canTuckUnderBlockInfront(state, level, pos)) {
            return false;
        }
        if (tucked) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)TUCKED, (Comparable)Boolean.valueOf(false)));
            level.m_247517_(null, pos, ModSoundEvents.CHAIR_UNTUCK.get(), SoundSource.BLOCKS);
            return true;
        }
        if (!TuckableBlock.isBlockedFromTucking(state, level, pos)) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)TUCKED, (Comparable)Boolean.valueOf(true)));
            level.m_247517_(null, pos, ModSoundEvents.CHAIR_TUCK.get(), SoundSource.BLOCKS);
            return true;
        }
        return false;
    }

    public static boolean canTuckUnderBlockInfront(BlockState state, Level level, BlockPos pos) {
        Direction forward = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        BlockState forwardState = level.m_8055_(pos.m_121945_(forward));
        Block forwardBlock = forwardState.m_60734_();
        if (forwardBlock instanceof ShelfBlock) {
            return forwardState.m_61143_(ShelfBlock.SHAPE) == HorizontalConnectionType.MIDDLE || forwardState.m_61143_((Property)BlockStateProperties.f_61374_) != forward;
        }
        if (forwardBlock instanceof SlabBlock) {
            return forwardState.m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP;
        }
        if (forwardBlock instanceof TableBlock) {
            return true;
        }
        if (forwardBlock instanceof CounterIslandBlock) {
            return true;
        }
        if (forwardBlock instanceof StairBlock) {
            StairsShape shape = (StairsShape)forwardState.m_61143_((Property)StairBlock.f_56843_);
            Direction facing_dir = (Direction)forwardState.m_61143_((Property)BlockStateProperties.f_61374_);
            return forwardState.m_61143_((Property)StairBlock.f_56842_) == Half.TOP && (forward == facing_dir || shape == StairsShape.OUTER_LEFT && forward == facing_dir.m_122428_() || shape == StairsShape.OUTER_RIGHT && forward == facing_dir.m_122427_());
        }
        return forwardState.m_204336_(ModBlocksTags.CHAIRS_TUCKABLE_UNDER);
    }

    public static boolean isBlockedFromTucking(BlockState state, Level level, BlockPos pos) {
        if (!level.m_45976_(SeatEntity.class, new AABB(pos)).isEmpty()) {
            return true;
        }
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        BlockState left = level.m_8055_(pos.m_121945_(facing).m_121945_(facing.m_122428_()));
        BlockState right = level.m_8055_(pos.m_121945_(facing).m_121945_(facing.m_122427_()));
        if (left.m_60734_() instanceof ChairBlock && ((Boolean)left.m_61143_((Property)TUCKED)).booleanValue() && left.m_61143_((Property)BlockStateProperties.f_61374_) == facing.m_122427_()) {
            return true;
        }
        return right.m_60734_() instanceof ChairBlock && (Boolean)right.m_61143_((Property)TUCKED) != false && right.m_61143_((Property)BlockStateProperties.f_61374_) == facing.m_122428_();
    }
}

