/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.model.turtle;

import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Transformation;
import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.client.platform.ClientPlatformHelper;
import dan200.computercraft.client.render.TurtleBlockEntityRenderer;
import dan200.computercraft.client.turtle.TurtleUpgradeModellers;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import dan200.computercraft.shared.util.Holiday;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public final class TurtleModelParts<T> {
    private static final Transformation identity;
    private static final Transformation flip;
    private final BakedModel familyModel;
    private final BakedModel colourModel;
    private final Function<TransformedModel, BakedModel> transformer;
    private final Function<Combination, T> buildModel;
    private final Map<TransformedModel, BakedModel> transformCache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(30L, TimeUnit.SECONDS).build().asMap();
    private final Map<Combination, T> modelCache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(30L, TimeUnit.SECONDS).build().asMap();

    public TurtleModelParts(BakedModel familyModel, BakedModel colourModel, ModelTransformer transformer, Function<List<BakedModel>, T> combineModel) {
        this.familyModel = familyModel;
        this.colourModel = colourModel;
        this.transformer = x -> transformer.transform(x.getModel(), x.getMatrix());
        this.buildModel = x -> combineModel.apply(this.buildModel((Combination)x));
    }

    public T getModel(ItemStack stack) {
        Combination combination = this.getCombination(stack);
        T existing = this.modelCache.get(combination);
        if (existing != null) {
            return existing;
        }
        Combination newCombination = combination.copy();
        T newModel = this.buildModel.apply(newCombination);
        this.modelCache.put(newCombination, newModel);
        return newModel;
    }

    private Combination getCombination(ItemStack stack) {
        boolean christmas = Holiday.getCurrent() == Holiday.CHRISTMAS;
        Item item = stack.m_41720_();
        if (!(item instanceof TurtleItem)) {
            return new Combination(false, null, null, null, christmas, false);
        }
        TurtleItem turtle = (TurtleItem)item;
        int colour = turtle.getColour(stack);
        UpgradeData<ITurtleUpgrade> leftUpgrade = turtle.getUpgradeWithData(stack, TurtleSide.LEFT);
        UpgradeData<ITurtleUpgrade> rightUpgrade = turtle.getUpgradeWithData(stack, TurtleSide.RIGHT);
        ResourceLocation overlay = turtle.getOverlay(stack);
        String label = turtle.getLabel(stack);
        boolean flip = label != null && (label.equals("Dinnerbone") || label.equals("Grumm"));
        return new Combination(colour != -1, leftUpgrade, rightUpgrade, overlay, christmas, flip);
    }

    private List<BakedModel> buildModel(Combination combo) {
        Minecraft mc = Minecraft.m_91087_();
        ModelManager modelManager = mc.m_91291_().m_115103_().m_109393_();
        Transformation transformation = combo.flip ? flip : identity;
        ArrayList<BakedModel> parts = new ArrayList<BakedModel>(4);
        parts.add(this.transform(combo.colour() ? this.colourModel : this.familyModel, transformation));
        ResourceLocation overlayModelLocation = TurtleBlockEntityRenderer.getTurtleOverlayModel(combo.overlay(), combo.christmas());
        if (overlayModelLocation != null) {
            parts.add(this.transform(ClientPlatformHelper.get().getModel(modelManager, overlayModelLocation), transformation));
        }
        this.addUpgrade(parts, transformation, TurtleSide.LEFT, combo.leftUpgrade());
        this.addUpgrade(parts, transformation, TurtleSide.RIGHT, combo.rightUpgrade());
        return parts;
    }

    private void addUpgrade(List<BakedModel> parts, Transformation transformation, TurtleSide side, @Nullable UpgradeData<ITurtleUpgrade> upgrade) {
        if (upgrade == null) {
            return;
        }
        TransformedModel model = TurtleUpgradeModellers.getModel(upgrade.upgrade(), upgrade.data(), side);
        parts.add(this.transform(model.getModel(), transformation.m_121096_(model.getMatrix())));
    }

    private BakedModel transform(BakedModel model, Transformation transformation) {
        if (transformation.equals((Object)Transformation.m_121093_())) {
            return model;
        }
        return this.transformCache.computeIfAbsent(new TransformedModel(model, transformation), this.transformer);
    }

    static {
        PoseStack stack = new PoseStack();
        stack.m_252880_(0.5f, 0.5f, 0.5f);
        stack.m_85841_(1.0f, -1.0f, 1.0f);
        stack.m_252880_(-0.5f, -0.5f, -0.5f);
        identity = Transformation.m_121093_();
        flip = new Transformation(stack.m_85850_().m_252922_());
    }

    public static interface ModelTransformer {
        public BakedModel transform(BakedModel var1, Transformation var2);
    }

    private record Combination(boolean colour, @Nullable UpgradeData<ITurtleUpgrade> leftUpgrade, @Nullable UpgradeData<ITurtleUpgrade> rightUpgrade, @Nullable ResourceLocation overlay, boolean christmas, boolean flip) {
        Combination copy() {
            if (this.leftUpgrade == null && this.rightUpgrade == null) {
                return this;
            }
            return new Combination(this.colour, UpgradeData.copyOf(this.leftUpgrade), UpgradeData.copyOf(this.rightUpgrade), this.overlay, this.christmas, this.flip);
        }
    }
}

