/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.recipes;

import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.media.items.PrintoutItem;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.platform.RecipeIngredients;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public final class PrintoutRecipe
extends CustomRecipe {
    private final Ingredient leather;
    private final Ingredient string;

    public PrintoutRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
        RecipeIngredients ingredients = PlatformHelper.get().getRecipeIngredients();
        this.leather = ingredients.leather();
        this.string = ingredients.string();
    }

    public boolean m_8004_(int x, int y) {
        return x >= 3 && y >= 3;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return PrintoutItem.createMultipleFromTitleAndText(null, null, null);
    }

    public boolean matches(CraftingContainer inventory, Level world) {
        return !this.assemble(inventory, world.m_9598_()).m_41619_();
    }

    public ItemStack assemble(CraftingContainer inventory, RegistryAccess registryAccess) {
        int numPages = 0;
        int numPrintouts = 0;
        ItemStack[] printouts = null;
        boolean stringFound = false;
        boolean leatherFound = false;
        boolean printoutFound = false;
        for (int y = 0; y < inventory.m_39346_(); ++y) {
            for (int x = 0; x < inventory.m_39347_(); ++x) {
                ItemStack stack = inventory.m_8020_(x + y * inventory.m_39347_());
                if (stack.m_41619_()) continue;
                if (stack.m_150930_((Item)ModRegistry.Items.PRINTED_PAGE.get()) || stack.m_150930_((Item)ModRegistry.Items.PRINTED_PAGES.get())) {
                    if (printouts == null) {
                        printouts = new ItemStack[9];
                    }
                    printouts[numPrintouts] = stack;
                    numPages += PrintoutItem.getPageCount(stack);
                    ++numPrintouts;
                    printoutFound = true;
                    continue;
                }
                if (stack.m_41720_() == Items.f_42516_) {
                    if (printouts == null) {
                        printouts = new ItemStack[9];
                    }
                    printouts[numPrintouts] = stack;
                    ++numPages;
                    ++numPrintouts;
                    continue;
                }
                if (this.string.test(stack) && !stringFound) {
                    stringFound = true;
                    continue;
                }
                if (this.leather.test(stack) && !leatherFound) {
                    leatherFound = true;
                    continue;
                }
                return ItemStack.f_41583_;
            }
        }
        if (numPages <= 16 && stringFound && printoutFound && numPrintouts >= (leatherFound ? 1 : 2)) {
            if (printouts == null) {
                throw new IllegalStateException("Printouts must be non-null");
            }
            String[] text = new String[numPages * 21];
            String[] colours = new String[numPages * 21];
            int line = 0;
            for (int printout = 0; printout < numPrintouts; ++printout) {
                ItemStack stack = printouts[printout];
                if (stack.m_41720_() instanceof PrintoutItem) {
                    String[] pageText = PrintoutItem.getText(printouts[printout]);
                    String[] pageColours = PrintoutItem.getColours(printouts[printout]);
                    for (int pageLine = 0; pageLine < pageText.length; ++pageLine) {
                        text[line] = pageText[pageLine];
                        colours[line] = pageColours[pageLine];
                        ++line;
                    }
                    continue;
                }
                for (int pageLine = 0; pageLine < 21; ++pageLine) {
                    text[line] = "";
                    colours[line] = "";
                    ++line;
                }
            }
            String title = null;
            if (printouts[0].m_41720_() instanceof PrintoutItem) {
                title = PrintoutItem.getTitle(printouts[0]);
            }
            if (leatherFound) {
                return PrintoutItem.createBookFromTitleAndText(title, text, colours);
            }
            return PrintoutItem.createMultipleFromTitleAndText(title, text, colours);
        }
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRegistry.RecipeSerializers.PRINTOUT.get();
    }
}

