/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.integration.forge;

import com.blackgear.platform.common.integration.BlockIntegration;
import com.blackgear.platform.common.integration.BlockInteraction;
import java.util.function.Consumer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class BlockIntegrationImpl {
    public static void registerIntegrations(Consumer<BlockIntegration.Event> listener) {
        final IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BlockIntegration.Event integration = new BlockIntegration.Event(){

            @Override
            public void registerBlockInteraction(BlockInteraction interaction) {
                bus.addListener(event -> {
                    InteractionResult result = interaction.onUse(new UseOnContext(event.getEntity(), event.getHand(), event.getHitVec()));
                    if (result != InteractionResult.PASS) {
                        event.setCanceled(true);
                        event.setCancellationResult(result);
                    }
                });
            }

            @Override
            public void registerFuelItem(ItemLike item, int burnTime) {
                MinecraftForge.EVENT_BUS.addListener(event -> {
                    if (event.getItemStack().m_150930_(item.m_5456_())) {
                        event.setBurnTime(burnTime);
                    }
                });
            }
        };
        listener.accept(integration);
    }
}

