/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.helpers;

import java.awt.Color;
import java.util.List;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import team.lodestar.lodestone.systems.easing.Easing;

public class ColorHelper {
    public static Color getColor(int decimal) {
        return new Color(decimal);
    }

    public static void RGBToHSV(Color color, float[] hsv) {
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsv);
    }

    public static int getColor(Color color) {
        return FastColor.ARGB32.m_13660_((int)color.getAlpha(), (int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
    }

    public static int getColor(int r, int g, int b) {
        return FastColor.ARGB32.m_13660_((int)255, (int)r, (int)g, (int)b);
    }

    public static int getColor(int r, int g, int b, int a) {
        return FastColor.ARGB32.m_13660_((int)a, (int)r, (int)g, (int)b);
    }

    public static int getColor(float r, float g, float b, float a) {
        return FastColor.ARGB32.m_13660_((int)((int)(a * 255.0f)), (int)((int)(r * 255.0f)), (int)((int)(g * 255.0f)), (int)((int)(b * 255.0f)));
    }

    public static Color colorLerp(Easing easing, float pct, Color startColor, Color endColor) {
        pct = Mth.m_14036_((float)pct, (float)0.0f, (float)1.0f);
        int br = startColor.getRed();
        int bg = startColor.getGreen();
        int bb = startColor.getBlue();
        int dr = endColor.getRed();
        int dg = endColor.getGreen();
        int db = endColor.getBlue();
        float ease = easing.ease(pct, 0.0f, 1.0f, 1.0f);
        int red = (int)Mth.m_14179_((float)ease, (float)br, (float)dr);
        int green = (int)Mth.m_14179_((float)ease, (float)bg, (float)dg);
        int blue = (int)Mth.m_14179_((float)ease, (float)bb, (float)db);
        return new Color(Mth.m_14045_((int)red, (int)0, (int)255), Mth.m_14045_((int)green, (int)0, (int)255), Mth.m_14045_((int)blue, (int)0, (int)255));
    }

    public static Color colorLerp(Easing easing, float pct, float min, float max, Color startColor, Color endColor) {
        pct = Mth.m_14036_((float)pct, (float)0.0f, (float)1.0f);
        int br = startColor.getRed();
        int bg = startColor.getGreen();
        int bb = startColor.getBlue();
        int dr = endColor.getRed();
        int dg = endColor.getGreen();
        int db = endColor.getBlue();
        float ease = easing.ease(pct, min, max, 1.0f);
        int red = (int)Mth.m_14179_((float)ease, (float)br, (float)dr);
        int green = (int)Mth.m_14179_((float)ease, (float)bg, (float)dg);
        int blue = (int)Mth.m_14179_((float)ease, (float)bb, (float)db);
        return new Color(Mth.m_14045_((int)red, (int)0, (int)255), Mth.m_14045_((int)green, (int)0, (int)255), Mth.m_14045_((int)blue, (int)0, (int)255));
    }

    public static Color multicolorLerp(Easing easing, float pct, Color ... colors) {
        return ColorHelper.multicolorLerp(easing, pct, List.of(colors));
    }

    public static Color multicolorLerp(Easing easing, float pct, List<Color> colors) {
        pct = Mth.m_14036_((float)pct, (float)0.0f, (float)1.0f);
        int colorCount = colors.size() - 1;
        float lerp = easing.ease(pct, 0.0f, 1.0f, 1.0f);
        float colorIndex = (float)colorCount * lerp;
        int index = (int)Mth.m_14036_((float)colorIndex, (float)0.0f, (float)colorCount);
        Color color = colors.get(index);
        Color nextColor = index == colorCount ? color : colors.get(index + 1);
        return ColorHelper.colorLerp(easing, colorIndex - (float)((int)colorIndex), color, nextColor);
    }

    public static Color multicolorLerp(Easing easing, float pct, float min, float max, Color ... colors) {
        return ColorHelper.multicolorLerp(easing, pct, min, max, List.of(colors));
    }

    public static Color multicolorLerp(Easing easing, float pct, float min, float max, List<Color> colors) {
        pct = Mth.m_14036_((float)pct, (float)0.0f, (float)1.0f);
        int colorCount = colors.size() - 1;
        float lerp = easing.ease(pct, 0.0f, 1.0f, 1.0f);
        float colorIndex = (float)colorCount * lerp;
        int index = (int)Mth.m_14036_((float)colorIndex, (float)0.0f, (float)colorCount);
        Color color = colors.get(index);
        Color nextColor = index == colorCount ? color : colors.get(index + 1);
        return ColorHelper.colorLerp(easing, colorIndex - (float)((int)colorIndex), min, max, nextColor, color);
    }

    public static Color darker(Color color, int times) {
        return ColorHelper.darker(color, times, 0.7f);
    }

    public static Color darker(Color color, int power, float factor) {
        float FACTOR = (float)Math.pow(factor, power);
        return new Color(Math.max((int)((float)color.getRed() * FACTOR), 0), Math.max((int)((float)color.getGreen() * FACTOR), 0), Math.max((int)((float)color.getBlue() * FACTOR), 0), color.getAlpha());
    }

    public static Color brighter(Color color, int power) {
        return ColorHelper.brighter(color, power, 0.7f);
    }

    public static Color brighter(Color color, int power, float factor) {
        float FACTOR = (float)Math.pow(factor, power);
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int alpha = color.getAlpha();
        int i = (int)(1.0 / (1.0 - (double)FACTOR));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i, alpha);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((float)r / FACTOR), 255), Math.min((int)((float)g / FACTOR), 255), Math.min((int)((float)b / FACTOR), 255), alpha);
    }
}

