/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.network.worldevent;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import team.lodestar.lodestone.capability.LodestoneWorldDataCapability;
import team.lodestar.lodestone.systems.network.LodestoneClientPacket;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class UpdateWorldEventPacket
extends LodestoneClientPacket {
    private UUID uuid;
    private CompoundTag eventData;

    public UpdateWorldEventPacket(UUID uuid, CompoundTag eventData) {
        this.uuid = uuid;
        this.eventData = eventData;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid);
        buf.m_130079_(this.eventData);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(Supplier<NetworkEvent.Context> context) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            level.getCapability(LodestoneWorldDataCapability.CAPABILITY).ifPresent(capability -> {
                for (WorldEventInstance instance : capability.activeWorldEvents) {
                    if (!instance.uuid.equals(this.uuid)) continue;
                    instance.deserializeNBT(this.eventData);
                    break;
                }
            });
        }
    }

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, UpdateWorldEventPacket.class, UpdateWorldEventPacket::encode, UpdateWorldEventPacket::decode, LodestoneClientPacket::handle);
    }

    public static UpdateWorldEventPacket decode(FriendlyByteBuf buf) {
        return new UpdateWorldEventPacket(buf.m_130259_(), buf.m_130260_());
    }
}

