/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseRouter;
import org.jetbrains.annotations.NotNull;

public enum NoiseRouterTarget implements StringRepresentable
{
    BARRIER("barrier", NoiseRouter::f_209378_),
    FLUID_LEVEL_FLOODEDNESS("fluid_level_floodedness", NoiseRouter::f_209379_),
    FLUID_LEVEL_SPREAD("fluid_level_spread", NoiseRouter::f_209380_),
    LAVA("lava", NoiseRouter::f_209381_),
    TEMPERATURE("temperature", NoiseRouter::f_209384_),
    VEGETATION("vegetation", NoiseRouter::f_224392_),
    CONTINENTS("continents", NoiseRouter::f_209386_),
    EROSION("erosion", NoiseRouter::f_209387_),
    DEPTH("depth", NoiseRouter::f_209388_),
    RIDGES("ridges", NoiseRouter::f_209389_),
    INITIAL_DENSITY("initial_density_without_jaggedness", NoiseRouter::f_209390_),
    FINAL_DENSITY("final_density", NoiseRouter::f_209391_),
    VEIN_TOGGLE("vein_toggle", NoiseRouter::f_209392_),
    VEIN_RIDGED("vein_ridged", NoiseRouter::f_209393_),
    VEIN_GAP("vein_gap", NoiseRouter::f_209394_);

    public static final Codec<NoiseRouterTarget> CODEC;
    private final String name;
    private final Function<NoiseRouter, DensityFunction> getter;

    private NoiseRouterTarget(String name, Function<NoiseRouter, DensityFunction> getter) {
        this.name = name;
        this.getter = getter;
    }

    public DensityFunction getDensityFunction(NoiseRouter router) {
        return this.getter.apply(router);
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.m_216439_(NoiseRouterTarget::values);
    }
}

