/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.integration.create.recipe.deployer;

import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.config.ModConfig;
import someassemblyrequired.ingredient.Ingredients;
import someassemblyrequired.item.sandwich.SandwichItem;
import someassemblyrequired.item.sandwich.SandwichItemHandler;
import someassemblyrequired.registry.ModItems;
import someassemblyrequired.registry.ModTags;

public class SandwichDeployingRecipe {
    private static final ResourceLocation RECIPE_ID = SomeAssemblyRequired.id("sandwich_deploying");

    public static Optional<DeployerApplicationRecipe> createRecipe(RecipeWrapper inventory) {
        if (!SandwichDeployingRecipe.matches(inventory)) {
            return Optional.empty();
        }
        return Optional.of(SandwichDeployingRecipe.createRecipe(inventory.m_8020_(0), inventory.m_8020_(1)));
    }

    public static boolean matches(RecipeWrapper inventory) {
        ItemStack item = inventory.m_8020_(0);
        if (item.m_41619_() || !item.m_204117_(ModTags.SANDWICH_BREAD) && !item.m_150930_((Item)ModItems.SANDWICH.get())) {
            return false;
        }
        ItemStack ingredient = inventory.m_8020_(1);
        if (!Ingredients.canAddToSandwich(ingredient) || ingredient.m_150930_((Item)ModItems.SANDWICH.get())) {
            return false;
        }
        return (Integer)ModConfig.server.maximumSandwichHeight.get() >= Ingredients.getHeight(ingredient) + SandwichItemHandler.get((ICapabilityProvider)item).map(SandwichItemHandler::getTotalHeight).orElse(Ingredients.getHeight(item));
    }

    public static DeployerApplicationRecipe createRecipe(ItemStack sandwich, ItemStack ingredient) {
        sandwich = sandwich.m_41777_();
        sandwich.m_41764_(1);
        ingredient = ingredient.m_41777_();
        ingredient.m_41764_(1);
        ItemStack container = Ingredients.getContainer(ingredient);
        ItemStack result = SandwichItem.of(sandwich, ingredient);
        return (DeployerApplicationRecipe)new ProcessingRecipeBuilder(DeployerApplicationRecipe::new, RECIPE_ID).withItemOutputs(new ProcessingOutput[]{new ProcessingOutput(result, 1.0f), container.m_41619_() ? ProcessingOutput.EMPTY : new ProcessingOutput(container, 1.0f)}).build();
    }
}

