/*
 * Decompiled with CFR 0.152.
 */
package appeng.siteexport;

import appeng.core.AppEngClient;
import appeng.core.definitions.AEBlocks;
import appeng.items.tools.powered.MatterCannonItem;
import appeng.recipes.entropy.EntropyRecipe;
import appeng.recipes.handlers.ChargerRecipe;
import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.recipes.mattercannon.MatterCannonAmmo;
import appeng.recipes.transform.TransformCircumstance;
import appeng.recipes.transform.TransformRecipe;
import appeng.siteexport.FabricClientCommandSource;
import guideme.Guide;
import guideme.internal.siteexport.SiteExporter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import org.jetbrains.annotations.Nullable;

public class AESiteExporter
extends SiteExporter {
    public AESiteExporter(Minecraft client, Path outputFolder, Guide guide) {
        super(client, outputFolder, guide);
        this.referenceItem((ItemLike)Items.f_41962_);
        this.referenceItem(AEBlocks.INSCRIBER);
        this.referenceFluid((Fluid)Fluids.f_76193_);
        this.referenceFluid((Fluid)Fluids.f_76195_);
        this.referenceItem((ItemLike)Items.f_41996_);
        this.referenceItem((ItemLike)Blocks.f_50625_);
    }

    public static void initialize() {
        if (Boolean.getBoolean("appeng.runGuideExportAndExit")) {
            Path outputFolder = Paths.get(System.getProperty("appeng.guideExportFolder"), new String[0]);
            MinecraftForge.EVENT_BUS.addListener(evt -> {
                if (evt.phase == TickEvent.Phase.END) {
                    Minecraft client = Minecraft.m_91087_();
                    if (client.m_91265_() instanceof LoadingOverlay) {
                        return;
                    }
                    Guide guide = AppEngClient.instance().getGuide();
                    try {
                        new AESiteExporter(Minecraft.m_91087_(), outputFolder, guide).exportOnNextTickAndExit();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
            });
        }
    }

    public static void export(FabricClientCommandSource source) {
        Guide guide = AppEngClient.instance().getGuide();
        try {
            Path outputFolder = Paths.get("guide-export", new String[0]).toAbsolutePath();
            AESiteExporter.export(Minecraft.m_91087_(), outputFolder, guide);
            source.sendFeedback((Component)Component.m_237113_((String)"Guide data exported to ").m_7220_((Component)Component.m_237113_((String)("[" + outputFolder.getFileName().toString() + "]")).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, outputFolder.toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to open export folder"))).m_131152_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GREEN}))));
        }
        catch (Exception e) {
            e.printStackTrace();
            source.sendError((Component)Component.m_237113_((String)e.toString()));
        }
    }

    private static void export(Minecraft client, Path outputFolder, Guide guide) throws Exception {
        new AESiteExporter(client, outputFolder, guide).exportOnNextTickAndExit();
    }

    @Nullable
    protected Map<String, Object> getCustomRecipeFields(ResourceLocation id, Recipe<?> recipe) {
        if (recipe instanceof InscriberRecipe) {
            InscriberRecipe inscriberRecipe = (InscriberRecipe)recipe;
            return this.addRecipe(inscriberRecipe);
        }
        if (recipe instanceof TransformRecipe) {
            TransformRecipe transformRecipe = (TransformRecipe)recipe;
            return this.addRecipe(transformRecipe);
        }
        if (recipe instanceof EntropyRecipe) {
            EntropyRecipe entropyRecipe = (EntropyRecipe)recipe;
            return this.addRecipe(entropyRecipe);
        }
        if (recipe instanceof MatterCannonAmmo) {
            MatterCannonAmmo ammoRecipe = (MatterCannonAmmo)recipe;
            return this.addRecipe(ammoRecipe);
        }
        if (recipe instanceof ChargerRecipe) {
            ChargerRecipe chargerRecipe = (ChargerRecipe)recipe;
            return this.addRecipe(chargerRecipe);
        }
        return null;
    }

    private Map<String, Object> addRecipe(InscriberRecipe recipe) {
        ItemStack resultItem = recipe.getResultItem();
        return Map.of("top", recipe.getTopOptional(), "middle", recipe.getMiddleInput(), "bottom", recipe.getBottomOptional(), "resultItem", resultItem.m_41720_(), "resultCount", resultItem.m_41613_(), "consumesTopAndBottom", recipe.getProcessType() == InscriberProcessType.PRESS);
    }

    private Map<String, Object> addRecipe(TransformRecipe recipe) {
        HashMap<String, Object> circumstanceJson = new HashMap<String, Object>();
        TransformCircumstance circumstance = recipe.circumstance;
        if (circumstance.isExplosion()) {
            circumstanceJson.put("type", "explosion");
        } else if (circumstance.isFluid()) {
            circumstanceJson.put("type", "fluid");
            if (recipe.circumstance.isFluidTag((TagKey<Fluid>)FluidTags.f_13131_)) {
                circumstanceJson.put("fluids", List.of(Fluids.f_76193_));
            } else {
                circumstanceJson.put("fluids", circumstance.getFluidsForRendering());
            }
        } else {
            throw new IllegalStateException("Unknown circumstance: " + String.valueOf(circumstance.toJson()));
        }
        return Map.of("resultItem", recipe.m_8043_(null), "ingredients", recipe.m_7527_(), "circumstance", circumstanceJson);
    }

    private Map<String, Object> addRecipe(EntropyRecipe recipe) {
        return Map.of("mode", recipe.getMode().name().toLowerCase(Locale.ROOT));
    }

    private Map<String, Object> addRecipe(MatterCannonAmmo recipe) {
        return Map.of("ammo", recipe.getAmmo(), "damage", MatterCannonItem.getDamageFromPenetration(recipe.getWeight()));
    }

    private Map<String, Object> addRecipe(ChargerRecipe recipe) {
        return Map.of("resultItem", recipe.getResultItem(), "ingredient", recipe.getIngredient());
    }
}

