/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline;

import com.samsthenerd.inline.api.InlineAPI;
import com.samsthenerd.inline.api.data.EntityInlineData;
import com.samsthenerd.inline.api.data.ItemInlineData;
import com.samsthenerd.inline.api.data.ModIconData;
import com.samsthenerd.inline.api.data.PlayerHeadData;
import com.samsthenerd.inline.api.data.SpriteInlineData;
import com.samsthenerd.inline.api.matching.InlineMatch;
import com.samsthenerd.inline.api.matching.MatcherInfo;
import com.samsthenerd.inline.api.matching.RegexMatcher;
import com.samsthenerd.inline.xplat.XPlatInstances;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Inline {
    public static final String MOD_ID = "inline";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"inline");
    private static XPlatInstances xPlats;
    private static final Map<String, String> EQUIPMENT_ALIASES;

    public static XPlatInstances getXPlats() {
        return xPlats;
    }

    public static final void logPrint(String message) {
        LOGGER.info(message);
    }

    public static void onInitialize(XPlatInstances xPlats) {
        Inline.xPlats = xPlats;
        Inline.registerDataTypes();
        Inline.addChatMatchers();
    }

    private static void registerDataTypes() {
        InlineAPI.INSTANCE.addDataType(EntityInlineData.EntityDataType.INSTANCE);
        InlineAPI.INSTANCE.addDataType(ItemInlineData.ItemDataType.INSTANCE);
        InlineAPI.INSTANCE.addDataType(ModIconData.ModIconDataType.INSTANCE);
        InlineAPI.INSTANCE.addDataType(PlayerHeadData.PlayerHeadDataType.INSTANCE);
        InlineAPI.INSTANCE.addDataType(SpriteInlineData.SpriteDataType.INSTANCE);
    }

    private static void addChatMatchers() {
        ResourceLocation showOffID = ResourceLocation.m_214293_((String)MOD_ID, (String)"showoff");
        RegexMatcher.ChatStandard showOffMatcher = new RegexMatcher.ChatStandard("show", RegexMatcher.Standard.IDENTIFIER_REGEX_INSENSITIVE, showOffID, (whatToShow, ctx) -> {
            ItemStack stack = null;
            whatToShow = EQUIPMENT_ALIASES.getOrDefault(whatToShow, (String)whatToShow);
            try {
                stack = ctx.getChatSender().m_6844_(EquipmentSlot.m_20747_((String)whatToShow));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stack == null || stack.m_41619_()) {
                stack = new ItemStack((ItemLike)Items.f_42127_);
                stack.m_41714_((Component)Component.m_237115_((String)"ui.inline.nothingtoshowoff"));
            }
            HoverEvent he = new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(stack));
            return new InlineMatch.DataMatch(new ItemInlineData(stack), Style.f_131099_.m_131144_(he));
        }, MatcherInfo.fromId(showOffID));
        InlineAPI.INSTANCE.addChatMatcher(showOffMatcher);
    }

    static {
        EQUIPMENT_ALIASES = Map.of("hand", "mainhand", "chestplate", "chest", "leggings", "legs", "helmet", "head", "boots", "feet", "shoes", "feet");
    }
}

