/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline;

import com.mojang.authlib.GameProfile;
import com.samsthenerd.inline.api.client.InlineClientAPI;
import com.samsthenerd.inline.api.client.renderers.InlineEntityRenderer;
import com.samsthenerd.inline.api.client.renderers.InlineItemRenderer;
import com.samsthenerd.inline.api.client.renderers.InlineSpriteRenderer;
import com.samsthenerd.inline.api.client.renderers.PlayerHeadRenderer;
import com.samsthenerd.inline.api.data.EntityInlineData;
import com.samsthenerd.inline.api.data.ItemInlineData;
import com.samsthenerd.inline.api.data.ModIconData;
import com.samsthenerd.inline.api.data.PlayerHeadData;
import com.samsthenerd.inline.api.matching.InlineMatch;
import com.samsthenerd.inline.api.matching.MatcherInfo;
import com.samsthenerd.inline.api.matching.RegexMatcher;
import com.samsthenerd.inline.xplat.IModMeta;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class InlineClient {
    public static void initClient() {
        InlineClient.addDefaultRenderers();
        InlineClient.addDefaultMatchers();
        InlineClient.addExtraHookTests();
    }

    private static void addDefaultRenderers() {
        InlineClientAPI.INSTANCE.addRenderer(InlineItemRenderer.INSTANCE);
        InlineClientAPI.INSTANCE.addRenderer(InlineEntityRenderer.INSTANCE);
        InlineClientAPI.INSTANCE.addRenderer(InlineSpriteRenderer.INSTANCE);
        InlineClientAPI.INSTANCE.addRenderer(PlayerHeadRenderer.INSTANCE);
    }

    private static void addDefaultMatchers() {
        ResourceLocation itemMatcherID = new ResourceLocation("inline", "item");
        InlineClientAPI.INSTANCE.addMatcher(new RegexMatcher.Standard("item", RegexMatcher.Standard.IDENTIFIER_REGEX_INSENSITIVE, itemMatcherID, itemId -> {
            ResourceLocation itemActualId = new ResourceLocation(itemId.toLowerCase());
            if (!BuiltInRegistries.f_257033_.m_7804_(itemActualId)) {
                return null;
            }
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemActualId);
            ItemStack stack = new ItemStack((ItemLike)item);
            HoverEvent he = new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(stack));
            return new InlineMatch.DataMatch(new ItemInlineData(stack), Style.f_131099_.m_131144_(he));
        }, MatcherInfo.fromId(itemMatcherID)));
        ResourceLocation entityMatcherID = new ResourceLocation("inline", "entity");
        InlineClientAPI.INSTANCE.addMatcher(new RegexMatcher.Standard("entity", RegexMatcher.Standard.IDENTIFIER_REGEX_INSENSITIVE, entityMatcherID, entityTypeId -> {
            ResourceLocation entTypeActualId = new ResourceLocation(entityTypeId.toLowerCase());
            if (!BuiltInRegistries.f_256780_.m_7804_(entTypeActualId)) {
                return null;
            }
            EntityType entType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(entTypeActualId);
            EntityInlineData entData = EntityInlineData.fromType(entType);
            return new InlineMatch.DataMatch(entData, Style.f_131099_.m_131144_(entData.getEntityDisplayHoverEvent()));
        }, MatcherInfo.fromId(entityMatcherID)));
        ResourceLocation modMatcherId = new ResourceLocation("inline", "modicon");
        InlineClientAPI.INSTANCE.addMatcher(new RegexMatcher.Standard("mod", "[0-9A-Za-z._-]+", modMatcherId, modid -> {
            String modidLowercase = modid.toLowerCase();
            Optional<IModMeta> maybeMod = IModMeta.getMod(modidLowercase);
            if (maybeMod.isEmpty()) {
                return null;
            }
            return new InlineMatch.DataMatch(new ModIconData(modidLowercase), ModIconData.getTooltipStyle(modidLowercase));
        }, MatcherInfo.fromId(modMatcherId)));
        ResourceLocation faceMatcherId = new ResourceLocation("inline", "playerface");
        InlineClientAPI.INSTANCE.addMatcher(new RegexMatcher.Standard("face", "[a-zA-Z0-9_]{1,16}", faceMatcherId, playerNameOrUUID -> {
            GameProfile profile = new GameProfile(null, playerNameOrUUID);
            PlayerHeadData headData = new PlayerHeadData(profile);
            return new InlineMatch.DataMatch(headData, Style.f_131099_.m_131144_(headData.getEntityDisplayHoverEvent()));
        }, MatcherInfo.fromId(faceMatcherId)));
    }

    private static void addExtraHookTests() {
    }
}

