/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.impl.extrahooks;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.samsthenerd.inline.api.client.extrahooks.ItemOverlayRenderer;
import com.samsthenerd.inline.utils.VCPImmediateButImLyingAboutIt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class ItemOverlayManager {
    private static final Map<Item, List<ItemOverlayRenderer>> ITEM_RENDERERS = new HashMap<Item, List<ItemOverlayRenderer>>();
    private static final Set<ItemOverlayRenderer> GLOBAL_RENDERERS = new HashSet<ItemOverlayRenderer>();

    public static List<ItemOverlayRenderer> getRenderers(Item item) {
        ArrayList<ItemOverlayRenderer> renderers = new ArrayList<ItemOverlayRenderer>(ITEM_RENDERERS.getOrDefault(item, List.of()));
        renderers.addAll(GLOBAL_RENDERERS);
        return renderers;
    }

    public static void addRenderer(Item item, ItemOverlayRenderer renderer) {
        ITEM_RENDERERS.computeIfAbsent(item, it -> new ArrayList()).add(renderer);
    }

    public static void addRenderer(ItemOverlayRenderer renderer) {
        GLOBAL_RENDERERS.add(renderer);
    }

    public static void removeRenderer(ItemOverlayRenderer renderer) {
        GLOBAL_RENDERERS.remove(renderer);
    }

    public static void renderDetailTexture(ItemStack stack, PoseStack matrices, ItemDisplayContext renderMode, MultiBufferSource vertexConsumers, int light, int overlay, boolean leftHanded) {
        if (renderMode != ItemDisplayContext.GUI) {
            return;
        }
        List<ItemOverlayRenderer> renderers = ItemOverlayManager.getRenderers(stack.m_41720_());
        for (ItemOverlayRenderer overlayRenderer : renderers) {
            MultiBufferSource.BufferSource immVC;
            if (!overlayRenderer.isActive(stack)) continue;
            boolean overItem = overlayRenderer.renderInFront(stack);
            if (overItem && vertexConsumers instanceof MultiBufferSource.BufferSource) {
                MultiBufferSource.BufferSource immediateVCs = (MultiBufferSource.BufferSource)vertexConsumers;
                RenderSystem.disableDepthTest();
                immediateVCs.m_109911_();
                RenderSystem.enableDepthTest();
                immVC = immediateVCs;
            } else {
                immVC = VCPImmediateButImLyingAboutIt.of(vertexConsumers);
            }
            GuiGraphics drawCtx = new GuiGraphics(Minecraft.m_91087_(), immVC);
            PoseStack ctxMat = drawCtx.m_280168_();
            ctxMat.m_85836_();
            ctxMat.m_252931_(matrices.m_85850_().m_252922_());
            ctxMat.m_85841_(0.0625f, -0.0625f, 0.0625f);
            ctxMat.m_252880_(0.0f, -16.0f, overItem ? 10.0f : -100.0f);
            overlayRenderer.render(stack, drawCtx);
            ctxMat.m_85849_();
        }
    }
}

