/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.collect.ImmutableMap;
import invtweaks.config.Category;
import invtweaks.config.ContOverride;
import invtweaks.config.Ruleset;
import invtweaks.network.PacketUpdateConfig;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class InvTweaksConfig {
    public static final ForgeConfigSpec CLIENT_CONFIG;
    public static final int NO_POS_OVERRIDE = -1418392593;
    public static final String NO_SPEC_OVERRIDE = "default";
    public static final Map<String, Category> DEFAULT_CATS;
    public static final List<String> DEFAULT_RAW_RULES;
    public static final Ruleset DEFAULT_RULES;
    public static final Map<String, ContOverride> DEFAULT_CONT_OVERRIDES;
    private static final ForgeConfigSpec.ConfigValue<List<? extends UnmodifiableConfig>> CATS;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> RULES;
    private static final ForgeConfigSpec.BooleanValue ENABLE_AUTOREFILL;
    private static final ForgeConfigSpec.BooleanValue ENABLE_QUICKVIEW;
    private static final ForgeConfigSpec.IntValue ENABLE_SORT;
    private static final ForgeConfigSpec.IntValue ENABLE_BUTTONS;
    private static final ForgeConfigSpec.ConfigValue<List<? extends UnmodifiableConfig>> CONT_OVERRIDES;
    private static final Map<UUID, Map<String, Category>> playerToCats;
    private static final Map<UUID, Ruleset> playerToRules;
    private static final Set<UUID> playerAutoRefill;
    private static final Map<UUID, Map<String, ContOverride>> playerToContOverrides;
    private static Map<String, Category> COMPILED_CATS;
    private static Ruleset COMPILED_RULES;
    private static Map<String, ContOverride> COMPILED_CONT_OVERRIDES;
    private static boolean isDirty;

    public static PacketUpdateConfig getSyncPacket() {
        return new PacketUpdateConfig((List)CATS.get(), (List)RULES.get(), (List)CONT_OVERRIDES.get(), (Boolean)ENABLE_AUTOREFILL.get());
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.CLIENT);
        executor.m_18689_(() -> InvTweaksConfig.setDirty(true));
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading configEvent) {
        BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.CLIENT);
        executor.m_18689_(() -> InvTweaksConfig.setDirty(true));
    }

    public static boolean isDirty() {
        return isDirty;
    }

    public static void setDirty(boolean newVal) {
        isDirty = newVal;
        if (isDirty) {
            COMPILED_CATS = InvTweaksConfig.cfgToCompiledCats((List)CATS.get());
            COMPILED_RULES = new Ruleset((List)RULES.get());
            COMPILED_CONT_OVERRIDES = InvTweaksConfig.cfgToCompiledContOverrides((List)CONT_OVERRIDES.get());
        }
    }

    public static Map<String, Category> getSelfCompiledCats() {
        return COMPILED_CATS;
    }

    public static Ruleset getSelfCompiledRules() {
        return COMPILED_RULES;
    }

    public static Map<String, ContOverride> getSelfCompiledContOverrides() {
        return COMPILED_CONT_OVERRIDES;
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    public static void setPlayerCats(Player ent, Map<String, Category> cats) {
        playerToCats.put(ent.m_20148_(), cats);
    }

    public static void setPlayerRules(Player ent, Ruleset ruleset) {
        playerToRules.put(ent.m_20148_(), ruleset);
    }

    public static void setPlayerAutoRefill(Player ent, boolean autoRefill) {
        if (autoRefill) {
            playerAutoRefill.add(ent.m_20148_());
        } else {
            playerAutoRefill.remove(ent.m_20148_());
        }
    }

    public static void setPlayerContOverrides(Player ent, Map<String, ContOverride> val) {
        playerToContOverrides.put(ent.m_20148_(), val);
    }

    public static Map<String, Category> getPlayerCats(Player ent) {
        if (DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> ent == Minecraft.m_91087_().f_91074_) == Boolean.TRUE) {
            return InvTweaksConfig.getSelfCompiledCats();
        }
        return playerToCats.getOrDefault(ent.m_20148_(), DEFAULT_CATS);
    }

    public static Ruleset getPlayerRules(Player ent) {
        if (DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> ent == Minecraft.m_91087_().f_91074_) == Boolean.TRUE) {
            return InvTweaksConfig.getSelfCompiledRules();
        }
        return playerToRules.getOrDefault(ent.m_20148_(), DEFAULT_RULES);
    }

    public static boolean getPlayerAutoRefill(Player ent) {
        if (DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> ent == Minecraft.m_91087_().f_91074_) == Boolean.TRUE) {
            return (Boolean)ENABLE_AUTOREFILL.get();
        }
        return playerAutoRefill.contains(ent.m_20148_());
    }

    public static ContOverride getPlayerContOverride(Player ent, String screenClass, String contClass) {
        Map<String, ContOverride> map = playerToContOverrides.getOrDefault(ent.m_20148_(), DEFAULT_CONT_OVERRIDES);
        if (DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> ent == Minecraft.m_91087_().f_91074_) == Boolean.TRUE) {
            map = InvTweaksConfig.getSelfCompiledContOverrides();
        }
        if (map.containsKey(screenClass)) {
            return map.get(screenClass);
        }
        if (map.containsKey(contClass)) {
            return map.get(contClass);
        }
        for (String s : map.keySet()) {
            Pattern regex = Pattern.compile(s);
            if (!regex.matcher(screenClass).matches() && !regex.matcher(contClass).matches()) continue;
            return map.get(s);
        }
        return null;
    }

    public static boolean isSortEnabled(boolean isPlayerSort) {
        return InvTweaksConfig.isFlagEnabled((Integer)ENABLE_SORT.get(), isPlayerSort);
    }

    public static boolean isButtonEnabled(boolean isPlayer) {
        return InvTweaksConfig.isFlagEnabled((Integer)ENABLE_BUTTONS.get(), isPlayer);
    }

    private static boolean isFlagEnabled(int flag, boolean isPlayer) {
        return flag == 3 || flag == (isPlayer ? 1 : 2);
    }

    public static boolean isQuickViewEnabled() {
        return (Boolean)ENABLE_QUICKVIEW.get();
    }

    public static Map<String, Category> cfgToCompiledCats(List<UnmodifiableConfig> lst) {
        LinkedHashMap<String, Category> catsMap = new LinkedHashMap<String, Category>();
        for (UnmodifiableConfig subCfg : lst) {
            String name = (String)subCfg.getOrElse("name", (Object)"");
            if (name.equals("") || name.startsWith("/")) continue;
            catsMap.put(name, new Category((List)subCfg.getOrElse("spec", Collections.emptyList())));
        }
        return catsMap;
    }

    public static Map<String, ContOverride> cfgToCompiledContOverrides(List<UnmodifiableConfig> lst) {
        LinkedHashMap<String, ContOverride> res = new LinkedHashMap<String, ContOverride>();
        for (UnmodifiableConfig subCfg : lst) {
            res.put((String)subCfg.getOrElse("containerClass", (Object)""), new ContOverride((Integer)subCfg.getOrElse("x", (Object)-1418392593), (Integer)subCfg.getOrElse("y", (Object)-1418392593), (String)subCfg.getOrElse("sortRange", (Object)NO_SPEC_OVERRIDE)));
        }
        return res;
    }

    static {
        DEFAULT_CATS = ImmutableMap.builder().put((Object)"sword", (Object)new Category("/instanceof:net.minecraft.world.item.SwordItem")).put((Object)"axe", (Object)new Category("/instanceof:net.minecraft.world.item.AxeItem")).put((Object)"pickaxe", (Object)new Category("/instanceof:net.minecraft.world.item.PickaxeItem")).put((Object)"shovel", (Object)new Category("/instanceof:net.minecraft.world.item.ShovelItem")).put((Object)"hoe", (Object)new Category("/instanceof:net.minecraft.world.item.HoeItem")).put((Object)"acceptableFood", (Object)new Category(String.format("/isFood:; !%s; !%s; !%s; !%s", ForgeRegistries.ITEMS.getKey((Object)Items.f_42583_), ForgeRegistries.ITEMS.getKey((Object)Items.f_42591_), ForgeRegistries.ITEMS.getKey((Object)Items.f_42675_), ForgeRegistries.ITEMS.getKey((Object)Items.f_42529_)))).put((Object)"torch", (Object)new Category(ForgeRegistries.ITEMS.getKey((Object)Items.f_42000_).toString())).put((Object)"cheapBlocks", (Object)new Category("/tag:forge:cobblestone", "/tag:minecraft:dirt")).put((Object)"blocks", (Object)new Category("/instanceof:net.minecraft.world.item.BlockItem")).build();
        DEFAULT_RAW_RULES = Arrays.asList("D /LOCKED", "A1-C9 /OTHER");
        DEFAULT_RULES = new Ruleset(DEFAULT_RAW_RULES);
        DEFAULT_CONT_OVERRIDES = ImmutableMap.builder().put((Object)"appeng.client.gui.implementations.*Screen", (Object)new ContOverride(-1418392593, -1418392593, "")).put((Object)"appeng.client.gui.me.items.*Screen", (Object)new ContOverride(-1418392593, -1418392593, "")).put((Object)"de.mari_023.ae2wtlib.wct.*Screen", (Object)new ContOverride(-1418392593, -1418392593, "")).put((Object)"com.github.glodblock.epp.client.gui.*", (Object)new ContOverride(-1418392593, -1418392593, "")).put((Object)"org.cyclops.integrateddynamics.inventory.container.*", (Object)new ContOverride(-1418392593, -1418392593, "")).put((Object)"org.cyclops.integratedterminals.inventory.container.ContainerTerminalStoragePart", (Object)new ContOverride(-1418392593, -1418392593, "")).put((Object)"com.refinedmods.refinedstorage.screen.*", (Object)new ContOverride(-1418392593, -1418392593, "")).put((Object)"net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer", (Object)new ContOverride(-1418392593, -1418392593, "")).put((Object)"net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu", (Object)new ContOverride(-1418392593, -1418392593, "")).put((Object)"tfar.craftingstation.CraftingStationMenu", (Object)new ContOverride(-1418392593, -1418392593, "")).put((Object)"tfar.dankstorage.container.DankContainers", (Object)new ContOverride(-1418392593, -1418392593, "")).put((Object)"mcjty.rftoolsutility.modules.crafter.blocks.CrafterContainer", (Object)new ContOverride(-1418392593, -1418392593, "")).put((Object)"gripe._90.megacells.menu.MEGAInterfaceMenu", (Object)new ContOverride(-1418392593, -1418392593, "")).put((Object)"cofh.thermal.core.client.gui.*", (Object)new ContOverride(-1418392593, -1418392593, "")).put((Object)"ironfurnaces.gui.furnaces.*", (Object)new ContOverride(-1418392593, -1418392593, "0-45")).put((Object)"com.direwolf20.justdirethings.client.screens.*", (Object)new ContOverride(-1418392593, -1418392593, "")).put((Object)"com.direwolf20.laserio.client.screens.*", (Object)new ContOverride(-1418392593, -1418392593, "")).put((Object)"com.stal111.forbidden_arcanus.client.gui.screen.*", (Object)new ContOverride(-1418392593, -1418392593, "")).put((Object)"aztech.modern_industrialization.*.gui.*Screen", (Object)new ContOverride(-1418392593, -1418392593, "")).build();
        playerToCats = new HashMap<UUID, Map<String, Category>>();
        playerToRules = new HashMap<UUID, Ruleset>();
        playerAutoRefill = new HashSet<UUID>();
        playerToContOverrides = new HashMap<UUID, Map<String, ContOverride>>();
        COMPILED_CATS = DEFAULT_CATS;
        COMPILED_RULES = DEFAULT_RULES;
        COMPILED_CONT_OVERRIDES = DEFAULT_CONT_OVERRIDES;
        isDirty = false;
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Sorting customization").push("sorting");
        CATS = builder.comment(new String[]{"Categor(y/ies) for sorting", "", "name: the name of the category", "", "spec:", "Each element denotes a series of semicolon-separated clauses", "Items need to match all clauses of at least one element", "Items matching earlier elements are earlier in order", "A clause of the form /tag:<tag_value> matches a tag", "Clauses /instanceof:<fully_qualified_name> or /class:<fully_qualified_name> check if item is", "instance of class or exactly of that class respectively", "Specifying an item's registry name as a clause checks for that item", "Prepending an exclamation mark at the start of a clause inverts it"}).defineList("category", DEFAULT_CATS.entrySet().stream().map(ent -> ((Category)ent.getValue()).toConfig((String)ent.getKey())).collect(Collectors.toList()), obj -> obj instanceof UnmodifiableConfig);
        RULES = builder.comment(new String[]{"Rules for sorting", "Each element is of the form <POS> <CATEGORY>", "A-D is the row from top to bottom", "1-9 is the column from left to right", "POS denotes the target slots", "Exs. POS = D3 means 3rd slot of hotbar", "     POS = B means 2nd row, left to right", "     POS = 9 means 9th column, bottom to top", "     POS = A1-C9 means slots A1,A2,\u2026,A9,B1,\u2026,B9,C1,\u2026,C9", "     POS = A9-C1 means slots A9,A8,\u2026,A1,B9,\u2026,B1,C9,\u2026,C1", "Append v to POS of the form A1-C9 to move in columns instead of rows", "Append r to POS of the form B or 9 to reverse slot order", "CATEGORY is the item category to designate the slots to", "CATEGORY = /LOCKED prevents slots from moving in sorting", "CATEGORY = /FROZEN has the effect of /LOCKED and, in addition, ignores slot in auto-refill", "CATEGORY = /OTHER covers all remaining items after other rules are exhausted"}).defineList("rules", DEFAULT_RAW_RULES, obj -> obj instanceof String);
        CONT_OVERRIDES = builder.comment(new String[]{"Custom settings per GUI", "x = x-position of external sort button relative to GUI top left", "y = same as above except for the y-position", "Omit x and y to leave position unchanged", "sortRange = slots to sort", "E.g. sortRange = \"5,0-2\" sorts slots 5,0,1,2 in that order", "sortRange = \"\" disables sorting for that container", "Out-of-bound slots are ignored", "Omit sortRange to leave as default"}).defineList("containerOverrides", DEFAULT_CONT_OVERRIDES.entrySet().stream().map(ent -> ((ContOverride)ent.getValue()).toConfig((String)ent.getKey())).collect(Collectors.toList()), obj -> obj instanceof UnmodifiableConfig);
        builder.pop();
        builder.comment("Tweaks").push("tweaks");
        ENABLE_AUTOREFILL = builder.comment("Enable auto-refill").define("autoRefill", true);
        ENABLE_QUICKVIEW = builder.comment("Enable a quick view of how many items that you're currently holding exists in your inventory by displaying it next your hotbar.").define("quickView", true);
        ENABLE_SORT = builder.comment(new String[]{"0 = disable sorting", "1 = player sorting only", "2 = external sorting only", "3 = all sorting enabled (default)"}).defineInRange("enableSort", 3, 0, 3);
        ENABLE_BUTTONS = builder.comment(new String[]{"0 = disable buttons (i.e. keybind only)", "1 = buttons for player sorting only", "2 = buttons for external sorting only", "3 = all buttons enabled (default)"}).defineInRange("enableButtons", 3, 0, 3);
        builder.pop();
        CLIENT_CONFIG = builder.build();
    }
}

