/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network.slot;

import com.enderio.core.common.network.slot.NetworkDataSlot;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class NBTSerializingNetworkDataSlot<T>
extends NetworkDataSlot<T> {
    private final Function<T, CompoundTag> toNBT;
    private final BiConsumer<T, CompoundTag> handleNBT;
    private final BiConsumer<T, FriendlyByteBuf> toBuffer;
    private final Function<FriendlyByteBuf, T> fromBuffer;

    public NBTSerializingNetworkDataSlot(Supplier<T> getter, Function<T, CompoundTag> toNBT, BiConsumer<T, CompoundTag> handleNBT, BiConsumer<T, FriendlyByteBuf> toBuffer, Function<FriendlyByteBuf, T> fromBuffer) {
        super(getter, null);
        this.toNBT = toNBT;
        this.handleNBT = handleNBT;
        this.toBuffer = toBuffer;
        this.fromBuffer = fromBuffer;
    }

    @Override
    public Tag serializeValueNBT(T value) {
        return (Tag)this.toNBT.apply(value);
    }

    @Override
    protected T valueFromNBT(Tag nbt) {
        return null;
    }

    @Override
    public void fromNBT(Tag nbt) {
        if (!(nbt instanceof CompoundTag)) {
            throw new IllegalStateException("Invalid compound tag was passed over the network.");
        }
        CompoundTag compoundTag = (CompoundTag)nbt;
        this.handleNBT.accept(this.getter.get(), compoundTag);
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, T value) {
        this.toBuffer.accept(value, buf);
    }

    @Override
    public void fromBuffer(FriendlyByteBuf buf) {
        try {
            this.fromBuffer.apply(buf);
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid compound tag buffer was passed over the network.");
        }
    }

    @Override
    protected T valueFromBuffer(FriendlyByteBuf buf) {
        return null;
    }
}

